package com.ejianc.business.signaturemanage.hystrix;

import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import feign.Response;
import org.springframework.stereotype.Component;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description 签章通用接口服务熔断降级
 */
@Component
public class SignatureCommonHystrix implements ISignatureCommonApi {


    /**
     * 合同文件添加水印
     *
     * @param watermarkVO 合同文件添加水印参数
     * @return OutputStream    输出流
     */
    @Override
    public Response addWatermark(WatermarkVO watermarkVO) {
        throw new BusinessException("合同文件添加水印失败!");
    }

    /**
     * 获取加水印的合同附件
     *
     * @param watermarkVO 合同文件添加水印参数
     * @return AttachmentVO 文件中心的水印附件
     */
    @Override
    public AttachmentVO fetchWatermarkAttachment(WatermarkVO watermarkVO) {
        throw new BusinessException("获取加水印的合同附件失败!");
    }
}
