package com.ejianc.business.signaturemanage.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author baipengyan
 * @date 2022/6/2
 * @description 发起签章VO
 */
public class SignatureVO {
	private static final long serialVersionUID = 5711367579481568764L;

	@NotNull(message = "PM系统合同id「billId」不能为空！")
	private Long billId; // PM系统合同id
	@NotBlank(message = "单据类型「billType」不能为空！")
	private String billType; // 单据类型
	@NotBlank(message = "单据编号「billCode」不能为空！")
	private String billCode; // 单据编号
	@NotBlank(message = "单据名称「billName」不能为空！")
	private String billName; // 单据名称
	private String contractName; // 合同名称
	private BigDecimal contractTaxMny; // 合同金额(含税)
	private Long projectId; // 项目id
	private String projectCode; // 项目编号
	private String projectName; // 项目名称
	@NotBlank(message = "全局唯一标识「billRefCode」不能为空！")
	private String billRefCode; // 全局唯一标识
	@NotNull(message = "合同文件id「billDocId」不能为空！")
	private Long billDocId; // 合同文件id
	private String billDocumentName; // 文件名称
	private String billDocumentType; // 文件类型
	@NotBlank(message = "发起方名称「tenantName」不能为空！")
	private String tenantName; // 发起方名称
	private String signRequirements; // 签署要求
	private String creatorName; // 创建人名称
	private String creatorContact; // 创建人联系方式
	@NotNull(message = "主题 (签章主题：PM系统：单据名称-单据编号)「subject」不能为空！")
	private String subject; // 主题 (签章主题：PM系统：单据名称-单据编号)

	@Valid
	@NotEmpty(message = "签署方「signatoryVOS」不能为空！")
	private List<SignatoryVO> signatoryVOS = new ArrayList<>(); // 签署方

	public Long getBillId() {
		return billId;
	}

	public void setBillId(Long billId) {
		this.billId = billId;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public BigDecimal getContractTaxMny() {
		return contractTaxMny;
	}

	public void setContractTaxMny(BigDecimal contractTaxMny) {
		this.contractTaxMny = contractTaxMny;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getBillRefCode() {
		return billRefCode;
	}

	public void setBillRefCode(String billRefCode) {
		this.billRefCode = billRefCode;
	}

	public Long getBillDocId() {
		return billDocId;
	}

	public void setBillDocId(Long billDocId) {
		this.billDocId = billDocId;
	}

	public String getBillDocumentName() {
		return billDocumentName;
	}

	public void setBillDocumentName(String billDocumentName) {
		this.billDocumentName = billDocumentName;
	}

	public String getBillDocumentType() {
		return billDocumentType;
	}

	public void setBillDocumentType(String billDocumentType) {
		this.billDocumentType = billDocumentType;
	}

	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public String getSignRequirements() {
		return signRequirements;
	}

	public void setSignRequirements(String signRequirements) {
		this.signRequirements = signRequirements;
	}

	public String getCreatorName() {
		return creatorName;
	}

	public void setCreatorName(String creatorName) {
		this.creatorName = creatorName;
	}

	public String getCreatorContact() {
		return creatorContact;
	}

	public void setCreatorContact(String creatorContact) {
		this.creatorContact = creatorContact;
	}

	public List<SignatoryVO> getSignatoryVOS() {
		return signatoryVOS;
	}

	public void setSignatoryVOS(List<SignatoryVO> signatoryVOS) {
		this.signatoryVOS = signatoryVOS;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}
}
