package com.ejianc.business.signaturemanage.api;

import com.ejianc.business.signaturemanage.hystrix.SignatureCommonHystrix;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description 签章通用接口
 */
@FeignClient(
		name = "ejc-signaturemanage-web",
		url = "${common.env.feign-client-url}",
		path = "ejc-signaturemanage-web",
		fallback = SignatureCommonHystrix.class
)
public interface ISignatureCommonApi {

	String API_PREFIX = "/common";

	/**
	 * 合同文件添加水印
	 *
	 * @param watermarkVO 合同文件添加水印参数
	 *
	 * @return Response    feign.Response
	 */
	@PostMapping(value = API_PREFIX + "/addWatermark", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
	Response addWatermark(@RequestBody WatermarkVO watermarkVO);

	/**
	 * 获取加水印的合同附件
	 *
	 * @param watermarkVO 合同文件添加水印参数
	 *
	 * @return AttachmentVO 文件中心的水印附件
	 */
	@PostMapping(value = API_PREFIX + "/fetchWatermarkAttachment")
	AttachmentVO fetchWatermarkAttachment(@RequestBody WatermarkVO watermarkVO);

	/**
	 * 根据参数生成水印配置
	 *
	 * @param fileId     要加水印的文件id
	 * @param billId     业务id
	 * @param billCode   合同编码
	 * @param billType   单据类型编码
	 * @param sourceType 业务类型编码
	 *
	 * @return WatermarkVO 水印配置
	 */
	@Deprecated
	@GetMapping(value = API_PREFIX + "/fetchWatermarkConfig")
	WatermarkVO fetchWatermarkConfig(@RequestParam(value = "fileId", required = true) Long fileId,
	                                 @RequestParam(value = "billId", required = true) Long billId,
	                                 @RequestParam(value = "billCode", required = true) String billCode,
	                                 @RequestParam(value = "billType", required = true) String billType,
	                                 @RequestParam(value = "sourceType", required = true) String sourceType);

	/**
	 * 根据合同获取文件中心已签章的合同信息
	 *
	 * @param contracts 合同
	 *
	 * @return List<SignMgrPreviewVO> 已签章的合同信息
	 */
	@PostMapping(value = API_PREFIX + "/fetchSignedContract")
	CommonResponse<List<SignMgrPreviewVO>> fetchSignedContract(@RequestBody List<ContractVO> contracts);
}