package com.ejianc.business.signaturemanage.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author baipengyan
 * @date 2022/6/6
 * @description 签署方VO
 */
public class SignatoryVO {
	private static final long serialVersionUID = -5954609703934702545L;
	@Valid
	@NotEmpty(message = "签署动作「signatoryActionVOS」不能为空！")
	List<SignatoryActionVO> signatoryActionVOS = new ArrayList<>(); // 签署动作
	@NotBlank(message = "签署方名称「tenantName」不能为空！")
	private String tenantName; // 签署方名称
	@NotBlank(message = "签署方类型「tenantType」不能为空！")
	private String tenantType; // 签署方类型：COMPANY（企业），PERSONAL（个人）
	private String signatoryNo; // 签署方编号，作为该签署方的唯一识别
	@NotNull(message = "单位类型「signatureType」不能为空！")
	private Integer signatureType; // 单位类型：0-内部单位，1-外部单位
	@NotNull(message = "签署顺序「signOrder」不能为空！")
	private Integer signOrder; // 签署顺序,前置设置1，后置逐渐增大，无序设置相同
	private String receiverName; // 接收人姓名
	private String contact; // 接收人联系方式：手机号、电子邮箱号

	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public String getTenantType() {
		return tenantType;
	}

	public void setTenantType(String tenantType) {
		this.tenantType = tenantType;
	}

	public String getSignatoryNo() {
		return signatoryNo;
	}

	public void setSignatoryNo(String signatoryNo) {
		this.signatoryNo = signatoryNo;
	}

	public Integer getSignatureType() {
		return signatureType;
	}

	public void setSignatureType(Integer signatureType) {
		this.signatureType = signatureType;
	}

	public Integer getSignOrder() {
		return signOrder;
	}

	public void setSignOrder(Integer signOrder) {
		this.signOrder = signOrder;
	}

	public String getReceiverName() {
		return receiverName;
	}

	public void setReceiverName(String receiverName) {
		this.receiverName = receiverName;
	}

	public String getContact() {
		return contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}

	public List<SignatoryActionVO> getSignatoryActionVOS() {
		return signatoryActionVOS;
	}

	public void setSignatoryActionVOS(List<SignatoryActionVO> signatoryActionVOS) {
		this.signatoryActionVOS = signatoryActionVOS;
	}
}
