package com.ejianc.business.signaturemanage.vo;

import javax.validation.constraints.NotBlank;

/**
 * @author baipengyan
 * @date 2022/5/19
 * @description 水印参数配置
 */
public class WatermarkConfigVO {
    @NotBlank(message = "水印类型不能为空")
    private String type; // 水印类型
    private String content; // 文字水印内容
    private String imageBase64; // 水印图片（Base64格式）
    private Integer fontSize; // 字体大小，默认16
    private String color; // 字体颜色（16进制颜色值,需携带#），默认#999999
    private Double rotateAngle; // 旋转角度，默认0，取值范围0-180
    private Double transparency; // 透明度，默认0.3，取值范围为0-1
    @NotBlank(message = "水印位置不能为空")
    private String location; // 水印位置：UPPER_LEFT（左上角），UPPER_RIGHT（右上角），LOWER_LEFT（左下角），LOWER_RIGHT（右下角），MIDDLE_CENTER（居中），TILE（平铺），FILL（填充）

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getImageBase64() {
        return imageBase64;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public Integer getFontSize() {
        return fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Double getRotateAngle() {
        return rotateAngle;
    }

    public void setRotateAngle(Double rotateAngle) {
        this.rotateAngle = rotateAngle;
    }

    public Double getTransparency() {
        return transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}
