package com.ejianc.business.signaturemanage.vo;

import com.ejianc.foundation.file.vo.AttachmentVO;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author baipengyan
 * @date 2022/5/18
 * @description 合同文件添加水印参数
 */
public class WatermarkVO {
    @Valid
    @NotEmpty(message = "水印参数配置不能为空")
    List<WatermarkConfigVO> watermarkConfigs = new ArrayList<>(); // 水印参数配置
    @NotBlank(message = "水印方案不能为空")
    private String scheme; // 方案
    @NotNull(message = "合同文件id不能为空")
    private Long fileId; // 合同文件id
    private Long billId; // 业务id
    private String billType; // 业务类型
    private String sourceType; // 单据类型

    //水印结果文件，非PM文件系统实现时，使用该字段
    private File resultFile;
    //水印结果文件，PM文件系统实现时，使用该字段
    private AttachmentVO resultAttach;

    public File getResultFile() {
        return resultFile;
    }

    public void setResultFile(File resultFile) {
        this.resultFile = resultFile;
    }

    public AttachmentVO getResultAttach() {
        return resultAttach;
    }

    public void setResultAttach(AttachmentVO resultAttach) {
        this.resultAttach = resultAttach;
    }

    public String getScheme() {
        return scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public List<WatermarkConfigVO> getWatermarkConfigs() {
        return watermarkConfigs;
    }

    public void setWatermarkConfigs(List<WatermarkConfigVO> watermarkConfigs) {
        this.watermarkConfigs = watermarkConfigs;
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
