package com.ejianc.business.signaturemanage.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */
public class SignatureSettingVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 单位名称
     */
    private String unitName;
    /**
     * 单位类别
     */
    private String unitCategory;
    /**
     * 状态，1-启用，0-停用
     */
    private Integer enableStatus;

    /**
     * 状态 导出专用
     */
    private String enableStatusStr;

    private Long unitId;
    /**
     * 默认用章名
     */
    private String defaultSealName;

    /**
     * 单据编码
     */
    private String code;
    /**
     * 创建人 自用
     */
    private String createName;

    /**
     * 创建人id 自用
     */
    private Long createId;


    /**
     * 创建时间 自用
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sealCreateTime;

    /**
     * 创建时间 自用 到出用
     */
    private String sealCreateTimeStr;
    private List<SignatureSettingSubVO> settingSubVoS = new ArrayList<>();

    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getSealCreateTime() {
        return sealCreateTime;
    }

    public void setSealCreateTime(Date sealCreateTime) {
        this.sealCreateTime = sealCreateTime;
    }

    @ReferDeserialTransfer
    public Long getCreateId() {
        return createId;
    }

    public void setCreateId(Long createId) {
        this.createId = createId;
    }

    public List<SignatureSettingSubVO> getSettingSubVoS() {
        return settingSubVoS;
    }

    public void setSettingSubVoS(List<SignatureSettingSubVO> settingSubVoS) {
        this.settingSubVoS = settingSubVoS;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEnableStatusStr() {
        return enableStatusStr;
    }

    public void setEnableStatusStr(String enableStatusStr) {
        this.enableStatusStr = enableStatusStr;
    }

    public String getSealCreateTimeStr() {
        return sealCreateTimeStr;
    }

    public void setSealCreateTimeStr(String sealCreateTimeStr) {
        this.sealCreateTimeStr = sealCreateTimeStr;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitCategory() {
        return unitCategory;
    }

    public void setUnitCategory(String unitCategory) {
        this.unitCategory = unitCategory;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }
    public String getDefaultSealName() {
        return defaultSealName;
    }

    public void setDefaultSealName(String defaultSealName) {
        this.defaultSealName = defaultSealName;
    }

}
