package com.ejianc.business.signaturemanage.api;


import com.ejianc.business.signaturemanage.hystrix.SupplierCloudUrlHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "ejc-signaturemanage-web", url = "${common.env.feign-client-url}", path = "ejc-signaturemanage-web", fallback = SupplierCloudUrlHystrix.class)
public interface ISupplierApi {
    /**
     * 获取公有云合同签署短链接
     *
     * @param contractId
     * @param contact
     * @return cloudSignUrl
     */
    @PostMapping(value = "/api/supplier/getCloudSignUrl")
    CommonResponse<String> cloudSignUrl(@RequestBody Long contractId, String contact);
}
