package com.ejianc.business.signaturemanage.hystrix;

import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description 签章通用接口服务熔断降级
 */
@Component
public class SignatureCommonHystrix implements ISignatureCommonApi {


	/**
	 * 合同文件添加水印
	 *
	 * @param watermarkVO 合同文件添加水印参数
	 *
	 * @return OutputStream    输出流
	 */
	@Override
	public Response addWatermark(WatermarkVO watermarkVO) {
		throw new BusinessException("合同文件添加水印失败!");
	}

	/**
	 * 获取加水印的合同附件
	 *
	 * @param watermarkVO 合同文件添加水印参数
	 *
	 * @return AttachmentVO 文件中心的水印附件
	 */
	@Override
	public AttachmentVO fetchWatermarkAttachment(WatermarkVO watermarkVO) {
		throw new BusinessException("获取加水印的合同附件失败!");
	}

	/**
	 * 根据参数生成水印配置
	 *
	 * @param fileId     要加水印的文件id
	 * @param billId     业务id
	 * @param billCode   合同编码
	 * @param billType   单据类型编码
	 * @param sourceType 业务类型编码
	 *
	 * @return WatermarkVO 水印配置
	 */
	@Override
	public WatermarkVO fetchWatermarkConfig(Long fileId, Long billId, String billCode, String billType, String sourceType) {
		throw new BusinessException("根据参数生成水印配置失败!");
	}

	/**
	 * 根据合同获取文件中心已签章的合同信息
	 *
	 * @param contracts 合同
	 *
	 * @return List<SignMgrPreviewVO> 已签章的合同信息
	 */
	@Override
	public CommonResponse<List<SignMgrPreviewVO>> fetchSignedContract(List<ContractVO> contracts) {
		throw new BusinessException("获取文件中心已签章的合同信息!");
	}
}
