package com.ejianc.business.signaturemanage.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author baipengyan
 * @date 2022/6/6
 * @description 签署方的签署动作VO
 */
public class SignatoryActionVO {
	private static final long serialVersionUID = -6453313086876027369L;
	List<SignatoryRectVO> signatoryRectVOS = new ArrayList<>(); // 签署位置
	private String sealId; // PM系统印章id
	private String sealName; // PM系统印章名称
	private String signatureUserIds; // 印章使用者，平台用户id范围（静态）多个逗号分隔
	private String sourceSealId; // 第三方电子签章印章id
	private String sourceSealName; // 第三方电子签章印章名称
	@NotBlank(message = "签署动作类型「signActionType」不能为空！")
	private String signActionType; // 签署动作类型:CORPORATE（企业签章），PERSONAL（个人签字），LP（法定代表人签字）
	private String actionNo; // 签署动作编号，唯一
	@NotBlank(message = "签署动作名称「name」不能为空！")
	private String name; // 签署动作名称
	@NotNull(message = "签章顺序「sealSignOrder」不能为空！")
	private Integer sealSignOrder; // 签署顺序,前置设置1，后置逐渐增大，无序设置相同
	private Boolean autoSign; // 是否自动签署，默认不自动签署
	@Valid
	@NotEmpty(message = "签署人「operatorVOS」不能为空！")
	private List<OperatorVO> operatorVOS = new ArrayList<>(); // 签署人

	public String getSealId() {
		return sealId;
	}

	public void setSealId(String sealId) {
		this.sealId = sealId;
	}

	public String getSealName() {
		return sealName;
	}

	public void setSealName(String sealName) {
		this.sealName = sealName;
	}

	public String getSignatureUserIds() {
		return signatureUserIds;
	}

	public void setSignatureUserIds(String signatureUserIds) {
		this.signatureUserIds = signatureUserIds;
	}

	public String getSourceSealId() {
		return sourceSealId;
	}

	public void setSourceSealId(String sourceSealId) {
		this.sourceSealId = sourceSealId;
	}

	public String getSourceSealName() {
		return sourceSealName;
	}

	public void setSourceSealName(String sourceSealName) {
		this.sourceSealName = sourceSealName;
	}

	public String getSignActionType() {
		return signActionType;
	}

	public void setSignActionType(String signActionType) {
		this.signActionType = signActionType;
	}

	public String getActionNo() {
		return actionNo;
	}

	public void setActionNo(String actionNo) {
		this.actionNo = actionNo;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getSealSignOrder() {
		return sealSignOrder;
	}

	public void setSealSignOrder(Integer sealSignOrder) {
		this.sealSignOrder = sealSignOrder;
	}

	public Boolean getAutoSign() {
		return autoSign;
	}

	public void setAutoSign(Boolean autoSign) {
		this.autoSign = autoSign;
	}

	public List<OperatorVO> getOperatorVOS() {
		return operatorVOS;
	}

	public void setOperatorVOS(List<OperatorVO> operatorVOS) {
		this.operatorVOS = operatorVOS;
	}

	public List<SignatoryRectVO> getSignatoryRectVOS() {
		return signatoryRectVOS;
	}

	public void setSignatoryRectVOS(List<SignatoryRectVO> signatoryRectVOS) {
		this.signatoryRectVOS = signatoryRectVOS;
	}
}
