package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 签章管理
 * 
 * @author generator
 * 
 */
public interface ISignMgrService extends IBaseService<SignMgrEntity> {

    SignMgrEntity selectBycontractId(Long contractId);

    /**
     * 用文件创建合同文档
     * @param signMgrVO
     * @return
     */
    Long createByFile(SignMgrVO signMgrVO);


    /**
     * 创建合同
     * @param documentId
     * @param signMgrVO
     * @return
     */
    Long createContractByCategory(Long documentId,SignMgrVO signMgrVO);


    /**
     * 每个节点签署完成
     * @param map
     */
    void internalFlow(Map<String,String> map);


    /**
     * 所有接收方签署完成
     * @param map
     */
    void AllReceiverComplate(Map<String, String> map);

    /**
     * 下一个待签章的人员列表
     * @param contractId
     * @param maxSignOrder
     * @param maxSealSignOrder
     * @return
     */
    List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder);

    /**
     * 发送消息
     * @param operators
     * @return
     */
    CommonResponse<String> sendMessage(List<SignMgrSignatoryEntity> operators);
}
