package com.ejianc.business.signaturemanage.enums;

public enum SignMgrSignatoryEnum {

    // 任务状态 0-待激活，1-待签章，2-已完成
    TO_BE_ACTIVATED("待激活",0),
    TO_BE_SIGNED("待签章",1),
    COMPLETED("已完成",2),

    // 签署方类型：0-内部单位，1-外部单位
    INTERNAL_UNIT("内部单位",0),
    EXTERNAL_UNIT("外部单位",1),

    // 签署结果状态 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
    SIGNED("已签章（已完成）",1),
    RETURNED("已退回（已拒签）",2),
    WITHDRAWN("已撤回",3),
    EXPIRED("已过期",4),
    OTHER("其他",5);

    private final String description;
    private final Integer value;

    SignMgrSignatoryEnum(String description, Integer value) {
        this.description = description;
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public Integer getValue() {
        return value;
    }
}
