/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.SignMgrMapper;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.InitSignatoryVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.SealInfoVO;
import com.ejianc.business.signaturemanage.vo.SignMgrSignatoryVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.business.signaturemanage.vo.SignatoryVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.Action;
import net.qiyuesuo.sdk.bean.contract.ActionType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Operator;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="signMgrService")
public class SignMgrServiceImpl
extends BaseServiceImpl<SignMgrMapper, SignMgrEntity>
implements ISignMgrService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    ISignMgrLogService signMgrLogService;
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SignMgrMapper signMgrMapper;

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    @Override
    public SignMgrEntity selectBycontractId(Long contractId) {
        return this.signMgrMapper.selectBycontractId(contractId);
    }

    @Override
    public Long createByFile(SignMgrVO signMgrVO) {
        if (signMgrVO.getBillDocId() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signMgrVO.getBillDocumentType() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signMgrVO.getBillDocumentName() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateDocumentRequest request = new CreateDocumentRequest();
        ClassPathResource resource = new ClassPathResource("doc/\u52b3\u52a1\u5206\u5305\u5408\u540c\u8303\u672c\uff08\u94a2\u7b4b\uff09.docx");
        try {
            request.setFile((FileItem)new StreamFile((InputStream)new FileInputStream(resource.getFile())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        request.setFileType(signMgrVO.getBillDocumentType());
        request.setTitle(signMgrVO.getBillDocumentName());
        CreateDocumentResult result = null;
        try {
            result = contractService.createByFile(request);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
        }
        Long documentId = result.getDocumentId();
        this.logger.info("\u521b\u5efa\u5408\u540c\u6587\u4ef6\u6210\u529f,documentId:{}", (Object)documentId);
        return documentId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createContractByCategory(Long documentId, SignMgrVO signMgrVO) {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setCategoryId(this.categoryId);
        createContractRequest.setSubject(signMgrVO.getBillDocumentName());
        createContractRequest.setSend(Boolean.valueOf(true));
        ArrayList<Long> documents = new ArrayList<Long>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        createContractRequest.setDescription(signMgrVO.getSignRequirements());
        createContractRequest.setCreatorName(signMgrVO.getCreatorName());
        createContractRequest.setCreatorContact(signMgrVO.getCreatorContact());
        createContractRequest.setTenantName(signMgrVO.getTenantName());
        ArrayList signatories = new ArrayList();
        List signMgrSignatoryVos = signMgrVO.getSignMgrSignatoryEntities();
        signMgrSignatoryVos.sort(Comparator.comparing(SignMgrSignatoryVO::getSignOrder).thenComparing(SignMgrSignatoryVO::getSealSignOrder));
        Map<Integer, List<SignMgrSignatoryVO>> signGroupBy = signMgrSignatoryVos.stream().collect(Collectors.groupingBy(SignMgrSignatoryVO::getSignOrder));
        signGroupBy.forEach((k, v) -> {
            Signatory signatory = new Signatory();
            signatory.setTenantType(TenantType.valueOf((String)((SignMgrSignatoryVO)v.get(0)).getTenantType()));
            signatory.setTenantName(((SignMgrSignatoryVO)v.get(0)).getTenantName());
            if (!Objects.equals(((SignMgrSignatoryVO)v.get(0)).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                signatory.setReceiverName(((SignMgrSignatoryVO)v.get(0)).getSignatureName());
                signatory.setContact(((SignMgrSignatoryVO)v.get(0)).getSignatureContact());
            }
            signatory.setSerialNo(((SignMgrSignatoryVO)v.get(0)).getSignOrder());
            ArrayList<Action> actions = new ArrayList<Action>();
            ArrayList lst = new ArrayList();
            Map<Integer, List<SignMgrSignatoryVO>> actionsMap = v.stream().collect(Collectors.groupingBy(SignMgrSignatoryVO::getSealSignOrder));
            Set<Map.Entry<Integer, List<SignMgrSignatoryVO>>> entries = actionsMap.entrySet();
            for (Map.Entry<Integer, List<SignMgrSignatoryVO>> entry : entries) {
                Action action = new Action();
                List<SignMgrSignatoryVO> actionList = entry.getValue();
                action.setType(ActionType.valueOf((String)actionList.get(0).getSignActionType()));
                action.setName(actionList.get(0).getName());
                action.setSerialNo(actionList.get(0).getSealSignOrder());
                action.setActionNo(actionList.get(0).getActionNo());
                ArrayList<Operator> operators = new ArrayList<Operator>();
                for (SignMgrSignatoryVO s : actionList) {
                    Operator operator = new Operator();
                    operator.setOperatorName(s.getSignatureName());
                    operator.setOperatorContact(s.getSignatureContact());
                    operators.add(operator);
                }
                action.setActionOperators(operators);
                if (Objects.equals(((SignMgrSignatoryVO)v.get(0)).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    // empty if block
                }
                actions.add(action);
            }
            signatory.setActions(actions);
            signatories.add(signatory);
        });
        createContractRequest.setSignatories(signatories);
        Long contractId = null;
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e) {
            this.logger.info("\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c\u5408\u540c\u6587\u6863id\uff1a{}\u4e1a\u52a1id:{}\uff0c\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{documentId, signMgrVO.getBillId(), signMgrVO.getBillType()});
            e.printStackTrace();
        }
        if (contractId != null) {
            this.logger.info("\u521b\u5efa\u5408\u540c\u6210\u529f,contractId:{}\uff0c\u5408\u540c\u6587\u6863id\uff1a{}\u4e1a\u52a1id:{}\uff0c\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{contractId, documentId, signMgrVO.getBillId(), signMgrVO.getBillType()});
            SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)BeanMapper.map((Object)signMgrVO, SignMgrEntity.class));
            signMgrEntity.setSourceBillId(contractId);
            signMgrEntity.setSourceDocId(documentId);
            List<SignMgrSignatoryEntity> signMgrSignatoryEntities = signMgrEntity.getSignMgrSignatoryEntities();
            for (SignMgrSignatoryEntity s : signMgrSignatoryEntities) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
            }
            signMgrEntity.setSignMgrSignatoryEntities(signMgrSignatoryEntities);
            this.saveOrUpdate((Object)signMgrEntity, false);
        }
        return contractId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void internalFlow(Map<String, String> map) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_bill_id", (Object)Long.valueOf(map.get("contractId")));
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.getOne((Wrapper)queryWrapper));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
        List sig = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
        String action = map.get("action");
        JSONObject jsonObject = JSONObject.parseObject((String)action);
        String actionNo = jsonObject.getString("actionNO");
        List signMgrSignatoryEntity = sig.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());
        for (SignMgrSignatoryEntity mgrSignatoryEntity : signMgrSignatoryEntity) {
            mgrSignatoryEntity.setJobStatus(SignMgrSignatoryEnum.COMPLETED.getValue());
            switch (jsonObject.getString("status")) {
                case "SIGNED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.SIGNED.getValue());
                    break;
                }
                case "REJECTED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.RETURNED.getValue());
                    break;
                }
                case "DISCARDED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.WITHDRAWN.getValue());
                }
                default: {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.OTHER.getValue());
                }
            }
            mgrSignatoryEntity.setActualSignatoryName(map.get("operatorName"));
            mgrSignatoryEntity.setActualSignatoryContact(map.get("operatorMobile"));
            if (mgrSignatoryEntity.getSignatureId() == null) {
                mgrSignatoryEntity.setActualSignatoryId(null);
            } else {
                mgrSignatoryEntity.setActualSignatoryId(mgrSignatoryEntity.getSignatureId());
            }
            try {
                mgrSignatoryEntity.setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("createTime")));
                mgrSignatoryEntity.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("completeTime")));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)mgrSignatoryEntity.getId());
            updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, (Object)mgrSignatoryEntity.getJobStatus());
            updateWrapper.set(SignMgrSignatoryEntity::getSignResult, (Object)mgrSignatoryEntity.getSignResult());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryId, (Object)mgrSignatoryEntity.getActualSignatoryId());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryName, (Object)mgrSignatoryEntity.getActualSignatoryName());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryContact, (Object)mgrSignatoryEntity.getActualSignatoryContact());
            updateWrapper.set(SignMgrSignatoryEntity::getStartTime, (Object)mgrSignatoryEntity.getStartTime());
            updateWrapper.set(SignMgrSignatoryEntity::getEndTime, (Object)mgrSignatoryEntity.getEndTime());
            this.signMgrSignatoryService.update((Wrapper)updateWrapper);
            SignMgrSignatoryEntity sms = (SignMgrSignatoryEntity)((Object)this.signMgrSignatoryService.selectById(mgrSignatoryEntity.getId()));
            SignMgrLogEntity sml = (SignMgrLogEntity)((Object)BeanMapper.map((Object)((Object)sms), SignMgrLogEntity.class));
            sml.setBillId(signMgrEntity.getBillId());
            sml.setBillType(signMgrEntity.getBillType());
            sml.setBillDocId(signMgrEntity.getBillDocId());
            sml.setBillDocumentName(signMgrEntity.getBillDocumentName());
            sml.setBillDocumentType(signMgrEntity.getBillDocumentType());
            sml.setSignRequirements(signMgrEntity.getSignRequirements());
            sml.setThirdSysCallbackContractId(Long.valueOf(map.get("contractId")));
            sml.setThirdSysCallbackTenantId(map.get("tenantId"));
            sml.setThirdSysCallbackTenantName(map.get("tenantName"));
            sml.setThirdSysCallbackSn(map.get("sn"));
            sml.setThirdSysCallbackStatus(map.get("status"));
            sml.setThirdSysCallbackType(map.get("type"));
            sml.setThirdSysCallbackContact(map.get("contact"));
            sml.setThirdSysCallbackOperatorName(map.get("operatorName"));
            sml.setThirdSysCallbackOperatorMobile(map.get("operatorMobile"));
            this.signMgrLogService.saveOrUpdate((Object)sml, false);
        }
        Integer maxSignOrder = ((SignMgrSignatoryEntity)((Object)signMgrSignatoryEntity.get(0))).getSignOrder();
        Integer maxSealSignOrder = ((SignMgrSignatoryEntity)((Object)signMgrSignatoryEntity.get(0))).getSealSignOrder();
        this.nextSignatory(Long.valueOf(map.get("contractId")), maxSignOrder, maxSealSignOrder);
    }

    public void findSignatory(SignMgrEntity signMgrEntity) {
        ArrayList results = new ArrayList();
        List<SignMgrSignatoryEntity> sms = signMgrEntity.getSignMgrSignatoryEntities();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (SignMgrSignatoryEntity sm : sms) {
            if (!Objects.equals(sm.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())) continue;
            list.add(sm.getJobStatus());
        }
        if (list.size() == sms.size()) {
            sms.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = sms.get(0);
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();
            List ss = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            results.addAll(ss);
            for (SignMgrSignatoryEntity s : ss) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)s.getId());
                updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, (Object)s.getJobStatus());
                this.signMgrSignatoryService.update((Wrapper)updateWrapper);
            }
        } else {
            List s = sms.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (!s.isEmpty()) {
                s.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)s.get(0));
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();
                List f = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                results.addAll(f);
            }
        }
    }

    @Override
    public List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder) {
        ArrayList<SignMgrSignatoryEntity> operators = new ArrayList<SignMgrSignatoryEntity>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.getOne((Wrapper)queryWrapper));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
        List sms = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
        if (sms.size() == 0) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7b7e\u7f72\u52a8\u4f5c\u4efb\u52a1\u6570\u636e\uff01");
        }
        if (maxSignOrder <= 0 && maxSealSignOrder <= 0) {
            sms.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)sms.get(0));
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();
            List opts = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            operators.addAll(opts);
            for (SignMgrSignatoryEntity s : opts) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                this.signMgrSignatoryService.updateById((Object)s);
            }
        } else {
            List s = sms.stream().filter(e -> e.getSignOrder() > maxSignOrder && e.getSealSignOrder() > maxSealSignOrder).collect(Collectors.toList());
            if (!s.isEmpty()) {
                s.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)s.get(0));
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();
                List f = s.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                operators.addAll(f);
            }
        }
        return operators;
    }

    @Override
    public CommonResponse<String> sendMessage(List<SignMgrSignatoryEntity> operators) {
        String content;
        String[] receivers;
        String[] channel;
        ArrayList<String> lst;
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList rec = new ArrayList();
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            lst = new ArrayList<String>();
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);
            receivers = (String[])operators.stream().map(SignMgrSignatoryEntity::getSignatureId).toArray();
            content = "\u60a8\u6709\u4e00\u4e2a\u5f85\u7b7e\u7f72\u5408\u540c:";
        } else {
            lst = new ArrayList();
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);
            receivers = (String[])operators.stream().map(SignMgrSignatoryEntity::getSignatureId).toArray();
            content = "\u60a8\u6709\u4e00\u4e2a\u5f85\u7b7e\u7f72\u5408\u540c\uff1a<a href=\"http://www.w3school.com.cn?contractId=xx?contact=xxx\">\u70b9\u6211\u7b7e\u7f72</a>";
        }
        String msgType = "notice";
        String subject = "\u7b7e\u7ae0\u63d0\u9192";
        CommonResponse user = this.userApi.queryListByIds(new String[]{receivers[0]});
        String tenantId = String.valueOf(((UserVO)((List)user.getData()).get(0)).getTenantId());
        parameter.setChannel(channel);
        parameter.setReceivers(receivers);
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        return this.pushMessageApi.pushMessage(parameter);
    }

    @Override
    public void AllReceiverComplate(Map<String, String> map) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_bill_id", (Object)Long.valueOf(map.get("contractId")));
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.getOne((Wrapper)queryWrapper));
        List<SignMgrSignatoryEntity> sig = signMgrEntity.getSignMgrSignatoryEntities();
        String action = map.get("action");
        JSONObject jsonObject = JSONObject.parseObject((String)action);
        String actionNo = jsonObject.getString("actionNO");
        List signMgrSignatoryEntity = sig.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());
    }

    @Override
    public Long createDocument(InitSignatureVO initSignatureVO) {
        Long documentId;
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateDocumentRequest request = new CreateDocumentRequest();
        CommonResponse attachmentResp = this.attachmentApi.queryDetail(initSignatureVO.getBillDocId().toString());
        try {
            documentId = contractService.createDocumentByUrl(new DocumentCreateByUrl(((AttachmentVO)attachmentResp.getData()).getTruePath(), initSignatureVO.getBillDocumentName(), initSignatureVO.getBillDocumentType(), null));
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u521b\u5efa\u5408\u540c\u6587\u6863\u5f02\u5e38\uff01");
        }
        this.logger.info("\u521b\u5efa\u5408\u540c\u6587\u4ef6\u6210\u529f,documentId:{}", (Object)documentId);
        return documentId;
    }

    @Override
    public Long createContract(Long documentId, InitSignatureVO initSignatureVO) {
        Long contractId;
        SignMgrVO signMgrVO = new SignMgrVO();
        List signMgrSignatoryEntities = signMgrVO.getSignMgrSignatoryEntities();
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setCategoryId(this.categoryId);
        createContractRequest.setSubject(initSignatureVO.getBillDocumentName());
        createContractRequest.setSend(Boolean.valueOf(true));
        ArrayList<Long> documents = new ArrayList<Long>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        createContractRequest.setDescription(initSignatureVO.getSignRequirements());
        createContractRequest.setCreatorName(initSignatureVO.getCreatorName());
        createContractRequest.setCreatorContact(initSignatureVO.getCreatorContact());
        createContractRequest.setTenantName(initSignatureVO.getTenantName());
        signMgrVO.setBillId(initSignatureVO.getBillId());
        signMgrVO.setBillType(initSignatureVO.getBillType());
        signMgrVO.setSourceDocId(documentId);
        signMgrVO.setBillDocId(initSignatureVO.getBillDocId());
        signMgrVO.setBillDocumentName(initSignatureVO.getBillDocumentName());
        signMgrVO.setBillDocumentType(initSignatureVO.getBillDocumentType());
        signMgrVO.setSignRequirements(initSignatureVO.getSignRequirements());
        signMgrVO.setCreatorName(initSignatureVO.getCreatorName());
        signMgrVO.setCreatorContact(initSignatureVO.getCreatorContact());
        signMgrVO.setTenantName(initSignatureVO.getTenantName());
        List initSignatoryVOList = initSignatureVO.getSignMgrSignatoryEntities();
        initSignatoryVOList.sort(Comparator.comparing(InitSignatoryVO::getSignOrder));
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        for (InitSignatoryVO initSignatoryVO : initSignatoryVOList) {
            SignMgrSignatoryVO signMgrSignatoryVO = new SignMgrSignatoryVO();
            Signatory signatory = new Signatory();
            signatory.setTenantType(TenantType.valueOf((String)initSignatoryVO.getTenantType()));
            signatory.setTenantName(initSignatoryVO.getTenantName());
            if (!Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                signatory.setReceiverName(initSignatoryVO.getReceiverName());
                signatory.setContact(initSignatoryVO.getContact());
            }
            signatory.setSerialNo(initSignatoryVO.getSignOrder());
            ArrayList<Action> actions = new ArrayList<Action>();
            List signatureList = initSignatoryVO.getSignatureList();
            for (SealInfoVO sealInfoVO : signatureList) {
                Action action = new Action();
                action.setType(ActionType.valueOf((String)sealInfoVO.getSignActionType()));
                action.setActionNo(sealInfoVO.getActionNo());
                action.setName(sealInfoVO.getName());
                action.setSerialNo(sealInfoVO.getSealSignOrder());
                ArrayList<Operator> operators = new ArrayList<Operator>();
                List signatoryVOList = sealInfoVO.getSignatoryVOList();
                for (SignatoryVO signatoryVO : signatoryVOList) {
                    Operator operator = new Operator();
                    operator.setOperatorName(signatoryVO.getSignatureName());
                    operator.setOperatorContact(signatoryVO.getSignatureContact());
                    operators.add(operator);
                    signMgrSignatoryVO.setSignatureId(signatoryVO.getSignatureId());
                    signMgrSignatoryVO.setSignatureName(signatoryVO.getSignatureName());
                    signMgrSignatoryVO.setSignatureContact(signatoryVO.getSignatureContact());
                }
                action.setActionOperators(operators);
                if (sealInfoVO.getSourceSealId() != null && sealInfoVO.getSourceSealName() != null && Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    Set ids = Arrays.stream(sealInfoVO.getSourceSealId().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                    Set names = Arrays.stream(sealInfoVO.getSourceSealName().split(",")).collect(Collectors.toSet());
                    action.setSealIds(ids);
                    action.setSealNames(names);
                }
                actions.add(action);
                signMgrSignatoryVO.setSignActionType(sealInfoVO.getSignActionType());
                signMgrSignatoryVO.setName(sealInfoVO.getName());
                signMgrSignatoryVO.setSealSignOrder(sealInfoVO.getSealSignOrder());
                signMgrSignatoryVO.setSourceSealId(sealInfoVO.getSourceSealId());
                signMgrSignatoryVO.setSourceSealName(sealInfoVO.getSourceSealName());
                signMgrSignatoryVO.setSealId(sealInfoVO.getSealId());
                signMgrSignatoryVO.setSealName(sealInfoVO.getSealName());
                signMgrSignatoryVO.setSignatureUserIds(sealInfoVO.getSignatureUserIds());
                signMgrSignatoryVO.setActionNo(sealInfoVO.getActionNo());
            }
            signatory.setActions(actions);
            signatories.add(signatory);
            signMgrSignatoryVO.setTenantName(initSignatoryVO.getTenantName());
            signMgrSignatoryVO.setTenantType(initSignatoryVO.getTenantType());
            signMgrSignatoryVO.setReceiverName(initSignatoryVO.getReceiverName());
            signMgrSignatoryVO.setContact(initSignatoryVO.getContact());
            signMgrSignatoryVO.setSignOrder(initSignatoryVO.getSignOrder());
            signMgrSignatoryVO.setSignatureType(initSignatoryVO.getSignatureType());
            signMgrSignatoryVO.setSignatoryNo(initSignatoryVO.getSignatoryNo());
            signMgrSignatoryVO.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
            signMgrSignatoryEntities.add(signMgrSignatoryVO);
        }
        createContractRequest.setSignatories(signatories);
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e2) {
            e2.printStackTrace();
            throw new BusinessException("\u521b\u5efa\u5408\u540c\u5931\u8d25!");
        }
        signMgrVO.setSourceBillId(contractId);
        signMgrVO.setSignMgrSignatoryEntities(signMgrSignatoryEntities);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)BeanMapper.map((Object)signMgrVO, SignMgrEntity.class));
        this.saveOrUpdate((Object)signMgrEntity, false);
        return contractId;
    }

    @Override
    public String createCloudSignUrl(Long contractId, String contact) {
        String cloudSignUrl;
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        try {
            cloudSignUrl = contractService.cloudSignUrl(contractId, contact);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u516c\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u5931\u8d25\uff01");
        }
        this.logger.info("\u6587\u4ef6\u7b7e\u7f72\u94fe\u63a5:{}", (Object)cloudSignUrl);
        return cloudSignUrl;
    }
}

