package com.ejianc.business.signaturemanage.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 签章管理日志记录表
 *
 * @author generator
 */
@TableName("ejc_signmgr_log")
public class SignMgrLogEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_id")
    private java.lang.Long billId; // 业务id
    @TableField(value = "bill_type")
    private java.lang.String billType; // 来源业务单据类型
    @TableField(value = "bill_doc_id")
    private java.lang.Long billDocId; // 业务文件id
    @TableField(value = "bill_document_name")
    private java.lang.String billDocumentName; // 业务文件名称
    @TableField(value = "bill_document_type")
    private java.lang.String billDocumentType; // 业务文件类型
    @TableField(value = "sign_requirements")
    private java.lang.String signRequirements; // 签署要求
    @TableField(value = "signature_type")
    private java.lang.Integer signatureType; // 签署方类型：0-内部单位，1-外部单位
    @TableField(value = "tenant_name")
    private java.lang.String tenantName; // 签约主体名称
    @TableField(value = "tenant_type")
    private java.lang.String tenantType; // 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
    @TableField(value = "signature_id")
    private java.lang.Long signatureId; // 签署方Id
    @TableField(value = "signature_name")
    private java.lang.String signatureName; // 签署方名称
    @TableField(value = "sign_order")
    private java.lang.Integer signOrder; // 签署顺序,前置设置1，后置逐渐增大，无序设置相同
    @TableField(value = "sign_action_type")
    private java.lang.String signActionType; // 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
    @TableField(value = "name")
    private java.lang.String name; // 签署动作名称,根据签署动作类型填写
    @TableField(value = "source_seal_id")
    private java.lang.String sourceSealId; // 印章id第三方系统返回的）
    @TableField(value = "source_seal_name")
    private java.lang.String sourceSealName; // 印章name（第三方系统返回的）
    @TableField(value = "seal_id")
    private java.lang.String sealId; // 平台印章id
    @TableField(value = "seal_name")
    private java.lang.String sealName; // 平台印章name
    @TableField(value = "signature_user_ids")
    private java.lang.String signatureUserIds; // 印章使用平台用户id范围（静态）多个逗号分隔
    @TableField(value = "actual_signatory_name")
    private java.lang.String actualSignatoryName; // 实际签署人
    @TableField(value = "actual_signatory_contact")
    private java.lang.String actualSignatoryContact; // 实际签署人联系方式
    @TableField(value = "seal_sign_order")
    private java.lang.Integer sealSignOrder; // 签章顺序,前置设置1，后置逐渐增大，无序设置相同
    @TableField(value = "job_status")
    private java.lang.Integer jobStatus; // 0-待激活，1-待签章，2-已完成
    @TableField(value = "sign_result")
    private java.lang.Integer signResult; // 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
    @TableField(value = "mark")
    private java.lang.String mark; // 备注，描述签署状态
    @TableField(value = "start_time")
    private java.util.Date startTime; // 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
    @TableField(value = "end_time")
    private java.util.Date endTime; // 结束时间：状态为完成签署动作的时间
    @TableField(value = "pid")
    private java.lang.Long pid; // 签章管理表id
    @TableField(value = "third_sys_callback_contract_id")
    private java.lang.Long thirdSysCallbackContractId; // 文件编号
    @TableField(value = "third_sys_callback_tenant_id")
    private java.lang.String thirdSysCallbackTenantId; // 签署方编号
    @TableField(value = "third_sys_callback_tenant_name")
    private java.lang.String thirdSysCallbackTenantName; // 签署方名称
    @TableField(value = "third_sys_callback_sn")
    private java.lang.String thirdSysCallbackSn; // 文件自定义编号
    @TableField(value = "third_sys_callback_status")
    private java.lang.String thirdSysCallbackStatus; // 文件状态
    @TableField(value = "third_sys_callback_type")
    private java.lang.String thirdSysCallbackType; // 回调事件
    @TableField(value = "third_sys_callback_contact")
    private java.lang.String thirdSysCallbackContact; // 联系方式
    @TableField(value = "third_sys_callback_operator_name")
    private java.lang.String thirdSysCallbackOperatorName; // 操作人姓名
    @TableField(value = "third_sys_callback_operator_mobile")
    private java.lang.String thirdSysCallbackOperatorMobile; // 操作人手机号
    @TableField(value = "send_bill_sys_bill_id")
    private java.lang.Long sendBillSysBillId; // 业务id
    @TableField(value = "send_bill_sys_bill_type")
    private java.lang.String sendBillSysBillType; // 来源业务单据类型
    @TableField(value = "send_bill_sys_signature_id")
    private java.lang.Long sendBillSysSignatureId; // 签署方Id
    @TableField(value = "send_bill_sys_signature_name")
    private java.lang.String sendBillSysSignatureName; // 签署方名称
    @TableField(value = "send_bill_sys_actual_signatory_name")
    private java.lang.String sendBillSysActualSignatoryName; // 实际签署人
    @TableField(value = "send_bill_sys_actual_signatory_contact")
    private java.lang.String sendBillSysActualSignatoryContact; // 实际签署人联系方式
    @TableField(value = "send_bill_sys_job_status")
    private java.lang.Integer sendBillSysJobStatus; // 0-待激活，1-待签章，2-已完成
    @TableField(value = "send_bill_sys_sign_result")
    private java.lang.Integer sendBillSysSignResult; // 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
    @TableField(value = "send_bill_sys_start_time")
    private java.lang.String sendBillSysStartTime; // 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
    @TableField(value = "send_bill_sys_end_time")
    private java.lang.String sendBillSysEndTime; // 结束时间：状态为完成签署动作的时间
    @TableField(value = "bill_sys_resp")
    private java.lang.String billSysResp; // 调用业务系统结果
    @TableField(value = "remark")
    private java.lang.String remark; // 异常情况描述：例如未匹配到签署方信息


    /**
     * 业务id
     */
    public java.lang.Long getBillId() {
        return billId;
    }

    /**
     * 业务id
     */
    public void setBillId(java.lang.Long billId) {
        this.billId = billId;
    }

    /**
     * 来源业务单据类型
     */
    public java.lang.String getBillType() {
        return billType;
    }

    /**
     * 来源业务单据类型
     */
    public void setBillType(java.lang.String billType) {
        this.billType = billType;
    }

    /**
     * 业务文件id
     */
    public java.lang.Long getBillDocId() {
        return billDocId;
    }

    /**
     * 业务文件id
     */
    public void setBillDocId(java.lang.Long billDocId) {
        this.billDocId = billDocId;
    }

    /**
     * 业务文件名称
     */
    public java.lang.String getBillDocumentName() {
        return billDocumentName;
    }

    /**
     * 业务文件名称
     */
    public void setBillDocumentName(java.lang.String billDocumentName) {
        this.billDocumentName = billDocumentName;
    }

    /**
     * 业务文件类型
     */
    public java.lang.String getBillDocumentType() {
        return billDocumentType;
    }

    /**
     * 业务文件类型
     */
    public void setBillDocumentType(java.lang.String billDocumentType) {
        this.billDocumentType = billDocumentType;
    }

    /**
     * 签署要求
     */
    public java.lang.String getSignRequirements() {
        return signRequirements;
    }

    /**
     * 签署要求
     */
    public void setSignRequirements(java.lang.String signRequirements) {
        this.signRequirements = signRequirements;
    }

    /**
     * 签署方类型：0-内部单位，1-外部单位
     */
    public java.lang.Integer getSignatureType() {
        return signatureType;
    }

    /**
     * 签署方类型：0-内部单位，1-外部单位
     */
    public void setSignatureType(java.lang.Integer signatureType) {
        this.signatureType = signatureType;
    }

    /**
     * 签约主体名称
     */
    public java.lang.String getTenantName() {
        return tenantName;
    }

    /**
     * 签约主体名称
     */
    public void setTenantName(java.lang.String tenantName) {
        this.tenantName = tenantName;
    }

    /**
     * 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
     */
    public java.lang.String getTenantType() {
        return tenantType;
    }

    /**
     * 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
     */
    public void setTenantType(java.lang.String tenantType) {
        this.tenantType = tenantType;
    }

    /**
     * 签署方Id
     */
    public java.lang.Long getSignatureId() {
        return signatureId;
    }

    /**
     * 签署方Id
     */
    public void setSignatureId(java.lang.Long signatureId) {
        this.signatureId = signatureId;
    }

    /**
     * 签署方名称
     */
    public java.lang.String getSignatureName() {
        return signatureName;
    }

    /**
     * 签署方名称
     */
    public void setSignatureName(java.lang.String signatureName) {
        this.signatureName = signatureName;
    }

    /**
     * 签署顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public java.lang.Integer getSignOrder() {
        return signOrder;
    }

    /**
     * 签署顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public void setSignOrder(java.lang.Integer signOrder) {
        this.signOrder = signOrder;
    }

    /**
     * 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
     */
    public java.lang.String getSignActionType() {
        return signActionType;
    }

    /**
     * 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
     */
    public void setSignActionType(java.lang.String signActionType) {
        this.signActionType = signActionType;
    }

    /**
     * 签署动作名称,根据签署动作类型填写
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 签署动作名称,根据签署动作类型填写
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 印章id第三方系统返回的）
     */
    public java.lang.String getSourceSealId() {
        return sourceSealId;
    }

    /**
     * 印章id第三方系统返回的）
     */
    public void setSourceSealId(java.lang.String sourceSealId) {
        this.sourceSealId = sourceSealId;
    }

    /**
     * 印章name（第三方系统返回的）
     */
    public java.lang.String getSourceSealName() {
        return sourceSealName;
    }

    /**
     * 印章name（第三方系统返回的）
     */
    public void setSourceSealName(java.lang.String sourceSealName) {
        this.sourceSealName = sourceSealName;
    }

    /**
     * 平台印章id
     */
    public java.lang.String getSealId() {
        return sealId;
    }

    /**
     * 平台印章id
     */
    public void setSealId(java.lang.String sealId) {
        this.sealId = sealId;
    }

    /**
     * 平台印章name
     */
    public java.lang.String getSealName() {
        return sealName;
    }

    /**
     * 平台印章name
     */
    public void setSealName(java.lang.String sealName) {
        this.sealName = sealName;
    }

    /**
     * 印章使用平台用户id范围（静态）多个逗号分隔
     */
    public java.lang.String getSignatureUserIds() {
        return signatureUserIds;
    }

    /**
     * 印章使用平台用户id范围（静态）多个逗号分隔
     */
    public void setSignatureUserIds(java.lang.String signatureUserIds) {
        this.signatureUserIds = signatureUserIds;
    }

    /**
     * 实际签署人
     */
    public java.lang.String getActualSignatoryName() {
        return actualSignatoryName;
    }

    /**
     * 实际签署人
     */
    public void setActualSignatoryName(java.lang.String actualSignatoryName) {
        this.actualSignatoryName = actualSignatoryName;
    }

    /**
     * 实际签署人联系方式
     */
    public java.lang.String getActualSignatoryContact() {
        return actualSignatoryContact;
    }

    /**
     * 实际签署人联系方式
     */
    public void setActualSignatoryContact(java.lang.String actualSignatoryContact) {
        this.actualSignatoryContact = actualSignatoryContact;
    }

    /**
     * 签章顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public java.lang.Integer getSealSignOrder() {
        return sealSignOrder;
    }

    /**
     * 签章顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public void setSealSignOrder(java.lang.Integer sealSignOrder) {
        this.sealSignOrder = sealSignOrder;
    }

    /**
     * 0-待激活，1-待签章，2-已完成
     */
    public java.lang.Integer getJobStatus() {
        return jobStatus;
    }

    /**
     * 0-待激活，1-待签章，2-已完成
     */
    public void setJobStatus(java.lang.Integer jobStatus) {
        this.jobStatus = jobStatus;
    }

    /**
     * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
     */
    public java.lang.Integer getSignResult() {
        return signResult;
    }

    /**
     * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
     */
    public void setSignResult(java.lang.Integer signResult) {
        this.signResult = signResult;
    }

    /**
     * 备注，描述签署状态
     */
    public java.lang.String getMark() {
        return mark;
    }

    /**
     * 备注，描述签署状态
     */
    public void setMark(java.lang.String mark) {
        this.mark = mark;
    }

    /**
     * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 结束时间：状态为完成签署动作的时间
     */
    public java.util.Date getEndTime() {
        return endTime;
    }

    /**
     * 结束时间：状态为完成签署动作的时间
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 签章管理表id
     */
    public java.lang.Long getPid() {
        return pid;
    }

    /**
     * 签章管理表id
     */
    public void setPid(java.lang.Long pid) {
        this.pid = pid;
    }

    /**
     * 文件编号
     */
    public java.lang.Long getThirdSysCallbackContractId() {
        return thirdSysCallbackContractId;
    }

    /**
     * 文件编号
     */
    public void setThirdSysCallbackContractId(java.lang.Long thirdSysCallbackContractId) {
        this.thirdSysCallbackContractId = thirdSysCallbackContractId;
    }

    /**
     * 签署方编号
     */
    public java.lang.String getThirdSysCallbackTenantId() {
        return thirdSysCallbackTenantId;
    }

    /**
     * 签署方编号
     */
    public void setThirdSysCallbackTenantId(java.lang.String thirdSysCallbackTenantId) {
        this.thirdSysCallbackTenantId = thirdSysCallbackTenantId;
    }

    /**
     * 签署方名称
     */
    public java.lang.String getThirdSysCallbackTenantName() {
        return thirdSysCallbackTenantName;
    }

    /**
     * 签署方名称
     */
    public void setThirdSysCallbackTenantName(java.lang.String thirdSysCallbackTenantName) {
        this.thirdSysCallbackTenantName = thirdSysCallbackTenantName;
    }

    /**
     * 文件自定义编号
     */
    public java.lang.String getThirdSysCallbackSn() {
        return thirdSysCallbackSn;
    }

    /**
     * 文件自定义编号
     */
    public void setThirdSysCallbackSn(java.lang.String thirdSysCallbackSn) {
        this.thirdSysCallbackSn = thirdSysCallbackSn;
    }

    /**
     * 文件状态
     */
    public java.lang.String getThirdSysCallbackStatus() {
        return thirdSysCallbackStatus;
    }

    /**
     * 文件状态
     */
    public void setThirdSysCallbackStatus(java.lang.String thirdSysCallbackStatus) {
        this.thirdSysCallbackStatus = thirdSysCallbackStatus;
    }

    /**
     * 回调事件
     */
    public java.lang.String getThirdSysCallbackType() {
        return thirdSysCallbackType;
    }

    /**
     * 回调事件
     */
    public void setThirdSysCallbackType(java.lang.String thirdSysCallbackType) {
        this.thirdSysCallbackType = thirdSysCallbackType;
    }

    /**
     * 联系方式
     */
    public java.lang.String getThirdSysCallbackContact() {
        return thirdSysCallbackContact;
    }

    /**
     * 联系方式
     */
    public void setThirdSysCallbackContact(java.lang.String thirdSysCallbackContact) {
        this.thirdSysCallbackContact = thirdSysCallbackContact;
    }

    /**
     * 操作人姓名
     */
    public java.lang.String getThirdSysCallbackOperatorName() {
        return thirdSysCallbackOperatorName;
    }

    /**
     * 操作人姓名
     */
    public void setThirdSysCallbackOperatorName(java.lang.String thirdSysCallbackOperatorName) {
        this.thirdSysCallbackOperatorName = thirdSysCallbackOperatorName;
    }

    /**
     * 操作人手机号
     */
    public java.lang.String getThirdSysCallbackOperatorMobile() {
        return thirdSysCallbackOperatorMobile;
    }

    /**
     * 操作人手机号
     */
    public void setThirdSysCallbackOperatorMobile(java.lang.String thirdSysCallbackOperatorMobile) {
        this.thirdSysCallbackOperatorMobile = thirdSysCallbackOperatorMobile;
    }

    /**
     * 业务id
     */
    public java.lang.Long getSendBillSysBillId() {
        return sendBillSysBillId;
    }

    /**
     * 业务id
     */
    public void setSendBillSysBillId(java.lang.Long sendBillSysBillId) {
        this.sendBillSysBillId = sendBillSysBillId;
    }

    /**
     * 来源业务单据类型
     */
    public java.lang.String getSendBillSysBillType() {
        return sendBillSysBillType;
    }

    /**
     * 来源业务单据类型
     */
    public void setSendBillSysBillType(java.lang.String sendBillSysBillType) {
        this.sendBillSysBillType = sendBillSysBillType;
    }

    /**
     * 签署方Id
     */
    public java.lang.Long getSendBillSysSignatureId() {
        return sendBillSysSignatureId;
    }

    /**
     * 签署方Id
     */
    public void setSendBillSysSignatureId(java.lang.Long sendBillSysSignatureId) {
        this.sendBillSysSignatureId = sendBillSysSignatureId;
    }

    /**
     * 签署方名称
     */
    public java.lang.String getSendBillSysSignatureName() {
        return sendBillSysSignatureName;
    }

    /**
     * 签署方名称
     */
    public void setSendBillSysSignatureName(java.lang.String sendBillSysSignatureName) {
        this.sendBillSysSignatureName = sendBillSysSignatureName;
    }

    /**
     * 实际签署人
     */
    public java.lang.String getSendBillSysActualSignatoryName() {
        return sendBillSysActualSignatoryName;
    }

    /**
     * 实际签署人
     */
    public void setSendBillSysActualSignatoryName(java.lang.String sendBillSysActualSignatoryName) {
        this.sendBillSysActualSignatoryName = sendBillSysActualSignatoryName;
    }

    /**
     * 实际签署人联系方式
     */
    public java.lang.String getSendBillSysActualSignatoryContact() {
        return sendBillSysActualSignatoryContact;
    }

    /**
     * 实际签署人联系方式
     */
    public void setSendBillSysActualSignatoryContact(java.lang.String sendBillSysActualSignatoryContact) {
        this.sendBillSysActualSignatoryContact = sendBillSysActualSignatoryContact;
    }

    /**
     * 0-待激活，1-待签章，2-已完成
     */
    public java.lang.Integer getSendBillSysJobStatus() {
        return sendBillSysJobStatus;
    }

    /**
     * 0-待激活，1-待签章，2-已完成
     */
    public void setSendBillSysJobStatus(java.lang.Integer sendBillSysJobStatus) {
        this.sendBillSysJobStatus = sendBillSysJobStatus;
    }

    /**
     * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
     */
    public java.lang.Integer getSendBillSysSignResult() {
        return sendBillSysSignResult;
    }

    /**
     * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4
     */
    public void setSendBillSysSignResult(java.lang.Integer sendBillSysSignResult) {
        this.sendBillSysSignResult = sendBillSysSignResult;
    }

    /**
     * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
     */
    public java.lang.String getSendBillSysStartTime() {
        return sendBillSysStartTime;
    }

    /**
     * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
     */
    public void setSendBillSysStartTime(java.lang.String sendBillSysStartTime) {
        this.sendBillSysStartTime = sendBillSysStartTime;
    }

    /**
     * 结束时间：状态为完成签署动作的时间
     */
    public java.lang.String getSendBillSysEndTime() {
        return sendBillSysEndTime;
    }

    /**
     * 结束时间：状态为完成签署动作的时间
     */
    public void setSendBillSysEndTime(java.lang.String sendBillSysEndTime) {
        this.sendBillSysEndTime = sendBillSysEndTime;
    }

    /**
     * 调用业务系统结果
     */
    public java.lang.String getBillSysResp() {
        return billSysResp;
    }

    /**
     * 调用业务系统结果
     */
    public void setBillSysResp(java.lang.String billSysResp) {
        this.billSysResp = billSysResp;
    }

    /**
     * 异常情况描述：例如未匹配到签署方信息
     */
    public java.lang.String getRemark() {
        return remark;
    }

    /**
     * 异常情况描述：例如未匹配到签署方信息
     */
    public void setRemark(java.lang.String remark) {
        this.remark = remark;
    }

}
