package com.ejianc.business.signaturemanage.controller.api;


import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * 签章管理API控制器
 *
 * @author baipengyan
 * @Description: 签章管理API控制器
 */
@RestController
@RequestMapping(value = "/api/signaturemanage")
public class SignatureManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISignMgrService signMgrService;

    @Autowired
    private IEmployeeApi employeeApi;// 获取用户信息


    /**
     * 发起签章
     *
     * @param signMgrVO
     * @return
     */
    @PostMapping(value = "/initiateSignature")
    public CommonResponse<Long> initiateSignature(@RequestBody SignMgrVO signMgrVO) {
        Long documentId = signMgrService.createByFile(signMgrVO);
        Long contractId = signMgrService.createContractByCategory(documentId, signMgrVO);

        // Long contractId = 2903200045497917462L;
        if (contractId == null) {
            return CommonResponse.success("发起签章，操作失败！");
        }
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;

        List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        // CommonResponse<String> result = signMgrService.sendMessage(operators);
        return CommonResponse.success("发起签章，操作成功！", contractId);
    }


    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @PostMapping(value = "/sendSignature")
    public CommonResponse<Long> initiateSignature(@RequestBody @Valid InitSignatureVO initSignatureVO) {
        // 先获取发起人名称和手机号
        Long userId = InvocationInfoProxy.getUserid();
        CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
        if (employeeResponse.isSuccess()) {
            initSignatureVO.setCreatorName(employeeResponse.getData().getUserName());
            initSignatureVO.setCreatorContact(employeeResponse.getData().getMobilePhone());
        }


        Long documentId = signMgrService.createDocument(initSignatureVO);
        Long contractId = signMgrService.createContract(documentId, initSignatureVO);

        // Long contractId = 2903200045497917462L;
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;

        // 找到下一个签章人
        List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        if (operators != null) {
            // 通知业务系统：
            // signMgrService.sendStatus(, );
            // 发送消息通知
            CommonResponse<String> result = signMgrService.sendMessage(operators);
        } else {
            // 通知业务系统:全部签章完成
        }

        return CommonResponse.success("发起签章，操作成功！", contractId);
    }


    /**
     * 契约锁，全局状态回调
     *
     * @param map
     * @return
     */
    @PostMapping(value = "/qysCallBack/global")
    public CommonResponse<Long> global(@RequestParam Map<String, String> map/*, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse*/) {

        logger.info("回调入参map为：{}", map);

        switch (map.get("type")) {
            case "CONTRACT_COMPLETE":
                // 文件全部签署完成

                break;
            case "CONTRACT_TERMINATE":
                // 文件作废

                break;
            case "CONTRACT_EXPIRED":
                // 文件过期

                break;
            default:
                break;
        }

        return CommonResponse.success("全局，回调成功！");
    }


    /**
     * 契约锁，发起方状态回调
     *
     * @param map
     * @param httpServletRequest
     * @param httpServletResponse
     * @return
     */
    @PostMapping(value = "/qysCallBack/organizer")
    public CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {

        logger.info("回调入参map为：{}", map);
        /*
        {callbackEventType=ELECTRONIC, type=INTERNAL_FLOW, operatorName=白朋言, serialNo=3, callbackBusinessType=CONTRACT, receiverNumber=NO000001, tenantName=云南省建设投资控股集团有限公司, contact=18608891810, contractId=2901686921971589287, tenantId=2901664964343702184, action={"id":"2901686922999193792","contractId":"2901686921971589287","signatoryId":"2901686922361659567","type":"CORPORATE","name":"\u4F01\u4E1A\u7B7E\u7AE0","status":"SIGNED","serialNo":3,"createTime":"2021-11-26 11:07:53","completeTime":"2021-11-26 15:12:51","tenantType":"PERSONAL","tenantId":"2901686922571374773","tenantName":"\u767D\u670B\u8A00","forward":false,"autoSign":false,"required":true,"autoSigned":false,"noAppearance":false,"isCloudSign":false,"addOperator":false,"isSuperior":false,"modifyDocument":false,"child":false,"canNotify":false,"complete":true,"terminate":false,"appoint":false,"executing":false,"statusDesc":"\u5DF2\u5B8C\u6210"}, callbackHeader={"authority":"userType=1;userCode=guoming;userName=%E7%B3%BB%E7%BB%9F%E7%AE%A1%E7%90%86%E5%91%98;orgId=1247777316689256450;orgName=%E5%8C%97%E4%BA%AC%E7%9B%8A%E4%BC%81%E8%81%94%E7%A7%91%E6%8A%80%E6%9C%89%E9%99%90%E5%85%AC%E5%8F%B8;tenantid=999999;token=d2ViLDM2MDAsR0s4aXZkb0FoRVlzSHkxZytoL0FCd1RZY1ptU3p2S1RsN0N3SlpkK3kvRUdhSUJvVU8wVkVDNE1mVXhxMHVNRmEvY1JMN1FUVWJ1T1FCSzBHa0VMTUE9PQ;u_logints=1637910667256;u_usercode=303581417601122400;userId=303581417601122400"}, sn=null, operatorMobile=13323068749, actionName=企业签章, status=SIGNING}
        */

        switch (map.get("type")) {
            case "CONTRACT_SIGN":
                // 文件签署-签署方签署

                break;
            case "INTERNAL_FLOW":
                // 每个节点签署完成
                signMgrService.internalFlow(map);
                break;
            case "CONTRACT_RECALL":
                // 文件撤回-发起方撤回

                break;
            default:
                break;
        }

        return CommonResponse.success("发起方状态，回调成功！");
    }


    /**
     * 契约锁，接收方状态回调
     *
     * @param map
     * @param httpServletRequest
     * @param httpServletResponse
     * @return
     */
    @PostMapping(value = "/qysCallBack/receiver")
    public CommonResponse<String> receiver(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {

        logger.info("回调入参map为：{}", map);

        switch (map.get("type")) {
            case "ALLRECEIVER_SIGNATORY_COMPLATE":
                // 所有接收方签署完成
                signMgrService.AllReceiverComplate(map);
                break;
            case "CONTRACT_SIGN":
                // 文件签署-签署方签署

                break;
            case "INTERNAL_FLOW":
                // 每个节点签署完成
                signMgrService.internalFlow(map);
                break;
            case "CONTRACT_REJECTED":
                // 文件退回-签署方拒绝

                break;
            case "CONTRACT_TERMINATE_REJECTED":
                // 文件作废拒绝

                break;
            default:
                break;
        }

        return CommonResponse.success("接收方状态，回调成功！");
    }

}
