package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 签章管理
 *
 * @author generator
 */
public interface ISignMgrService extends IBaseService<SignMgrEntity> {

    SignMgrEntity selectBycontractId(Long contractId);

    /**
     * 用文件创建合同文档
     *
     * @param signMgrVO
     * @return
     */
    Long createByFile(SignMgrVO signMgrVO);


    /**
     * 创建合同
     *
     * @param documentId
     * @param signMgrVO
     * @return
     */
    Long createContractByCategory(Long documentId, SignMgrVO signMgrVO);


    /**
     * 每个节点签署完成
     *
     * @param map
     */
    void internalFlow(Map<String, String> map);


    /**
     * 所有接收方签署完成
     *
     * @param map
     */
    void AllReceiverComplate(Map<String, String> map);

    /**
     * 下一个待签章的人员列表
     *
     * @param contractId
     * @param maxSignOrder
     * @param maxSealSignOrder
     * @return
     */
    List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder);


    /**
     * 同步签章状态
     *
     * @param billType
     * @param billId
     * @param refcode
     * @param status
     */
    void sendStatus(String billType, Long billId, String refcode, int status);

    /**
     * 发送消息
     *
     * @param operators
     * @return
     */
    CommonResponse<String> sendMessage(List<SignMgrSignatoryEntity> operators);


    /**
     * 用文件创建合同文档
     *
     * @param initSignatureVO
     * @return
     */
    Long createDocument(String url, String billDocumentName, String billDocumentType);

    /**
     * 创建合同
     *
     * @param documentId      合同文档id
     * @param initSignatureVO 发起签章VO
     * @return
     */
    Long createContract(Long documentId, InitSignatureVO initSignatureVO);

    /**
     * 获取公有云合同签署短链接
     *
     * @param contractId 合同id
     * @param contact    联系方式
     * @return cloudSignUrl
     */
    String createCloudSignUrl(Long contractId, String contact);
}
