/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/signaturemanage"})
public class SignatureManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignMgrService signMgrService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @PostMapping(value={"/initiateSignature"})
    public CommonResponse<Long> initiateSignature(@RequestBody SignMgrVO signMgrVO) {
        Long documentId = this.signMgrService.createByFile(signMgrVO);
        Long contractId = this.signMgrService.createContractByCategory(documentId, signMgrVO);
        if (contractId == null) {
            return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;
        List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u6210\u529f\uff01", (Object)contractId);
    }

    @PostMapping(value={"/sendSignature"})
    public CommonResponse<Long> initiateSignature(@RequestBody @Valid InitSignatureVO initSignatureVO) {
        Long userId = InvocationInfoProxy.getUserid();
        CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
        if (employeeResponse.isSuccess()) {
            initSignatureVO.setCreatorName(((EmployeeVO)employeeResponse.getData()).getUserName());
            initSignatureVO.setCreatorContact(((EmployeeVO)employeeResponse.getData()).getMobilePhone());
        }
        String billDocumentType = null;
        CommonResponse attachmentResp = this.attachmentApi.queryDetail(String.valueOf(initSignatureVO.getBillDocId()));
        if (!attachmentResp.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        String url = ((AttachmentVO)attachmentResp.getData()).getTruePath();
        String fileName = ((AttachmentVO)attachmentResp.getData()).getFileName();
        billDocumentType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        Long documentId = this.signMgrService.createDocument(url, initSignatureVO.getBillDocumentName(), billDocumentType);
        Long contractId = this.signMgrService.createContract(documentId, initSignatureVO);
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;
        List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        if (operators != null) {
            CommonResponse<String> commonResponse = this.signMgrService.sendMessage(operators);
        }
        return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u6210\u529f\uff01", (Object)contractId);
    }

    @PostMapping(value={"/qysCallBack/global"})
    public CommonResponse<Long> global(@RequestParam Map<String, String> map) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "CONTRACT_COMPLETE": {
                break;
            }
            case "CONTRACT_TERMINATE": {
                break;
            }
            case "CONTRACT_EXPIRED": {
                break;
            }
        }
        return CommonResponse.success((String)"\u5168\u5c40\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/qysCallBack/organizer"})
    public CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "CONTRACT_SIGN": {
                break;
            }
            case "INTERNAL_FLOW": {
                this.signMgrService.internalFlow(map);
                break;
            }
            case "CONTRACT_RECALL": {
                break;
            }
        }
        return CommonResponse.success((String)"\u53d1\u8d77\u65b9\u72b6\u6001\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/qysCallBack/receiver"})
    public CommonResponse<String> receiver(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "ALLRECEIVER_SIGNATORY_COMPLATE": {
                this.signMgrService.AllReceiverComplate(map);
                break;
            }
            case "CONTRACT_SIGN": {
                break;
            }
            case "INTERNAL_FLOW": {
                this.signMgrService.internalFlow(map);
                break;
            }
            case "CONTRACT_REJECTED": {
                break;
            }
            case "CONTRACT_TERMINATE_REJECTED": {
                break;
            }
        }
        return CommonResponse.success((String)"\u63a5\u6536\u65b9\u72b6\u6001\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }
}

