/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.vo.CompanyVO;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sealManager"})
public class SealManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ISealManageService sealManageService;

    @PostMapping(value={"/querySealsByCompanyName"})
    public CommonResponse<List<ManagementVO>> querySealsByCompanyName(@RequestBody CompanyVO companyVO) {
        ArrayList<ManagementVO> list = new ArrayList<ManagementVO>();
        List<Seal> sealList = this.sealManageService.sealList(companyVO.getCompanyId(), companyVO.getCompanyName(), companyVO.getCategory());
        if (sealList != null) {
            for (Seal seal : sealList) {
                List<ManagementUserVO> su;
                Seal s = this.sealManageService.detail(seal.getId());
                ManagementVO managementVO = new ManagementVO();
                managementVO.setSourceSealId(s.getId());
                managementVO.setSourceSealName(s.getName());
                managementVO.setSealCategory(String.valueOf(s.getType()));
                managementVO.setSourceKey(s.getSealKey());
                String imgUrl = this.sealManageService.getImgUrl(s.getId());
                managementVO.setImgUrl(imgUrl);
                JSONObject jsonObject = JSONObject.parseObject((String)s.getStatus());
                switch (jsonObject.getString("key")) {
                    case "NORMAL": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                    case "FREEZE": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                    case "DELETE": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                    case "INVALID": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                }
                managementVO.setSourceStatus(jsonObject.getString("key"));
                managementVO.setSealType(String.valueOf(seal.getCategory()));
                managementVO.setSourceCompanyId(seal.getOwner());
                managementVO.setSourceCompanyName(seal.getOwnerName());
                managementVO.setSealSubTypeName(s.getSealCategoryName());
                List sealAdminGroup = s.getSealAdminGroup();
                List sealUseGroup = s.getSealUseGroup();
                ArrayList<ManagementUserVO> managementUsers = new ArrayList<ManagementUserVO>();
                List<ManagementUserVO> sa = this.sealManageService.getUsers(sealAdminGroup, true);
                if (sa != null) {
                    managementUsers.addAll(sa);
                }
                if ((su = this.sealManageService.getUsers(sealUseGroup, false)) != null) {
                    managementUsers.addAll(su);
                }
                managementVO.setUserEntityList(managementUsers);
                list.add(managementVO);
            }
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5370\u7ae0\u5217\u8868\uff0c\u64cd\u4f5c\u6210\u529f\uff01", list);
    }

    @PostMapping(value={"/queryAllSeal"})
    public CommonResponse<List<ManagementVO>> queryAllSeal() {
        ArrayList<ManagementVO> data = new ArrayList<ManagementVO>();
        List<Company> companyList = this.sealManageService.companySealList();
        if (companyList != null) {
            for (Company company : companyList) {
                for (Seal seal : company.getSeals()) {
                    List<ManagementUserVO> su;
                    Seal s = this.sealManageService.detail(seal.getId());
                    ManagementVO managementVO = new ManagementVO();
                    managementVO.setSourceSealId(s.getId());
                    managementVO.setSourceSealName(s.getName());
                    managementVO.setSealType(String.valueOf(s.getType()));
                    managementVO.setSourceKey(s.getSealKey());
                    String imgUrl = this.sealManageService.getImgUrl(s.getId());
                    managementVO.setImgUrl(imgUrl);
                    JSONObject jsonObject = JSONObject.parseObject((String)s.getStatus());
                    switch (jsonObject.getString("key")) {
                        case "NORMAL": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                        case "FREEZE": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                        case "DELETE": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                        case "INVALID": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                    }
                    managementVO.setSourceStatus(jsonObject.getString("key"));
                    managementVO.setSealCategory(String.valueOf(seal.getCategory()));
                    managementVO.setSourceCompanyId(seal.getOwner());
                    managementVO.setSourceCompanyName(seal.getOwnerName());
                    managementVO.setSealSubTypeName(s.getSealCategoryName());
                    List sealAdminGroup = s.getSealAdminGroup();
                    List sealUseGroup = s.getSealUseGroup();
                    ArrayList<ManagementUserVO> managementUsers = new ArrayList<ManagementUserVO>();
                    List<ManagementUserVO> sa = this.sealManageService.getUsers(sealAdminGroup, true);
                    if (sa != null) {
                        managementUsers.addAll(sa);
                    }
                    if ((su = this.sealManageService.getUsers(sealUseGroup, false)) != null) {
                        managementUsers.addAll(su);
                    }
                    managementVO.setUserEntityList(managementUsers);
                    data.add(managementVO);
                }
            }
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6240\u6709\u5185\u90e8\u4f01\u4e1a\u7684\u5370\u7ae0\u5217\u8868\uff0c\u64cd\u4f5c\u6210\u529f\uff01", data);
    }
}

