package com.ejianc.business.signaturemanage.service.impl;

import com.ejianc.business.signaturemanage.enums.UserTypeEnum;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.framework.core.exception.BusinessException;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.SealService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealCategory;
import net.qiyuesuo.sdk.bean.seal.SealCondition;
import net.qiyuesuo.sdk.bean.seal.SealPermissionGroupBean;
import net.qiyuesuo.sdk.bean.user.User;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.SealServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@Service("sealManageService")
public class SealManageServiceImpl implements ISealManageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${qiyuesuo.client.url}")
    private String url;// 私有化开放平台请求地址
    @Value("${qiyuesuo.client.accessKey}")
    private String accessKey;// 私有化开放平台申请的token
    @Value("${qiyuesuo.client.accessSecret}")
    private String accessSecret;// 私有化开放平台申请的secret
    @Value("${qiyuesuo.contract.categoryId}")
    private Long categoryId;// 用印流程ID

    // @Autowired
    // private IKeyGeneratorApi keyGeneratorApi;


    /**
     * 公司印章列表
     *
     * @param companyId
     * @param companyName
     * @param category
     * @return
     */
    @Override
    public List<Seal> sealList(Long companyId, String companyName, String category) {
        // if (companyId != null){
        //     throw new BusinessException("公司ID不能为空！");
        // }
        if (StringUtils.isBlank(companyName)) {
            throw new BusinessException("公司名称不能为空！");
        }
        // if (StringUtils.isBlank(category)){
        //     throw new BusinessException("印章类型不能为空！");
        // }

        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        SealService sealService = new SealServiceImpl(client);

        List<Seal> list = null;
        try {
            list = sealService.sealList(companyId, companyName, category);
        } catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("请求契约锁异常，请检查请求参数！");
        }

        return list;
    }

    @Override
    public Seal detail(Long sealId) {
        if (sealId == null) {
            throw new BusinessException("印章ID不能为空！");
        }

        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        SealService sealService = new SealServiceImpl(client);

        Seal seal = null;
        try {
            seal = sealService.detail(sealId);
        } catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("请求契约锁异常，请检查请求参数！");
        }

        return seal;
    }

    @Override
    public String getImgUrl(Long sealId) {
        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        SealService sealService = new SealServiceImpl(client);

        OutputStream outputStream;
        try {

            outputStream = new FileOutputStream(new File("E://img.png"));
            Seal request = new Seal();
            request.setId(sealId);
            try {
                sealService.image(request, outputStream);
            } catch (PrivateAppException e) {
                e.printStackTrace();
                throw new BusinessException("请求契约锁异常，请检查请求参数！");
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        // 文件名称
        // Long name = keyGeneratorApi.generateKey();
        // 文件上传地址
        String imgUrl = "";

        // 上传文件中心，获取在线url地址


        return imgUrl;
    }


    /**
     * 解析印章管理员和使用者信息
     *
     * @param sealGroup
     * @return
     */
    public List<ManagementUserVO> getUsers(List<SealPermissionGroupBean> sealGroup, Boolean isAdmin) {
        List<ManagementUserVO> userList = new ArrayList<>();
        if (sealGroup != null) {
            for (SealPermissionGroupBean s : sealGroup) {
                ManagementUserVO m = new ManagementUserVO();
                m.setSourceUserId(s.getId());
                m.setSourceUserName(s.getName());
                List<User> users = s.getUsers();
                // user应该只有一条信息，这里用循环兼容
                for (User user : users) {
                    m.setSourcePhone(user.getMobile());
                    m.setSourceEmail(user.getEmail());
                }
                if (isAdmin) {
                    m.setUserType(UserTypeEnum.MANGER.getTypeName());
                } else {
                    m.setUserType(UserTypeEnum.USER.getTypeName());
                }
                userList.add(m);
            }
        }
        return userList;
    }

    /**
     * 查询所有内部企业的印章列表
     *
     * @return
     */
    @Override
    public List<Company> companySealList() {
        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        SealService sealService = new SealServiceImpl(client);

        List<Company> companyList = null;
        SealCondition sealCondition = new SealCondition();
        // 印章类型：PHYSICS("物理签章"),ELECTRONIC("电子签章"),不传默认查询电子章
        sealCondition.setCategory(SealCategory.ELECTRONIC);
        // 需要查询的印章状态：ALL("查询全部")，NORMAL("正常")，FREEZE("冻结")，INVALID("失效")，默认查询NORMAL状态
        sealCondition.setSealQueryStatus("NORMAL");

        try {
            companyList = sealService.innercompanySealList(sealCondition);
        } catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("请求契约锁异常，请检查请求参数！");
        }
        return companyList;
    }
}
