package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.SignMgrMapper;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.api.SignService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.Action;
import net.qiyuesuo.sdk.bean.contract.ActionType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Operator;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import net.qiyuesuo.sdk.impl.SignServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 签章管理
 *
 * @author generator
 */
@Service("signMgrService")
public class SignMgrServiceImpl extends BaseServiceImpl<SignMgrMapper, SignMgrEntity> implements ISignMgrService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEmployeeApi employeeApi;// 获取用户信息
    @Autowired
    private IBillTypeApi billTypeApi; // 根据billType找工程名
    @Autowired
    private IAttachmentApi attachmentApi; // 文件信息
    @Autowired
    private IUserApi userApi; //获取用户
    @Autowired
    private IPushMessageApi pushMessageApi; // 发送消息
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private ISignMgrLogService signMgrLogService;
    @Value("${qiyuesuo.client.url}")
    private String url;// 私有化开放平台请求地址
    @Value("${qiyuesuo.client.accessKey}")
    private String accessKey;// 私有化开放平台申请的token
    @Value("${qiyuesuo.client.accessSecret}")
    private String accessSecret;// 私有化开放平台申请的secret
    @Value("${qiyuesuo.contract.categoryId}")
    private Long categoryId;// 用印流程ID
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SignMgrMapper signMgrMapper;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Value("${qiyuesuo.callback.url}")
    private String CALL_BACK_URL;


    /**
     * 初始化sdk的client
     *
     * @return client
     */
    private SDKClient getSdkClient() {
        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        return client;
    }


    @Override
    public SignMgrEntity selectBycontractId(Long contractId) {
        return signMgrMapper.selectBycontractId(contractId);
    }

    /**
     * 用文件创建合同文档
     *
     * @param signMgrVO 签章管理主表VO
     * @return documentId
     */
    @Override
    public Long createByFile(SignMgrVO signMgrVO) {
        if (signMgrVO.getBillDocId() == null) {
            throw new BusinessException("业务文件id不能为空！");
        }
        if (signMgrVO.getBillDocumentType() == null) {
            throw new BusinessException("业务文件类型不能为空！");
        }
        if (signMgrVO.getBillDocumentName() == null) {
            throw new BusinessException("业务文件名称不能为空！");
        }
        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        ContractService contractService = new ContractServiceImpl(client);

        // 合同创建
        CreateDocumentRequest request = new CreateDocumentRequest();

        // 文档文件,默认单文件限制50M以下

        ClassPathResource resource = new ClassPathResource("doc/劳务分包合同范本（钢筋）.docx");
        try {
            request.setFile(new StreamFile(new FileInputStream(resource.getFile())));
        } catch (IOException e) {
            e.printStackTrace();
        }
        // 设置文件类型
        request.setFileType(signMgrVO.getBillDocumentType());
        // 设置合同文档名称
        request.setTitle(signMgrVO.getBillDocumentName());

        CreateDocumentResult result = null;
        try {
            result = contractService.createByFile(request);
        } catch (PrivateAppException e) {
            e.printStackTrace();
        }
        Long documentId = result.getDocumentId();
        logger.info("创建合同文件成功,documentId:{}", documentId);
        return documentId;
    }

    /**
     * 创建合同
     *
     * @param documentId 合同文档id
     * @param signMgrVO  签章管理主表VO
     * @return contractId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createContractByCategory(Long documentId, SignMgrVO signMgrVO) {
        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        ContractService contractService = new ContractServiceImpl(client);

        // 方法调用
        CreateContractRequest createContractRequest = new CreateContractRequest();
        // 设置用印流程ID（默认：私发公签）
        createContractRequest.setCategoryId(categoryId);
        // 设置合同名称
        createContractRequest.setSubject(signMgrVO.getBillDocumentName());
        // 是否立即发起合同，默认true。（true：立即发起；false：保存为草稿）
        createContractRequest.setSend(true);
        // 文档ID的集合（一个文档只能属于一个合同）
        List<Long> documents = new ArrayList<>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        // 合同描述,合同详情页面中的备注
        createContractRequest.setDescription(signMgrVO.getSignRequirements());


        // 合同创建人姓名，不传创建人的相关信息默认为发起方的名称
        createContractRequest.setCreatorName(signMgrVO.getCreatorName());
        // 合同创建人联系方式，联系方式允许使用大陆、台湾和香港的手机号，台湾和香港的手机号格式为：区号+空格+手机号，例：852 9xxxxxxx
        createContractRequest.setCreatorContact(signMgrVO.getCreatorContact());
        // 发起方名称
        createContractRequest.setTenantName(signMgrVO.getTenantName());


        // 签署方信息
        List<Signatory> signatories = new ArrayList<Signatory>();
        List<SignMgrSignatoryVO> signMgrSignatoryVos = signMgrVO.getSignMgrSignatoryEntities();


        // 按照签署顺序和签章顺序升序排列
        signMgrSignatoryVos.sort(Comparator.comparing(SignMgrSignatoryVO::getSignOrder).thenComparing(SignMgrSignatoryVO::getSealSignOrder));


        Map<Integer, List<SignMgrSignatoryVO>> signGroupBy = signMgrSignatoryVos.stream().collect(Collectors.groupingBy(SignMgrSignatoryVO::getSignOrder));

        /*// 合同创建人联系方式，联系方式允许使用大陆、台湾和香港的手机号，台湾和香港的手机号格式为：区号+空格+手机号，例：852 9xxxxxxx
//        createContractRequest.setCreatorContact(signGroupBy.get(1).get(0).getActualSignatoryContact());
        // 联系方式取当前的登陆人的手机号，没返回提示：请维护本人联系方式
        InvocationInfoProxy.getUserid();
        UserContext userContext = sessionManager.getUserContext();
        createContractRequest.setCreatorContact("18608891810");
        // 发起方名称，取合同的
//        createContractRequest.setTenantName(signGroupBy.get(1).get(0).getTenantName());

        createContractRequest.setTenantName(signMgrVO.getTenantName());*/


        signGroupBy.forEach((k, v) -> {
            Signatory signatory = new Signatory();
            // 签署方类型：COMPANY（企业），PERSONAL（个人）
            signatory.setTenantType(TenantType.valueOf(v.get(0).getTenantType()));
            // 签署方名称
            signatory.setTenantName(v.get(0).getTenantName());

            // 接受人姓名联系方式甲方先不添加，外部单位添加
            if (!Objects.equals(v.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                signatory.setReceiverName(v.get(0).getSignatureName());
                signatory.setContact(v.get(0).getSignatureContact());
            }

            // 设置签署顺序
            signatory.setSerialNo(v.get(0).getSignOrder());

            // 签署顺序（从1开始)；如果想按顺序签署，则分别设置签署方的serialNo为1,2,3
            List<Action> actions = new ArrayList<>();

            //遍历v，设置签章顺序
            List<List<SignMgrSignatoryVO>> lst = new ArrayList<>();
            Map<Integer, List<SignMgrSignatoryVO>> actionsMap = v.stream().collect(Collectors.groupingBy(SignMgrSignatoryVO::getSealSignOrder));

            // 实际上的action键值对
            Set<Map.Entry<Integer, List<SignMgrSignatoryVO>>> entries = actionsMap.entrySet();

            for (Map.Entry<Integer, List<SignMgrSignatoryVO>> entry : entries) {
                Action action = new Action();
                /*List<SignMgrSignatoryVO> actionList = new ArrayList<>();
                if (object instanceof List<?>){
                    for (Object o : (List<?>) object){
                        actionList.add(SignMgrSignatoryVO.class.cast(o));
                    }
                }*/
                List<SignMgrSignatoryVO> actionList = entry.getValue();
                action.setType(ActionType.valueOf(actionList.get(0).getSignActionType()));
                action.setName(actionList.get(0).getName());
                action.setSerialNo(actionList.get(0).getSealSignOrder());
                // 签署动作编号，唯一。前端生成
                action.setActionNo(actionList.get(0).getActionNo());
                // 添加签署人(一个或多个)
                List<Operator> operators = new ArrayList<Operator>();

                for (SignMgrSignatoryVO s : actionList) {
                    Operator operator = new Operator();
                    // 每个签署动作的经办人
                    operator.setOperatorName(s.getSignatureName());
                    operator.setOperatorContact(s.getSignatureContact());
                    operators.add(operator);
                }

                action.setActionOperators(operators);
                if (Objects.equals(v.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    // 内部单位甲方指定印章ids
                    // Set<Long> ids = Arrays.stream(s.getSignatureUserIds().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                    // action.setSealIds(ids);
                }
                actions.add(action);
            }

            /*List<SignMgrSignatoryVO> actionLists = v.stream().filter(e -> Objects.equals(e.getSignOrder(), v.get(0).getSignOrder()) && Objects.equals(e.getSealSignOrder(), v.get(0).getSealSignOrder())).collect(Collectors.toList());
            for (SignMgrSignatoryVO s : actionLists) {
                Action action = new Action();
                action.setType(ActionType.valueOf(s.getSignActionType()));
                action.setName(s.getName());
                action.setSerialNo(s.getSealSignOrder());
                // 签署动作编号，唯一
//                action.setActionNo(s.getActionNo());契约锁回调后期会加这个字段
                // 添加签署人(一个或多个)
                List<Operator> operators = new ArrayList<Operator>();
                Operator operator = new Operator();
                // 每个签署动作的经办人
                operator.setOperatorName(s.getActualSignatoryName());
                operator.setOperatorContact(s.getActualSignatoryContact());
                operators.add(operator);


                action.setActionOperators(operators);
                if (v.get(0).getSignatureType() == 0) {
                    // 内部单位甲方指定印章ids
//                    Set<Long> ids = Arrays.stream(s.getSignatureUserIds().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
//                    action.setSealIds(ids);
                }
                actions.add(action);
            }*/
            signatory.setActions(actions);

            // 添加签署方
            signatories.add(signatory);
        });

        // 添加签署方
        createContractRequest.setSignatories(signatories);
        Long contractId = null;
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        } catch (PrivateAppException e) {
            logger.info("创建合同失败，合同文档id：{}业务id:{}，来源业务单据类型：{}", documentId, signMgrVO.getBillId(), signMgrVO.getBillType());
            e.printStackTrace();
        }

        // 创建合同成功，持久化签章管理数据
        if (contractId != null) {
            logger.info("创建合同成功,contractId:{}，合同文档id：{}业务id:{}，来源业务单据类型：{}", contractId, documentId, signMgrVO.getBillId(), signMgrVO.getBillType());

            SignMgrEntity signMgrEntity = BeanMapper.map(signMgrVO, SignMgrEntity.class);
            // 回写入第三方平台业务id和业务文档id
            signMgrEntity.setSourceBillId(contractId);
            signMgrEntity.setSourceDocId(documentId);
            List<SignMgrSignatoryEntity> signMgrSignatoryEntities = signMgrEntity.getSignMgrSignatoryEntities();

            // 初始化任务状态为待激活
            for (SignMgrSignatoryEntity s : signMgrSignatoryEntities) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
//                LambdaUpdateWrapper<SignMgrSignatoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
//                updateWrapper.eq(SignMgrSignatoryEntity::getId,s.getId());
//                updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, s.getJobStatus());
//                signMgrSignatoryService.update(updateWrapper);
            }


            signMgrEntity.setSignMgrSignatoryEntities(signMgrSignatoryEntities);
            this.saveOrUpdate(signMgrEntity, false);

            // 查找并通知第一批签署人
//            this.findSignatory(signMgrEntity);
//             Integer maxSignOrder = -1;
//             Integer maxSealSignOrder = -1;
//             this.findSignatory2(contractId,maxSignOrder,maxSealSignOrder);
        }
        return contractId;
    }


    /**
     * 每个节点签署完成
     *
     * @param map
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> internalFlow(Map<String, String> map, SignMgrEntity signMgrEntity, List<SignMgrSignatoryEntity> actionList) {
        Map<String, Object> result = new HashMap<String, Object>();

        /*QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_bill_id", Long.valueOf(map.get("contractId")));
        SignMgrEntity signMgrEntity = this.getOne(queryWrapper);

        QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("pid", signMgrEntity.getId());
        List<SignMgrSignatoryEntity> sig = signMgrSignatoryService.list(queryWrapper1);*/

        // List<SignMgrSignatoryEntity> sig = signMgrEntity.getSignMgrSignatoryEntities();

        // 获取回调成功的签署动作节点信息
        String action = map.get("action");

        JSONObject jsonObject = JSONObject.parseObject(action);
        String actionNo = jsonObject.getString("actionNo");

        // 通过actionNo过滤出当前的唯一签署动作
        List<SignMgrSignatoryEntity> signMgrSignatoryEntity = actionList.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());


        // 更新这一签署动作对应的所有签署人，并记录相关日志数据
        for (SignMgrSignatoryEntity mgrSignatoryEntity : signMgrSignatoryEntity) {
            // 更新任务状态
            mgrSignatoryEntity.setJobStatus(SignMgrSignatoryEnum.COMPLETED.getValue());

            // 更新签署状态
            switch (jsonObject.getString("status")) {
                case "SIGNED":// 完成
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.SIGNED.getValue());
                    break;
                case "REJECTED":// 拒绝
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.RETURNED.getValue());
                    break;
                case "DISCARDED":// 废弃
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.WITHDRAWN.getValue());
                default:// 其他
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.OTHER.getValue());
                    break;

            }


            // 更新实际签署人
            mgrSignatoryEntity.setActualSignatoryName(map.get("operatorName"));
            mgrSignatoryEntity.setActualSignatoryContact(map.get("operatorMobile"));

            // 实际签署人id:根据实际签署人姓名和实际签署人联系方式获取,调用IUserApi接口获取用户信息
            if (mgrSignatoryEntity.getSignatureId() != null) {
                CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{String.valueOf(mgrSignatoryEntity.getSignatureId())});
                if (user.getData() != null) {
                    mgrSignatoryEntity.setActualSignatoryId(user.getData().get(0).getId());
                } else {
                    mgrSignatoryEntity.setActualSignatoryId(null);
                }
            } else {
                mgrSignatoryEntity.setActualSignatoryId(null);
            }


            try {
                mgrSignatoryEntity.setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("createTime")));
                mgrSignatoryEntity.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("completeTime")));
            } catch (ParseException e) {
                e.printStackTrace();
            }

//            // 实际签署人id:根据实际签署人姓名和实际签署人联系方式获取,调用IUserApi接口获取用户信息
//            CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{String.valueOf(mgrSignatoryEntity.getSignatureId())});
//            Long signatureId = Long.valueOf(user.getData().get(0).getUserCode());
//            mgrSignatoryEntity.setSignatureId(signatureId);


            // 更新任务状态、签章状态、实际签署人姓名、联系方式开始时间、完成时间
            LambdaUpdateWrapper<SignMgrSignatoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignMgrSignatoryEntity::getId, mgrSignatoryEntity.getId());
            updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, mgrSignatoryEntity.getJobStatus());
            updateWrapper.set(SignMgrSignatoryEntity::getSignResult, mgrSignatoryEntity.getSignResult());


            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryId, mgrSignatoryEntity.getActualSignatoryId());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryName, mgrSignatoryEntity.getActualSignatoryName());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryContact, mgrSignatoryEntity.getActualSignatoryContact());
            updateWrapper.set(SignMgrSignatoryEntity::getStartTime, mgrSignatoryEntity.getStartTime());
            updateWrapper.set(SignMgrSignatoryEntity::getEndTime, mgrSignatoryEntity.getEndTime());
            signMgrSignatoryService.update(updateWrapper);


            // 新增一条签章记录日志

            SignMgrSignatoryEntity sms = signMgrSignatoryService.selectById(mgrSignatoryEntity.getId());

            SignMgrLogEntity sml = BeanMapper.map(sms, SignMgrLogEntity.class);
            sml.setBillId(signMgrEntity.getBillId());
            sml.setBillType(signMgrEntity.getBillType());
            sml.setBillDocId(signMgrEntity.getBillDocId());
            sml.setBillDocumentName(signMgrEntity.getBillDocumentName());
            sml.setBillDocumentType(signMgrEntity.getBillDocumentType());
            sml.setSignRequirements(signMgrEntity.getSignRequirements());
            sml.setCreatorName(signMgrEntity.getCreatorName());
            sml.setContact(signMgrEntity.getCreatorContact());


            sml.setThirdSysCallbackContractId(Long.valueOf(map.get("contractId")));
            sml.setThirdSysCallbackTenantId(map.get("tenantId"));
            sml.setThirdSysCallbackSignatorySerialNo(map.get("signatorySerialNo"));
            sml.setThirdSysCallbackTenantName(map.get("tenantName"));
            sml.setThirdSysCallbackSn(map.get("sn"));
            sml.setThirdSysCallbackStatus(map.get("status"));
            sml.setThirdSysCallbackType(map.get("type"));
            sml.setThirdSysCallbackContact(map.get("contact"));
            sml.setThirdSysCallbackOperatorName(map.get("operatorName"));
            sml.setThirdSysCallbackOperatorMobile(map.get("operatorMobile"));
            sml.setThirdSysCallbackOperatorNumber(map.get("operatorNumber"));
            sml.setThirdSysCallbackReceiverNumber(map.get("receiverNumber"));
            sml.setThirdSysCallbackSerialNo(map.get("serialNo"));
            sml.setThirdSysCallbackActionName(map.get("actionName"));
            sml.setThirdSysCallbackActionNo(map.get("actionNo"));

            signMgrLogService.saveOrUpdate(sml, false);


        }

        //第二种方法：可以记录当前回调成功的最大的签署顺序和签章顺序，寻找下一个人和通知消息可以改成异步方法，快速响应契约锁
        Integer maxSignOrder = signMgrSignatoryEntity.get(0).getSignOrder();
        Integer maxSealSignOrder = signMgrSignatoryEntity.get(0).getSealSignOrder();
        // this.nextSignatory(Long.valueOf(map.get("contractId")), maxSignOrder, maxSealSignOrder);

        result.put("maxSignOrder", maxSignOrder);
        result.put("maxSealSignOrder", maxSealSignOrder);

        return result;
    }

    /**
     * 待签章的人员列表
     *
     * @param signMgrEntity
     * @return List<SignMgrSignatoryEntity>
     */
    public void findSignatory(SignMgrEntity signMgrEntity) {
        List<SignMgrSignatoryEntity> results = new ArrayList<>();

        List<SignMgrSignatoryEntity> sms = signMgrEntity.getSignMgrSignatoryEntities();

        List<Integer> list = new ArrayList<>();
        for (SignMgrSignatoryEntity sm : sms) {
            if (Objects.equals(sm.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())) {
                list.add(sm.getJobStatus());
            }
        }

        // 如果都是待激活,找到第一个签署方的第一批签署人
        if (list.size() == sms.size()) {
            sms.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = sms.get(0);
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();

            // 根据记录的最小签署顺序和签章顺序过滤出第一批签署人
            List<SignMgrSignatoryEntity> ss = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            results.addAll(ss);

            for (SignMgrSignatoryEntity s : ss) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                // 修改任务状态为待签章
                LambdaUpdateWrapper<SignMgrSignatoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignMgrSignatoryEntity::getId, s.getId());
                updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, s.getJobStatus());
                signMgrSignatoryService.update(updateWrapper);
            }
            // 通知这批人
//            this.sendMessage(results);

            /*List<SignMgrSignatoryEntity> internal = sms.stream().filter(e -> Objects.equals(e.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())).collect(Collectors.toList());
            for (SignMgrSignatoryEntity s : internal) {
                // 第一个签署方的第一批签署人是内部单位，改状态
                if(s.getSignOrder() == 1 && s.getSealSignOrder() == 1){
                    s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                    // 修改任务状态为待签章
                    LambdaUpdateWrapper<SignMgrSignatoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(SignMgrSignatoryEntity::getId, s.getId());
                    updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, s.getJobStatus());
                    signMgrSignatoryService.update(updateWrapper);
                    results.add(s);
                }
            }*/
        } else {
            // 找到下一批待签署的人员列表
            List<SignMgrSignatoryEntity> s = sms.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (!s.isEmpty()) {
                // 找到内部单位的下一个待签章人员（内部单位剩余待激活（不为空）的升序排列第一个内部签署方的第一个签署人）
                s.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = s.get(0);
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();

                // 根据记录的最小签署顺序和签章顺序过滤出第一批签署人
                List<SignMgrSignatoryEntity> f = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                results.addAll(f);
//                this.sendMessage(results);
            } else {
                // 无待激活状态，判定全部完成,（不做操作的话等全局回调合同完成）这里可以把合同状态通知给业务系统
            }
        }

    }


    /**
     * 下一个待签章的人员列表
     *
     * @param contractId
     * @param maxSignOrder
     * @param maxSealSignOrder
     * @return List<SignMgrSignatoryEntity>
     */
    public List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder) {

        List<SignMgrSignatoryEntity> operators = new ArrayList<>();
        // SignMgrEntity signMgrEntity = this.selectById(contractId);
        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_bill_id", contractId);
        SignMgrEntity signMgrEntity = this.getOne(queryWrapper);

        QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("pid", signMgrEntity.getId());
        List<SignMgrSignatoryEntity> actionList = signMgrSignatoryService.list(queryWrapper1);

        if (actionList.size() == 0) {
            throw new BusinessException("未查询到签署动作任务数据！");
        }

        // 如果都是待激活,找到第一个签署方的第一批签署人
        if (maxSignOrder <= 0 && maxSealSignOrder <= 0) {
            actionList.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = actionList.get(0);
            // 内部单位可以改状态，外部单位等所有接收方回调统一修改
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();

            // 根据记录的最小签署顺序和签章顺序过滤出第一批签署人
            List<SignMgrSignatoryEntity> opts = actionList.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            operators.addAll(opts);

            for (SignMgrSignatoryEntity s : opts) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                // 修改任务状态为待签章
                // LambdaUpdateWrapper<SignMgrSignatoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
                // updateWrapper.eq(SignMgrSignatoryEntity::getId, s.getId());
                // updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, s.getJobStatus());
                // signMgrSignatoryService.update(updateWrapper);
                signMgrSignatoryService.updateById(s);
            }
            // 通知业务系统当前签署状态
            // extracted(signMgrEntity, min);
        } else {
            // 找到下一批待签署的人员列表
            // List<SignMgrSignatoryEntity> opts = actionList.stream().filter(e -> e.getSignOrder() >= maxSignOrder && e.getSealSignOrder() > maxSealSignOrder).collect(Collectors.toList());
            List<SignMgrSignatoryEntity> opts = actionList.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (!opts.isEmpty()) {
                // 找到下一个待签章人员
                opts.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = opts.get(0);
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();

                // 根据记录的最小签署顺序和签章顺序过滤出第一批签署人
                List<SignMgrSignatoryEntity> acts = opts.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                operators.addAll(acts);
                for (SignMgrSignatoryEntity act : acts) {
                    act.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                    signMgrSignatoryService.updateById(act);
                }
                // extracted(signMgrEntity, min);
            }
        }

        return operators;
    }


    private void extracted(SignMgrEntity signMgrEntity, SignMgrSignatoryEntity min) {
        int status;
        if (Objects.equals(min.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            status = 3;
            // 待甲方签章
            this.sendStatus(signMgrEntity.getBillType(), signMgrEntity.getBillId(), signMgrEntity.getBillRefCode(), status);
        } else {
            status = 2;
            // 待乙方签章
            this.sendStatus(signMgrEntity.getBillType(), signMgrEntity.getBillId(), signMgrEntity.getBillRefCode(), status);
        }
    }

    /**
     * 同步签章状态
     *
     * @param billType
     * @param billId
     * @param refcode
     * @param status
     */
    public void sendStatus(String billType, Long billId, String refcode, int status) {
        //更新业务单据中的附件信息
        //根据单据类型查询元数据信息
        CommonResponse<MdReferVO> mdRefResp = billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            logger.error("签章状态更新失败,根据billType-{}查询元数据信息失败,原因：{}！", billType, mdRefResp.getMsg());
            // return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "签章状态更新失败！");
        }
        MdReferVO mdRef = mdRefResp.getData();
        //获取到对应工程信息，调用指定工程的文档信息会写服务
        String url = BASE_HOST + mdRef.getProjectName() + "/signature/changeStatus";
        Map<String, Object> param = new HashMap<>();
        param.put("billId", billId);
        // 合同和变更合同区分字段
        param.put("refCode", refcode);
        param.put("status", status);

        try {
            Map<String, String> headerMap = new HashMap<>();
            // headerMap.put("authority", authority);
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson(url, JSONObject.toJSONString(param), headerMap, 10000, 10000);
            logger.info("调用业务系统url-{},param-{}签章状态结果：{}", url, JSONObject.toJSONString(param), httpRespStr);
            if (!StringUtils.isEmpty(httpRespStr)) {
                JSONObject resultJson = JSONObject.parseObject(httpRespStr);
                String code = resultJson.getString("code");
                if (Integer.parseInt(code) != 0) {
                    // 业务系统处理失败，补偿机制
                    logger.info("调用业务系统成功，返回失败");
                }
            }


        } catch (Exception e) {
            logger.error("调用业务系统url-{},param-{}签章状态异常：", url, JSONObject.toJSONString(param), e);
            // return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "签章状态更新更新失败！");
            // 调用业务系统请求失败，补偿机制

        }


    }

    /**
     * 发送消息
     *
     * @param operators
     * @return CommonResponse<String>
     */
    public CommonResponse<String> sendMessage(Long contractId, List<SignMgrSignatoryEntity> operators) {
        // 判断是不是接收方，是：（判断是不是在系统内，是：通知，否：不通知）否：
        // 如果系统内部有这些人，执行通知
        PushMsgParameter parameter = new PushMsgParameter();

        String[] channel;

        // 接受人
        String[] receivers;
        // 消息内容
        String content;
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            // 消息发送渠道类型
            ArrayList<String> lst = new ArrayList<>();
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);

            receivers = operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            content = "您有一个待签署合同:<a href=\"" + BASE_HOST + "/ejc-contractbase-frontend/#/privateSign?" + "contractId=" + contractId + "&tenantType="
                    + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=" + operators.get(0).getSignatureContact() + "\">点我签署</a>";
        } else {
            // 消息发送渠道类型
            ArrayList<String> lst = new ArrayList<>();
            // 短信
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);

            logger.info("生成公有云签署链接，通知乙方签署！");

            receivers = operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            logger.info("接收通知的人：{}", JSONObject.toJSONString(receivers));
            content = "您有一个待签署合同：<a href=\"" + BASE_HOST + "/ejc-contractbase-frontend/#/publicSign?" + "contractId=" + contractId + "&contact="
                    + operators.get(0).getSignatureContact() + "\">点我签署</a>";
        }

        // 消息类型(应该是枚举)
        String msgType = "task";

        // 消息主题
        String subject = "签章提醒";

        // 租户ID
        CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{receivers[0]});
        if (!user.isSuccess()) {
            throw new BusinessException("获取用户信息异常！");
        }
        logger.info("查询到的租户列表：{}", user.getData());
        String tenantId = String.valueOf(user.getData().get(0).getTenantId());

        parameter.setChannel(channel);
        parameter.setReceivers(receivers);
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);

        return pushMessageApi.pushMessage(parameter);
    }

    /**
     * 所有接收方签署完成
     *
     * @param map
     */
    @Override
    public void AllReceiverComplate(Map<String, String> map) {
        // 所有接收方签署完成

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_bill_id", Long.valueOf(map.get("contractId")));
        SignMgrEntity signMgrEntity = this.getOne(queryWrapper);
        List<SignMgrSignatoryEntity> sig = signMgrEntity.getSignMgrSignatoryEntities();

        // 获取回调成功的签署动作节点信息
        String action = map.get("action");

        JSONObject jsonObject = JSONObject.parseObject(action);
        String actionNo = jsonObject.getString("actionNO");

        // 通过actionNo过滤出当前的唯一签署动作
        List<SignMgrSignatoryEntity> signMgrSignatoryEntity = sig.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());


    }


    /**
     * 用文件创建合同文档
     * <p>
     * 1.初始化client
     * 2.初始化合同服务
     * 3.创建合同的请求
     * 4.设置文档文件流
     * 5.设置文件类型
     * 6.设置合同文档名称
     *
     * @param url
     * @param billDocumentName
     * @param billDocumentType
     * @return documentId
     */
    @Override
    public Long createDocument(String url, String billDocumentName, String billDocumentType) {
        if (StringUtils.isEmpty(url)) {
            throw new BusinessException("不能通过业务文件id获取文件地址！");
        }
        if (StringUtils.isEmpty(billDocumentType)) {
            throw new BusinessException("业务文件类型不能为空！");
        }

        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        // 合同创建
        CreateDocumentRequest request = new CreateDocumentRequest();

        //
        // Response fileResponse = attachmentApi.downloadFileById(initSignatureVO.getBillDocId());
        // Response.Body body = fileResponse.body();
        //
        // inputStream = body.asInputStream();

        // CommonResponse<AttachmentVO> attachmentResp = attachmentApi.queryDetail(initSignatureVO.getBillDocId().toString());


        Long documentId = null;
        try {
            documentId = contractService.createDocumentByUrl(new DocumentCreateByUrl(url, billDocumentName, billDocumentType, null));
        } catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("创建合同文档异常！");
        }
        logger.info("创建合同文件成功,documentId:{}", documentId);

        return documentId;
    }


    /**
     * 创建合同
     * <p>
     * 1.初始化client
     * 2.初始化合同服务
     * 3.设置私发公签用印流程ID
     * 4.默认立即发起合同
     * 5.设置合同的文档ID的集合
     * 6.添加合同描述
     * 7.添加合同创建人姓名
     * 8.添加合同创建人手机号
     * 9.添加发起方名称
     * 10.添加签署方信息-签署方类型
     * 11.添加签署方信息-签署方名称
     * 12.添加签署方信息-接收人姓名
     * 13.添加签署方信息-接收人手机号
     * 14.
     * 15.
     * 16.
     * 17.
     *
     * @param documentId      合同文档id
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @Override
    public Long createContract(Long documentId, InitSignatureVO initSignatureVO) {
        SignMgrVO signMgrVO = new SignMgrVO();
        List<SignMgrSignatoryVO> signMgrSignatoryEntities = signMgrVO.getSignMgrSignatoryEntities();

        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        // 设置用印流程ID（默认：私发公签）
        createContractRequest.setCategoryId(categoryId);
        // 设置合同名称
        createContractRequest.setSubject(initSignatureVO.getBillDocumentName());
        // 是否立即发起合同，默认true。（true：立即发起；false：保存为草稿）
        createContractRequest.setSend(true);
        // 文档ID的集合（一个文档只能属于一个合同）
        List<Long> documents = new ArrayList<>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        // 合同描述,合同详情页面中的备注
        createContractRequest.setDescription(initSignatureVO.getSignRequirements());
        // 合同创建人姓名，不传创建人的相关信息默认为发起方的名称
        createContractRequest.setCreatorName(initSignatureVO.getCreatorName());
        // 合同创建人联系方式，联系方式允许使用大陆、台湾和香港的手机号，台湾和香港的手机号格式为：区号+空格+手机号，例：852 9xxxxxxx
        createContractRequest.setCreatorContact(initSignatureVO.getCreatorContact());
        // 发起方名称
        createContractRequest.setTenantName(initSignatureVO.getTenantName());


        signMgrVO.setBillId(initSignatureVO.getBillId());
        signMgrVO.setBillType(initSignatureVO.getBillType());
        signMgrVO.setBillRefCode(initSignatureVO.getBillRefCode());

        signMgrVO.setSourceDocId(documentId);
        signMgrVO.setBillDocId(initSignatureVO.getBillDocId());
        signMgrVO.setBillDocumentName(initSignatureVO.getBillDocumentName());
        signMgrVO.setBillDocumentType(initSignatureVO.getBillDocumentType());
        signMgrVO.setSignRequirements(initSignatureVO.getSignRequirements());
        signMgrVO.setCreatorName(initSignatureVO.getCreatorName());
        signMgrVO.setCreatorContact(initSignatureVO.getCreatorContact());
        signMgrVO.setTenantName(initSignatureVO.getTenantName());

        // signMgrVO.setId();
        // signMgrVO.setCreateUserCode();
        // signMgrVO.setCreateTime();
        // signMgrVO.setUpdateUserCode();
        // signMgrVO.setUpdateTime();
        // signMgrVO.setDr();
        // signMgrVO.setTenantId();
        // signMgrVO.setSyncEsFlag();
        // signMgrVO.setRowState();
        // signMgrVO.setAttachIds();
        // signMgrVO.setVersion();
        // signMgrVO.setCustomField();


        List<InitSignatoryVO> initSignatoryVOList = initSignatureVO.getSignMgrSignatoryEntities();
        // 按照签署顺序和签章顺序升序排列
        initSignatoryVOList.sort(Comparator.comparing(InitSignatoryVO::getSignOrder));


        // 签署方信息
        List<Signatory> signatories = new ArrayList<>();

        for (InitSignatoryVO initSignatoryVO : initSignatoryVOList) {
            Signatory signatory = new Signatory();
            // 签署方类型：COMPANY（企业），PERSONAL（个人）
            signatory.setTenantType(TenantType.valueOf(initSignatoryVO.getTenantType()));
            // 签署方名称
            signatory.setTenantName(initSignatoryVO.getTenantName());
            // 签署方编号:T_租户id_refCode_业务id_业务类型_唯一编码
            String tenantId = String.valueOf(InvocationInfoProxy.getTenantid());
            String signatoryHead;
            if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                signatoryHead = "T_";
            } else {
                signatoryHead = "S_";
            }
            String signatoryNo = signatoryHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId()
                    + "_" + initSignatureVO.getBillType() + "_" + String.valueOf(IdWorker.getId());
            signatory.setSignatoryNo(signatoryNo);
            // 接收人姓名联系方式甲方先不添加，外部单位添加
            if (!Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                if (StringUtils.isEmpty(initSignatoryVO.getReceiverName())) {
                    throw new BusinessException("乙方接收人名称不能为空！");
                }
                if (StringUtils.isEmpty(initSignatoryVO.getContact())) {
                    throw new BusinessException("乙方接收人手机号不能为空！");
                }
                signatory.setReceiverName(initSignatoryVO.getReceiverName());
                signatory.setContact(initSignatoryVO.getContact());
            }
            // 设置签署顺序
            signatory.setSerialNo(initSignatoryVO.getSignOrder());

            // 签署顺序（从1开始)；如果想按顺序签署，则分别设置签署方的serialNo为1,2,3
            List<Action> actions = new ArrayList<>();
            List<SealInfoVO> signatureList = initSignatoryVO.getSignatureList();
            for (SealInfoVO sealInfoVO : signatureList) {
                SignMgrSignatoryVO signMgrSignatoryVO = new SignMgrSignatoryVO();

                Action action = new Action();
                // 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
                action.setType(ActionType.valueOf(sealInfoVO.getSignActionType()));
                // 签署动作编号，唯一。前端生成
                // 签署方编号:T_租户id_refCode_业务id_业务类型_签署动作类型_签章顺序_唯一编码
                String actionHead = null;
                if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    actionHead = "T_";
                } else {
                    actionHead = "S_";
                }
                String actionNo = actionHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId()
                        + "_" + initSignatureVO.getBillType() + "_" + ActionType.valueOf(sealInfoVO.getSignActionType())
                        + "_" + String.valueOf(sealInfoVO.getSealSignOrder()) + "_" + String.valueOf(IdWorker.getId());
                action.setActionNo(actionNo);
                // 签署动作名称,根据签署动作类型填写
                action.setName(sealInfoVO.getName());
                // 签章顺序,前置设置1，后置逐渐增大，无序设置相同
                action.setSerialNo(sealInfoVO.getSealSignOrder());

                // 添加签署人(一个或多个)
                List<Operator> operators = new ArrayList<>();
                List<SignatoryVO> signatoryVOList = sealInfoVO.getSignatoryVOList();

                // 甲方指定一组默认的印章
                if (!StringUtils.isEmpty(sealInfoVO.getSourceSealId()) && !StringUtils.isEmpty(sealInfoVO.getSourceSealName())) {
                    if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                        Set<Long> ids = Arrays.stream(sealInfoVO.getSourceSealId().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                        Set<String> names = Arrays.stream(sealInfoVO.getSourceSealName().split(",")).collect(Collectors.toSet());
                        action.setSealIds(ids);
                        action.setSealNames(names);
                    }
                }


                for (SignatoryVO signatoryVO : signatoryVOList) {
                    Operator operator = new Operator();

                    // 签章人姓名
                    operator.setOperatorName(signatoryVO.getSignatureName());
                    // 签章人联系方式
                    operator.setOperatorContact(signatoryVO.getSignatureContact());
                    operators.add(operator);

                    // 契约锁：乙方为空的
                    signMgrSignatoryVO.setSignatureId(signatoryVO.getSignatureId());
                    signMgrSignatoryVO.setSignatureName(signatoryVO.getSignatureName());
                    signMgrSignatoryVO.setSignatureContact(signatoryVO.getSignatureContact());


                    // 契约锁
                    signMgrSignatoryVO.setSignActionType(sealInfoVO.getSignActionType());
                    signMgrSignatoryVO.setName(sealInfoVO.getName());
                    signMgrSignatoryVO.setSealSignOrder(sealInfoVO.getSealSignOrder());
                    signMgrSignatoryVO.setSourceSealId(sealInfoVO.getSourceSealId());
                    signMgrSignatoryVO.setSourceSealName(sealInfoVO.getSourceSealName());

                    // 本平台
                    signMgrSignatoryVO.setSealId(sealInfoVO.getSealId());
                    signMgrSignatoryVO.setSealName(sealInfoVO.getSealName());
                    signMgrSignatoryVO.setSignatureUserIds(sealInfoVO.getSignatureUserIds());
                    signMgrSignatoryVO.setActionNo(actionNo);

                    // 契约锁
                    signMgrSignatoryVO.setTenantName(initSignatoryVO.getTenantName());
                    signMgrSignatoryVO.setTenantType(initSignatoryVO.getTenantType());
                    signMgrSignatoryVO.setReceiverName(initSignatoryVO.getReceiverName());
                    signMgrSignatoryVO.setContact(initSignatoryVO.getContact());
                    signMgrSignatoryVO.setSignOrder(initSignatoryVO.getSignOrder());

                    // 本平台
                    signMgrSignatoryVO.setSignatureType(initSignatoryVO.getSignatureType());
                    signMgrSignatoryVO.setSignatoryNo(signatoryNo);
                    signMgrSignatoryVO.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());

                    signMgrSignatoryEntities.add(signMgrSignatoryVO);
                }
                action.setActionOperators(operators);
                // 添加签署动作
                actions.add(action);
            }
            signatory.setActions(actions);
            // 添加签署方
            signatories.add(signatory);
            // signMgrSignatoryVO.setActualSignatoryId();
            // signMgrSignatoryVO.setActualSignatoryName();
            // signMgrSignatoryVO.setActualSignatoryContact();
            // signMgrSignatoryVO.setSignResult();
            // signMgrSignatoryVO.setMark();
            // signMgrSignatoryVO.setStartTime();
            // signMgrSignatoryVO.setEndTime();
            // signMgrSignatoryVO.setPid();
            // signMgrSignatoryVO.setId();
            // signMgrSignatoryVO.setCreateUserCode();
            // signMgrSignatoryVO.setCreateTime();
            // signMgrSignatoryVO.setUpdateUserCode();
            // signMgrSignatoryVO.setUpdateTime();
            // signMgrSignatoryVO.setDr();
            // signMgrSignatoryVO.setTenantId();
            // signMgrSignatoryVO.setSyncEsFlag();
            // signMgrSignatoryVO.setRowState();
            // signMgrSignatoryVO.setAttachIds();
            // signMgrSignatoryVO.setVersion();
            // signMgrSignatoryVO.setCustomField();
        }

        // 创建合同请求添加签署方
        createContractRequest.setSignatories(signatories);
        Long contractId;
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        } catch (PrivateAppException e) {
            e.printStackTrace();
            // logger.info("创建合同失败，合同文档id：{}业务id:{}，来源业务单据类型：{}", documentId, signMgrVO.getBillId(), signMgrVO.getBillType());
            throw new BusinessException("创建合同失败!");
        }
        signMgrVO.setSourceBillId(contractId);
        signMgrVO.setSignMgrSignatoryEntities(signMgrSignatoryEntities);

        // 创建合同成功，保存签章管理数据
        SignMgrEntity signMgrEntity = BeanMapper.map(signMgrVO, SignMgrEntity.class);
        this.saveOrUpdate(signMgrEntity, false);
        logger.info("创建合同成功,contractId:{}，合同文档id：{}，业务id:{}，来源业务单据类型：{}", contractId, documentId, signMgrEntity.getBillId(), signMgrEntity.getBillType());
        return contractId;
    }

    /**
     * 获取公有云合同签署短链接
     * 1.初始化client
     * 2.初始化合同服务
     * 3.设置合同id
     *
     * @param contractId 合同id
     * @param contact    手机号
     * @return cloudSignUrl
     */
    @Override
    public String createCloudSignUrl(Long contractId, String contact) {
        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        String cloudSignUrl;
        try {
            cloudSignUrl = contractService.cloudSignUrl(contractId, contact);
        } catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("获取公有云合同签署短链接，失败！");
        }
        logger.info("文件签署链接:{}", cloudSignUrl);
        return cloudSignUrl;
    }

    /**
     * 获取私有云合同签署短链接
     *
     * @param contractId
     * @param tenantType
     * @param tenantName
     * @param contact
     * @return
     */
    @Override
    public String createPrivateSignUrl(Long contractId, String tenantType, String tenantName, String contact) {
        SDKClient client = getSdkClient();
        SignService signService = new SignServiceImpl(client);

        SignUrlRequest request = new SignUrlRequest();
        request.setContractId(contractId);
        request.setTenantType(TenantType.COMPANY);
        request.setTenantName(tenantName);
        request.setContact(contact);
        request.setExpireTime(259200);

        String privateSignUrl;
        // 改成私有云链接真实回调地址
        request.setCallbackPage(CALL_BACK_URL);
        try {
            privateSignUrl = signService.signUrl(request);
        } catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("获取私有云合同签署短链接，失败！");
        }

        return privateSignUrl;
    }


}
