package com.ejianc.business.signaturemanage.controller.api;

import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.vo.SupplierCloudSignUrlVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 签章管理API控制器
 *
 * @author baipengyan
 * @Description: 签章管理API控制器
 */
@RestController
@RequestMapping(value = "/api/supplier")
public class SupplierApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    ISignMgrService signMgrService;

    /**
     * 获取公有云合同签署短链接
     * 1.生成公有云合同签署短链接
     *
     * @return cloudSignUrl
     */
    @PostMapping(value = "/getCloudSignUrl")
    public CommonResponse<String> cloudSignUrl(@RequestBody SupplierCloudSignUrlVO supplierCloudSignUrlVO) {
        String cloudSignUrl = signMgrService.createCloudSignUrl(supplierCloudSignUrlVO.getContractId(), supplierCloudSignUrlVO.getContact());
        // String cloudSignUrl = "https://www.runoob.com/";
        return CommonResponse.success("获取公有云合同签署短链接，成功！", cloudSignUrl);
    }
}
