/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.SignMgrMapper;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.InitSignatoryVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.SealInfoVO;
import com.ejianc.business.signaturemanage.vo.SignMgrSignatoryVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.business.signaturemanage.vo.SignatoryVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.Action;
import net.qiyuesuo.sdk.bean.contract.ActionType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Operator;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import net.qiyuesuo.sdk.impl.SignServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="signMgrService")
public class SignMgrServiceImpl
extends BaseServiceImpl<SignMgrMapper, SignMgrEntity>
implements ISignMgrService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private ISignMgrLogService signMgrLogService;
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SignMgrMapper signMgrMapper;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${qiyuesuo.callback.url}")
    private String CALL_BACK_URL;

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    @Override
    public SignMgrEntity selectBycontractId(Long contractId) {
        return this.signMgrMapper.selectBycontractId(contractId);
    }

    @Override
    public Long createByFile(SignMgrVO signMgrVO) {
        if (signMgrVO.getBillDocId() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signMgrVO.getBillDocumentType() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signMgrVO.getBillDocumentName() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateDocumentRequest request = new CreateDocumentRequest();
        ClassPathResource resource = new ClassPathResource("doc/\u52b3\u52a1\u5206\u5305\u5408\u540c\u8303\u672c\uff08\u94a2\u7b4b\uff09.docx");
        try {
            request.setFile((FileItem)new StreamFile((InputStream)new FileInputStream(resource.getFile())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        request.setFileType(signMgrVO.getBillDocumentType());
        request.setTitle(signMgrVO.getBillDocumentName());
        CreateDocumentResult result = null;
        try {
            result = contractService.createByFile(request);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
        }
        Long documentId = result.getDocumentId();
        this.logger.info("\u521b\u5efa\u5408\u540c\u6587\u4ef6\u6210\u529f,documentId:{}", (Object)documentId);
        return documentId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createContractByCategory(Long documentId, SignMgrVO signMgrVO) {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setCategoryId(this.categoryId);
        createContractRequest.setSubject(signMgrVO.getBillDocumentName());
        createContractRequest.setSend(Boolean.valueOf(true));
        ArrayList<Long> documents = new ArrayList<Long>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        createContractRequest.setDescription(signMgrVO.getSignRequirements());
        createContractRequest.setCreatorName(signMgrVO.getCreatorName());
        createContractRequest.setCreatorContact(signMgrVO.getCreatorContact());
        createContractRequest.setTenantName(signMgrVO.getTenantName());
        ArrayList signatories = new ArrayList();
        List signMgrSignatoryVos = signMgrVO.getSignMgrSignatoryEntities();
        signMgrSignatoryVos.sort(Comparator.comparing(SignMgrSignatoryVO::getSignOrder).thenComparing(SignMgrSignatoryVO::getSealSignOrder));
        Map<Integer, List<SignMgrSignatoryVO>> signGroupBy = signMgrSignatoryVos.stream().collect(Collectors.groupingBy(SignMgrSignatoryVO::getSignOrder));
        signGroupBy.forEach((k, v) -> {
            Signatory signatory = new Signatory();
            signatory.setTenantType(TenantType.valueOf((String)((SignMgrSignatoryVO)v.get(0)).getTenantType()));
            signatory.setTenantName(((SignMgrSignatoryVO)v.get(0)).getTenantName());
            if (!Objects.equals(((SignMgrSignatoryVO)v.get(0)).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                signatory.setReceiverName(((SignMgrSignatoryVO)v.get(0)).getSignatureName());
                signatory.setContact(((SignMgrSignatoryVO)v.get(0)).getSignatureContact());
            }
            signatory.setSerialNo(((SignMgrSignatoryVO)v.get(0)).getSignOrder());
            ArrayList<Action> actions = new ArrayList<Action>();
            ArrayList lst = new ArrayList();
            Map<Integer, List<SignMgrSignatoryVO>> actionsMap = v.stream().collect(Collectors.groupingBy(SignMgrSignatoryVO::getSealSignOrder));
            Set<Map.Entry<Integer, List<SignMgrSignatoryVO>>> entries = actionsMap.entrySet();
            for (Map.Entry<Integer, List<SignMgrSignatoryVO>> entry : entries) {
                Action action = new Action();
                List<SignMgrSignatoryVO> actionList = entry.getValue();
                action.setType(ActionType.valueOf((String)actionList.get(0).getSignActionType()));
                action.setName(actionList.get(0).getName());
                action.setSerialNo(actionList.get(0).getSealSignOrder());
                action.setActionNo(actionList.get(0).getActionNo());
                ArrayList<Operator> operators = new ArrayList<Operator>();
                for (SignMgrSignatoryVO s : actionList) {
                    Operator operator = new Operator();
                    operator.setOperatorName(s.getSignatureName());
                    operator.setOperatorContact(s.getSignatureContact());
                    operators.add(operator);
                }
                action.setActionOperators(operators);
                if (Objects.equals(((SignMgrSignatoryVO)v.get(0)).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    // empty if block
                }
                actions.add(action);
            }
            signatory.setActions(actions);
            signatories.add(signatory);
        });
        createContractRequest.setSignatories(signatories);
        Long contractId = null;
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e) {
            this.logger.info("\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c\u5408\u540c\u6587\u6863id\uff1a{}\u4e1a\u52a1id:{}\uff0c\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{documentId, signMgrVO.getBillId(), signMgrVO.getBillType()});
            e.printStackTrace();
        }
        if (contractId != null) {
            this.logger.info("\u521b\u5efa\u5408\u540c\u6210\u529f,contractId:{}\uff0c\u5408\u540c\u6587\u6863id\uff1a{}\u4e1a\u52a1id:{}\uff0c\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{contractId, documentId, signMgrVO.getBillId(), signMgrVO.getBillType()});
            SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)BeanMapper.map((Object)signMgrVO, SignMgrEntity.class));
            signMgrEntity.setSourceBillId(contractId);
            signMgrEntity.setSourceDocId(documentId);
            List<SignMgrSignatoryEntity> signMgrSignatoryEntities = signMgrEntity.getSignMgrSignatoryEntities();
            for (SignMgrSignatoryEntity s : signMgrSignatoryEntities) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
            }
            signMgrEntity.setSignMgrSignatoryEntities(signMgrSignatoryEntities);
            this.saveOrUpdate((Object)signMgrEntity, false);
        }
        return contractId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> internalFlow(Map<String, String> map, SignMgrEntity signMgrEntity, List<SignMgrSignatoryEntity> actionList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String action = map.get("action");
        JSONObject jsonObject = JSONObject.parseObject((String)action);
        String actionNo = jsonObject.getString("actionNo");
        List signMgrSignatoryEntity = actionList.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());
        for (SignMgrSignatoryEntity mgrSignatoryEntity : signMgrSignatoryEntity) {
            mgrSignatoryEntity.setJobStatus(SignMgrSignatoryEnum.COMPLETED.getValue());
            switch (jsonObject.getString("status")) {
                case "SIGNED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.SIGNED.getValue());
                    break;
                }
                case "REJECTED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.RETURNED.getValue());
                    break;
                }
                case "DISCARDED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.WITHDRAWN.getValue());
                }
                default: {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.OTHER.getValue());
                }
            }
            mgrSignatoryEntity.setActualSignatoryName(map.get("operatorName"));
            mgrSignatoryEntity.setActualSignatoryContact(map.get("operatorMobile"));
            if (mgrSignatoryEntity.getSignatureId() != null) {
                CommonResponse user = this.userApi.queryListByIds(new String[]{String.valueOf(mgrSignatoryEntity.getSignatureId())});
                if (user.isSuccess()) {
                    mgrSignatoryEntity.setActualSignatoryId(((UserVO)((List)user.getData()).get(0)).getId());
                } else {
                    mgrSignatoryEntity.setActualSignatoryId(null);
                }
            } else {
                mgrSignatoryEntity.setActualSignatoryId(null);
            }
            try {
                mgrSignatoryEntity.setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("createTime")));
                mgrSignatoryEntity.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("completeTime")));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)mgrSignatoryEntity.getId());
            updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, (Object)mgrSignatoryEntity.getJobStatus());
            updateWrapper.set(SignMgrSignatoryEntity::getSignResult, (Object)mgrSignatoryEntity.getSignResult());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryId, (Object)mgrSignatoryEntity.getActualSignatoryId());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryName, (Object)mgrSignatoryEntity.getActualSignatoryName());
            updateWrapper.set(SignMgrSignatoryEntity::getActualSignatoryContact, (Object)mgrSignatoryEntity.getActualSignatoryContact());
            updateWrapper.set(SignMgrSignatoryEntity::getStartTime, (Object)mgrSignatoryEntity.getStartTime());
            updateWrapper.set(SignMgrSignatoryEntity::getEndTime, (Object)mgrSignatoryEntity.getEndTime());
            this.signMgrSignatoryService.update((Wrapper)updateWrapper);
            SignMgrSignatoryEntity sms = (SignMgrSignatoryEntity)((Object)this.signMgrSignatoryService.selectById(mgrSignatoryEntity.getId()));
            SignMgrLogEntity sml = (SignMgrLogEntity)((Object)BeanMapper.map((Object)((Object)sms), SignMgrLogEntity.class));
            sml.setBillId(signMgrEntity.getBillId());
            sml.setBillType(signMgrEntity.getBillType());
            sml.setBillDocId(signMgrEntity.getBillDocId());
            sml.setBillDocumentName(signMgrEntity.getBillDocumentName());
            sml.setBillDocumentType(signMgrEntity.getBillDocumentType());
            sml.setSignRequirements(signMgrEntity.getSignRequirements());
            sml.setCreatorName(signMgrEntity.getCreatorName());
            sml.setContact(signMgrEntity.getCreatorContact());
            sml.setThirdSysCallbackContractId(Long.valueOf(map.get("contractId")));
            sml.setThirdSysCallbackTenantId(map.get("tenantId"));
            sml.setThirdSysCallbackSignatorySerialNo(map.get("signatorySerialNo"));
            sml.setThirdSysCallbackTenantName(map.get("tenantName"));
            sml.setThirdSysCallbackSn(map.get("sn"));
            sml.setThirdSysCallbackStatus(map.get("status"));
            sml.setThirdSysCallbackType(map.get("type"));
            sml.setThirdSysCallbackContact(map.get("contact"));
            sml.setThirdSysCallbackOperatorName(map.get("operatorName"));
            sml.setThirdSysCallbackOperatorMobile(map.get("operatorMobile"));
            sml.setThirdSysCallbackOperatorNumber(map.get("operatorNumber"));
            sml.setThirdSysCallbackReceiverNumber(map.get("receiverNumber"));
            sml.setThirdSysCallbackSerialNo(map.get("serialNo"));
            sml.setThirdSysCallbackActionName(map.get("actionName"));
            sml.setThirdSysCallbackActionNo(map.get("actionNo"));
            this.signMgrLogService.saveOrUpdate((Object)sml, false);
        }
        Integer maxSignOrder = ((SignMgrSignatoryEntity)((Object)signMgrSignatoryEntity.get(0))).getSignOrder();
        Integer maxSealSignOrder = ((SignMgrSignatoryEntity)((Object)signMgrSignatoryEntity.get(0))).getSealSignOrder();
        result.put("maxSignOrder", maxSignOrder);
        result.put("maxSealSignOrder", maxSealSignOrder);
        return result;
    }

    public void findSignatory(SignMgrEntity signMgrEntity) {
        ArrayList results = new ArrayList();
        List<SignMgrSignatoryEntity> sms = signMgrEntity.getSignMgrSignatoryEntities();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (SignMgrSignatoryEntity sm : sms) {
            if (!Objects.equals(sm.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())) continue;
            list.add(sm.getJobStatus());
        }
        if (list.size() == sms.size()) {
            sms.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = sms.get(0);
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();
            List ss = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            results.addAll(ss);
            for (SignMgrSignatoryEntity s : ss) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)s.getId());
                updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, (Object)s.getJobStatus());
                this.signMgrSignatoryService.update((Wrapper)updateWrapper);
            }
        } else {
            List s = sms.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (!s.isEmpty()) {
                s.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)s.get(0));
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();
                List f = sms.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                results.addAll(f);
            }
        }
    }

    @Override
    public List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder) {
        ArrayList<SignMgrSignatoryEntity> operators;
        block4: {
            List actionList;
            block3: {
                operators = new ArrayList<SignMgrSignatoryEntity>();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
                SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.getOne((Wrapper)queryWrapper));
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
                actionList = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
                if (actionList.size() == 0) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7b7e\u7f72\u52a8\u4f5c\u4efb\u52a1\u6570\u636e\uff01");
                }
                if (maxSignOrder > 0 || maxSealSignOrder > 0) break block3;
                actionList.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)actionList.get(0));
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();
                List opts = actionList.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                operators.addAll(opts);
                for (SignMgrSignatoryEntity s : opts) {
                    s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                    this.signMgrSignatoryService.updateById((Object)s);
                }
                break block4;
            }
            List opts = actionList.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (opts.isEmpty()) break block4;
            opts.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)opts.get(0));
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();
            List acts = opts.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            operators.addAll(acts);
            for (SignMgrSignatoryEntity act : acts) {
                act.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                this.signMgrSignatoryService.updateById((Object)act);
            }
        }
        return operators;
    }

    private void extracted(SignMgrEntity signMgrEntity, SignMgrSignatoryEntity min) {
        if (Objects.equals(min.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            int status = 3;
            this.sendStatus(signMgrEntity.getBillType(), signMgrEntity.getBillId(), signMgrEntity.getBillRefCode(), status);
        } else {
            int status = 2;
            this.sendStatus(signMgrEntity.getBillType(), signMgrEntity.getBillId(), signMgrEntity.getBillRefCode(), status);
        }
    }

    @Override
    public void sendStatus(String billType, Long billId, String refcode, int status) {
        CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            this.logger.error("\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u5931\u8d25,\u6839\u636ebillType-{}\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a{}\uff01", (Object)billType, (Object)mdRefResp.getMsg());
        }
        MdReferVO mdRef = (MdReferVO)mdRefResp.getData();
        String url = this.BASE_HOST + mdRef.getProjectName() + "/signature/changeStatus";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billId", billId);
        param.put("refCode", refcode);
        param.put("status", status);
        try {
            JSONObject resultJson;
            String code;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(param), headerMap, (Integer)10000, (Integer)10000);
            this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u7b7e\u7ae0\u72b6\u6001\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString(param), httpRespStr});
            if (!StringUtils.isEmpty((CharSequence)httpRespStr) && Integer.parseInt(code = (resultJson = JSONObject.parseObject((String)httpRespStr)).getString("code")) != 0) {
                this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff0c\u8fd4\u56de\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u7b7e\u7ae0\u72b6\u6001\u5f02\u5e38\uff1a", new Object[]{url, JSONObject.toJSONString(param), e});
        }
    }

    @Override
    public CommonResponse<String> sendMessage(Long contractId, List<SignMgrSignatoryEntity> operators) {
        String content;
        String[] receivers;
        String[] channel;
        ArrayList<String> lst;
        PushMsgParameter parameter = new PushMsgParameter();
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            lst = new ArrayList<String>();
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);
            receivers = (String[])operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            content = "PERSONAL".equals(operators.get(0).getSignActionType()) ? "\u60a8\u6709\u4e00\u4e2a\u79c1\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c:<a href=\"" + this.BASE_HOST + "ejc-contractbase-frontend/#/privateSign?contractId=" + contractId + "&tenantType=" + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=" + operators.get(0).getSignatureContact() + "\">\u70b9\u6211\u7b7e\u7f72</a>" : "\u60a8\u6709\u4e00\u4e2a\u79c1\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c:<a href=\"" + this.BASE_HOST + "ejc-contractbase-frontend/#/privateSign?contractId=" + contractId + "&tenantType=" + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=\">\u70b9\u6211\u7b7e\u7f72</a>";
        } else {
            lst = new ArrayList();
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);
            this.logger.info("\u751f\u6210\u516c\u6709\u4e91\u7b7e\u7f72\u94fe\u63a5\uff0c\u901a\u77e5\u4e59\u65b9\u7b7e\u7f72\uff01");
            receivers = "342625728913997831".split(",");
            this.logger.info("\u63a5\u6536\u901a\u77e5\u7684\u4eba\uff1a{}", (Object)JSONObject.toJSONString((Object)receivers));
            content = "\u60a8\u6709\u4e00\u4e2a\u516c\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c\uff1a<a href=\"" + this.BASE_HOST + "ejc-contractbase-frontend/#/publicSign?contractId=" + contractId + "&contact=" + operators.get(0).getSignatureContact() + "\">\u70b9\u6211\u7b7e\u7f72</a>";
        }
        String msgType = "task";
        String subject = "\u7b7e\u7ae0\u63d0\u9192";
        CommonResponse user = this.userApi.queryListByIds(new String[]{receivers[0]});
        if (!user.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        this.logger.info("\u67e5\u8be2\u5230\u7684\u79df\u6237\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)user.getData()));
        String tenantId = String.valueOf(((UserVO)((List)user.getData()).get(0)).getTenantId());
        parameter.setChannel(channel);
        parameter.setReceivers(receivers);
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        return this.pushMessageApi.pushMessage(parameter);
    }

    @Override
    public void AllReceiverComplate(Map<String, String> map) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_bill_id", (Object)Long.valueOf(map.get("contractId")));
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.getOne((Wrapper)queryWrapper));
        List<SignMgrSignatoryEntity> sig = signMgrEntity.getSignMgrSignatoryEntities();
        String action = map.get("action");
        JSONObject jsonObject = JSONObject.parseObject((String)action);
        String actionNo = jsonObject.getString("actionNO");
        List signMgrSignatoryEntity = sig.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());
    }

    @Override
    public Long createDocument(String url, String billDocumentName, String billDocumentType) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new BusinessException("\u4e0d\u80fd\u901a\u8fc7\u4e1a\u52a1\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5730\u5740\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)billDocumentName)) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)billDocumentType)) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateDocumentRequest request = new CreateDocumentRequest();
        Long documentId = null;
        try {
            documentId = contractService.createDocumentByUrl(new DocumentCreateByUrl(url, billDocumentName, billDocumentType, null));
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u521b\u5efa\u5408\u540c\u6587\u6863\u5f02\u5e38\uff01");
        }
        this.logger.info("\u521b\u5efa\u5408\u540c\u6587\u4ef6\u6210\u529f,documentId:{}", (Object)documentId);
        return documentId;
    }

    @Override
    public void validation(InitSignatureVO param) {
        if (param.getBillId() == null) {
            throw new BusinessException("\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillType())) {
            throw new BusinessException("\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillRefCode())) {
            throw new BusinessException("refcode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getBillDocId() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillDocumentName())) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getTenantName())) {
            throw new BusinessException("\u53d1\u8d77\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getSignMgrSignatoryEntities().isEmpty()) {
            throw new BusinessException("\u7b7e\u7f72\u65b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = param.getSignMgrSignatoryEntities();
        for (InitSignatoryVO s : list) {
            if (StringUtils.isEmpty((CharSequence)s.getTenantName())) {
                throw new BusinessException("\u7b7e\u7ea6\u4e3b\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)s.getTenantType())) {
                throw new BusinessException("\u7b7e\u7ea6\u4e3b\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (s.getSignatureType() == null) {
                throw new BusinessException("\u7b7e\u7f72\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (s.getSignOrder() == null) {
                throw new BusinessException("\u7b7e\u7f72\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (s.getSignatureList().isEmpty()) {
                throw new BusinessException("\u7b7e\u7ae0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List sealList = s.getSignatureList();
            for (SealInfoVO ss : sealList) {
                if (StringUtils.isEmpty((CharSequence)ss.getSignActionType())) {
                    throw new BusinessException("\u7b7e\u7f72\u52a8\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)ss.getName())) {
                    throw new BusinessException("\u7b7e\u7f72\u52a8\u4f5c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (ss.getSealSignOrder() == null) {
                    throw new BusinessException("\u7b7e\u7ae0\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (ss.getSignatoryVOList().isEmpty()) {
                    throw new BusinessException("\u7ecf\u529e\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                List signatoryList = ss.getSignatoryVOList();
                for (SignatoryVO sss : signatoryList) {
                    if (StringUtils.isEmpty((CharSequence)sss.getSignatureName())) {
                        throw new BusinessException("\u7ecf\u529e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    if (!StringUtils.isEmpty((CharSequence)sss.getSignatureContact())) continue;
                    throw new BusinessException("\u7ecf\u529e\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
                }
            }
        }
    }

    @Override
    public Long createContract(Long documentId, InitSignatureVO initSignatureVO) {
        Long contractId;
        SignMgrVO signMgrVO = new SignMgrVO();
        List signMgrSignatoryEntities = signMgrVO.getSignMgrSignatoryEntities();
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setCategoryId(this.categoryId);
        createContractRequest.setSubject(initSignatureVO.getBillDocumentName());
        createContractRequest.setSend(Boolean.valueOf(true));
        ArrayList<Long> documents = new ArrayList<Long>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        createContractRequest.setDescription(initSignatureVO.getSignRequirements());
        createContractRequest.setCreatorName(initSignatureVO.getCreatorName());
        createContractRequest.setCreatorContact(initSignatureVO.getCreatorContact());
        createContractRequest.setTenantName(initSignatureVO.getTenantName());
        signMgrVO.setBillId(initSignatureVO.getBillId());
        signMgrVO.setBillType(initSignatureVO.getBillType());
        signMgrVO.setBillRefCode(initSignatureVO.getBillRefCode());
        signMgrVO.setSourceDocId(documentId);
        signMgrVO.setBillDocId(initSignatureVO.getBillDocId());
        signMgrVO.setBillDocumentName(initSignatureVO.getBillDocumentName());
        signMgrVO.setBillDocumentType(initSignatureVO.getBillDocumentType());
        signMgrVO.setSignRequirements(initSignatureVO.getSignRequirements());
        signMgrVO.setCreatorName(initSignatureVO.getCreatorName());
        signMgrVO.setCreatorContact(initSignatureVO.getCreatorContact());
        signMgrVO.setTenantName(initSignatureVO.getTenantName());
        List initSignatoryVOList = initSignatureVO.getSignMgrSignatoryEntities();
        initSignatoryVOList.sort(Comparator.comparing(InitSignatoryVO::getSignOrder));
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        for (InitSignatoryVO initSignatoryVO : initSignatoryVOList) {
            Signatory signatory = new Signatory();
            signatory.setTenantType(TenantType.valueOf((String)initSignatoryVO.getTenantType()));
            signatory.setTenantName(initSignatoryVO.getTenantName());
            String tenantId = String.valueOf(InvocationInfoProxy.getTenantid());
            String signatoryHead = Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) ? "T_" : "S_";
            String signatoryNo = signatoryHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId() + "_" + initSignatureVO.getBillType() + "_" + String.valueOf(IdWorker.getId());
            signatory.setSignatoryNo(signatoryNo);
            if (!Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                if (StringUtils.isEmpty((CharSequence)initSignatoryVO.getReceiverName())) {
                    throw new BusinessException("\u4e59\u65b9\u63a5\u6536\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((CharSequence)initSignatoryVO.getContact())) {
                    throw new BusinessException("\u4e59\u65b9\u63a5\u6536\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                signatory.setReceiverName(initSignatoryVO.getReceiverName());
                signatory.setContact(initSignatoryVO.getContact());
            }
            signatory.setSerialNo(initSignatoryVO.getSignOrder());
            ArrayList<Action> actions = new ArrayList<Action>();
            List signatureList = initSignatoryVO.getSignatureList();
            for (SealInfoVO sealInfoVO : signatureList) {
                SignMgrSignatoryVO signMgrSignatoryVO = new SignMgrSignatoryVO();
                Action action = new Action();
                action.setType(ActionType.valueOf((String)sealInfoVO.getSignActionType()));
                String actionHead = null;
                actionHead = Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) ? "T_" : "S_";
                String actionNo = actionHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId() + "_" + initSignatureVO.getBillType() + "_" + ActionType.valueOf((String)sealInfoVO.getSignActionType()) + "_" + String.valueOf(sealInfoVO.getSealSignOrder()) + "_" + String.valueOf(IdWorker.getId());
                action.setActionNo(actionNo);
                action.setName(sealInfoVO.getName());
                action.setSerialNo(sealInfoVO.getSealSignOrder());
                ArrayList<Operator> operators = new ArrayList<Operator>();
                List signatoryVOList = sealInfoVO.getSignatoryVOList();
                if (!StringUtils.isEmpty((CharSequence)sealInfoVO.getSourceSealId()) && !StringUtils.isEmpty((CharSequence)sealInfoVO.getSourceSealName()) && Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    Set ids = Arrays.stream(sealInfoVO.getSourceSealId().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                    Set names = Arrays.stream(sealInfoVO.getSourceSealName().split(",")).collect(Collectors.toSet());
                    action.setSealIds(ids);
                    action.setSealNames(names);
                }
                for (SignatoryVO signatoryVO : signatoryVOList) {
                    CommonResponse user;
                    if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) && signatoryVO.getSignatureId() != null && !(user = this.userApi.queryListByIds(new String[]{String.valueOf(signatoryVO.getSignatureId())})).isSuccess()) {
                        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5185\u90e8\u5355\u4f4d\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7528\u6237id\u540e\u91cd\u8bd5\uff01");
                    }
                    Operator operator = new Operator();
                    operator.setOperatorName(signatoryVO.getSignatureName());
                    operator.setOperatorContact(signatoryVO.getSignatureContact());
                    operators.add(operator);
                    signMgrSignatoryVO.setSignatureId(signatoryVO.getSignatureId());
                    signMgrSignatoryVO.setSignatureName(signatoryVO.getSignatureName());
                    signMgrSignatoryVO.setSignatureContact(signatoryVO.getSignatureContact());
                    signMgrSignatoryVO.setSignActionType(sealInfoVO.getSignActionType());
                    signMgrSignatoryVO.setName(sealInfoVO.getName());
                    signMgrSignatoryVO.setSealSignOrder(sealInfoVO.getSealSignOrder());
                    signMgrSignatoryVO.setSourceSealId(sealInfoVO.getSourceSealId());
                    signMgrSignatoryVO.setSourceSealName(sealInfoVO.getSourceSealName());
                    signMgrSignatoryVO.setSealId(sealInfoVO.getSealId());
                    signMgrSignatoryVO.setSealName(sealInfoVO.getSealName());
                    signMgrSignatoryVO.setSignatureUserIds(sealInfoVO.getSignatureUserIds());
                    signMgrSignatoryVO.setActionNo(actionNo);
                    signMgrSignatoryVO.setTenantName(initSignatoryVO.getTenantName());
                    signMgrSignatoryVO.setTenantType(initSignatoryVO.getTenantType());
                    signMgrSignatoryVO.setReceiverName(initSignatoryVO.getReceiverName());
                    signMgrSignatoryVO.setContact(initSignatoryVO.getContact());
                    signMgrSignatoryVO.setSignOrder(initSignatoryVO.getSignOrder());
                    signMgrSignatoryVO.setSignatureType(initSignatoryVO.getSignatureType());
                    signMgrSignatoryVO.setSignatoryNo(signatoryNo);
                    signMgrSignatoryVO.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
                    signMgrSignatoryEntities.add(signMgrSignatoryVO);
                }
                action.setActionOperators(operators);
                actions.add(action);
            }
            signatory.setActions(actions);
            signatories.add(signatory);
        }
        createContractRequest.setSignatories(signatories);
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e2) {
            e2.printStackTrace();
            throw new BusinessException("\u521b\u5efa\u5408\u540c\u5931\u8d25!");
        }
        signMgrVO.setSourceBillId(contractId);
        signMgrVO.setSignMgrSignatoryEntities(signMgrSignatoryEntities);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)BeanMapper.map((Object)signMgrVO, SignMgrEntity.class));
        this.saveOrUpdate((Object)signMgrEntity, false);
        this.logger.info("\u521b\u5efa\u5408\u540c\u6210\u529f,contractId:{}\uff0c\u5408\u540c\u6587\u6863id\uff1a{}\uff0c\u4e1a\u52a1id:{}\uff0c\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{contractId, documentId, signMgrEntity.getBillId(), signMgrEntity.getBillType()});
        return contractId;
    }

    @Override
    public String createCloudSignUrl(Long contractId, String contact) {
        String cloudSignUrl;
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        try {
            cloudSignUrl = contractService.cloudSignUrl(contractId, contact);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u516c\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u5931\u8d25\uff01");
        }
        this.logger.info("\u6587\u4ef6\u7b7e\u7f72\u94fe\u63a5:{}", (Object)cloudSignUrl);
        return cloudSignUrl;
    }

    @Override
    public String createPrivateSignUrl(Long contractId, String tenantType, String tenantName, String contact) {
        String privateSignUrl;
        SDKClient client = this.getSdkClient();
        SignServiceImpl signService = new SignServiceImpl(client);
        SignUrlRequest request = new SignUrlRequest();
        request.setContractId(contractId);
        request.setTenantType(TenantType.COMPANY);
        request.setTenantName(tenantName);
        if (!StringUtils.isEmpty((CharSequence)contact)) {
            request.setContact(contact);
        }
        request.setExpireTime(Integer.valueOf(259200));
        try {
            privateSignUrl = signService.signUrl(request);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u79c1\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u5931\u8d25\uff01");
        }
        return privateSignUrl;
    }
}

