/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/api/signaturemanage"})
public class SignatureManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignMgrService signMgrService;
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private ISignMgrLogService signMgrLogService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @PostMapping(value={"/initiateSignature"})
    public CommonResponse<Long> initiateSignature(@RequestBody SignMgrVO signMgrVO) {
        Long documentId = this.signMgrService.createByFile(signMgrVO);
        Long contractId = this.signMgrService.createContractByCategory(documentId, signMgrVO);
        if (contractId == null) {
            return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;
        List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u6210\u529f\uff01", (Object)contractId);
    }

    @PostMapping(value={"/sendSignature"})
    public CommonResponse<Long> initiateSignature(@RequestBody InitSignatureVO initSignatureVO) {
        String fileName;
        String url;
        this.signMgrService.validation(initSignatureVO);
        Long userId = InvocationInfoProxy.getUserid();
        CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
        this.logger.info("\u53d1\u8d77\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeResponse));
        if (employeeResponse.isSuccess()) {
            String userName = ((EmployeeVO)employeeResponse.getData()).getUserName();
            if (StringUtils.isEmpty((CharSequence)userName)) {
                throw new BusinessException("\u8bf7\u7ef4\u62a4\u53d1\u8d77\u4eba\u540d\u79f0\uff01");
            }
            String mobilePhone = ((EmployeeVO)employeeResponse.getData()).getMobilePhone();
            if (StringUtils.isEmpty((CharSequence)mobilePhone)) {
                throw new BusinessException("\u8bf7\u7ef4\u62a4\u53d1\u8d77\u4eba\u624b\u673a\u53f7\uff01");
            }
        } else {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u53d1\u8d77\u4eba\u4fe1\u606f\uff01");
        }
        initSignatureVO.setCreatorName(((EmployeeVO)employeeResponse.getData()).getUserName());
        initSignatureVO.setCreatorContact(((EmployeeVO)employeeResponse.getData()).getMobilePhone());
        String billDocumentType = null;
        CommonResponse attachmentResp = this.attachmentApi.queryDetail(String.valueOf(initSignatureVO.getBillDocId()));
        this.logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u7684\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentResp));
        if (attachmentResp.isSuccess()) {
            url = ((AttachmentVO)attachmentResp.getData()).getTruePath();
            if (StringUtils.isEmpty((CharSequence)url)) {
                throw new BusinessException("\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            fileName = ((AttachmentVO)attachmentResp.getData()).getFileName();
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                throw new BusinessException("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a\uff01");
            }
        } else {
            throw new BusinessException("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        billDocumentType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        Long documentId = this.signMgrService.createDocument(url, initSignatureVO.getBillDocumentName(), billDocumentType);
        Long contractId = this.signMgrService.createContract(documentId, initSignatureVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        String billType = signMgrEntity.getBillType();
        Long billId = signMgrEntity.getBillId();
        String billRefCode = signMgrEntity.getBillRefCode();
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;
        List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        if (operators.isEmpty()) {
            throw new BusinessException("\u627e\u4e0d\u5230\u4e0b\u4e00\u4e2a\u7b7e\u7ae0\u4eba\uff01");
        }
        this.signMgrService.sendMessage(contractId, operators);
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            int status = 3;
            this.signMgrService.sendStatus(billType, billId, billRefCode, status);
        } else {
            int status = 2;
            this.signMgrService.sendStatus(billType, billId, billRefCode, status);
        }
        return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u6210\u529f\uff01", (Object)contractId);
    }

    @PostMapping(value={"/qysCallBack/global"})
    public CommonResponse<Long> global(@RequestParam Map<String, String> map) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "CONTRACT_COMPLETE": {
                break;
            }
            case "CONTRACT_TERMINATE": {
                break;
            }
            case "CONTRACT_EXPIRED": {
                break;
            }
        }
        return CommonResponse.success((String)"\u5168\u5c40\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/qysCallBack/organizer"})
    public CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(map));
        Long contractId = Long.valueOf(map.get("contractId"));
        switch (map.get("type")) {
            case "CONTRACT_SIGN": {
                break;
            }
            case "INTERNAL_FLOW": {
                this.logger.info("================================>\u5355\u4e2a\u8282\u70b9\u56de\u8c03-START<================================");
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
                SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
                String authority = this.signMgrService.login(httpServletRequest, signMgrEntity.getTenantId());
                this.logger.info("\u83b7\u53d6\u7684\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e3a\uff1a{}", (Object)authority);
                RequestContextHolder.getRequestAttributes().setAttribute("authority", (Object)authority, 0);
                String billType = signMgrEntity.getBillType();
                Long billId = signMgrEntity.getBillId();
                String billRefCode = signMgrEntity.getBillRefCode();
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
                List actionList = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
                Map<String, Object> minMax = this.signMgrService.internalFlow(map, signMgrEntity, actionList);
                Integer maxSignOrder = (Integer)minMax.get("maxSignOrder");
                Integer maxSealSignOrder = (Integer)minMax.get("maxSealSignOrder");
                List slog = (List)minMax.get("SignMgrLogEntity");
                List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
                if (operators.isEmpty()) {
                    int status = 4;
                    String res = this.signMgrService.sendStatus(billType, billId, billRefCode, status);
                    slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                    this.signMgrLogService.updateBatchById(slog);
                } else {
                    this.logger.info("================================>\u53d1\u9001\u6d88\u606f\u901a\u77e5-START<================================");
                    this.signMgrService.sendMessage(contractId, operators);
                    this.logger.info("================================>\u53d1\u9001\u6d88\u606f\u901a\u77e5-END<================================");
                    if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                        int status = 3;
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u7532\u65b9\u7b7e\u7ae0-START<================================");
                        String res = this.signMgrService.sendStatus(billType, billId, billRefCode, status);
                        slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                        this.signMgrLogService.updateBatchById(slog);
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u7532\u65b9\u7b7e\u7ae0-END<================================");
                    } else {
                        int status = 2;
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u4e59\u65b9\u7b7e\u7ae0-START<================================");
                        String res = this.signMgrService.sendStatus(billType, billId, billRefCode, status);
                        slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                        this.signMgrLogService.updateBatchById(slog);
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u4e59\u65b9\u7b7e\u7ae0-END<================================");
                    }
                }
                this.logger.info("================================>\u5355\u4e2a\u8282\u70b9\u56de\u8c03-END<================================");
                break;
            }
            case "CONTRACT_RECALL": {
                break;
            }
        }
        return CommonResponse.success((String)"\u53d1\u8d77\u65b9\u72b6\u6001\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/qysCallBack/receiver"})
    public CommonResponse<String> receiver(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "ALLRECEIVER_SIGNATORY_COMPLATE": {
                this.signMgrService.AllReceiverComplate(map);
                break;
            }
            case "CONTRACT_SIGN": {
                break;
            }
            case "INTERNAL_FLOW": {
                break;
            }
            case "CONTRACT_REJECTED": {
                break;
            }
            case "CONTRACT_TERMINATE_REJECTED": {
                break;
            }
        }
        return CommonResponse.success((String)"\u63a5\u6536\u65b9\u72b6\u6001\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/getPrivateSignUrl"})
    public CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO) {
        String privateSignUrl = this.signMgrService.createPrivateSignUrl(privateSignUrlVO.getContractId(), privateSignUrlVO.getTenantType(), privateSignUrlVO.getTenantName(), privateSignUrlVO.getContact());
        return CommonResponse.success((String)"\u83b7\u53d6\u79c1\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u6210\u529f\uff01", (Object)privateSignUrl);
    }
}

