package com.ejianc.business.signaturemanage.controller.api;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import net.qiyuesuo.sdk.bean.contract.ContractDownloadRequest;
import net.qiyuesuo.sdk.common.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 签章管理API控制器
 *
 * @author baipengyan
 * @Description: 签章管理API控制器
 */
@RestController
@RequestMapping(value = "/api/signaturemanage")
public class SignatureManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISignMgrService signMgrService;

    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;

    @Autowired
    private ISignMgrLogService signMgrLogService;

    @Autowired
    private IEmployeeApi employeeApi;// 获取用户信息

    @Autowired
    private IAttachmentApi attachmentApi; // 文件信息

    @Value("${ejc.fileServerUrl}")
    private String FILE_HOST; // 文件中心域名


    /**
     * 发起签章
     *
     * @param signMgrVO
     * @return
     */
    @PostMapping(value = "/initiateSignature")
    public CommonResponse<Long> initiateSignature(@RequestBody SignMgrVO signMgrVO) {
        Long documentId = signMgrService.createByFile(signMgrVO);
        Long contractId = signMgrService.createContractByCategory(documentId, signMgrVO);

        // Long contractId = 2903200045497917462L;
        if (contractId == null) {
            return CommonResponse.success("发起签章，操作失败！");
        }
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;

        List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        // CommonResponse<String> result = signMgrService.sendMessage(operators);
        return CommonResponse.success("发起签章，操作成功！", contractId);
    }


    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @PostMapping(value = "/sendSignature")
    public CommonResponse<Long> initiateSignature(@RequestBody InitSignatureVO initSignatureVO) {
        signMgrService.validation(initSignatureVO);

        // 校验是否重发合同


        // 先获取发起人名称和手机号
        Long userId = InvocationInfoProxy.getUserid();
        CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
        logger.info("发起人信息：{}", JSONObject.toJSONString(employeeResponse));
        if (employeeResponse.isSuccess()) {
            String userName = employeeResponse.getData().getUserName();
            if (StringUtils.isEmpty(userName)) {
                throw new BusinessException("请维护发起人名称！");
            }
            String mobilePhone = employeeResponse.getData().getMobilePhone();
            if (StringUtils.isEmpty(mobilePhone)) {
                throw new BusinessException("请维护发起人手机号！");
            }
            initSignatureVO.setCreatorName(employeeResponse.getData().getUserName());
            initSignatureVO.setCreatorContact(employeeResponse.getData().getMobilePhone());
        } else {
            throw new BusinessException("未获取到发起人信息！");
        }

        // 获取文件地址
        String fileName;
        String billDocumentType = null;
        String url;
        CommonResponse<AttachmentVO> attachmentResp = attachmentApi.queryDetail(String.valueOf(initSignatureVO.getBillDocId()));
        logger.info("调用第三方接口返回的文件信息：{}", JSONObject.toJSONString(attachmentResp));
        if (attachmentResp.isSuccess()) {
            // url = attachmentResp.getData().getTruePath();
            url = FILE_HOST + attachmentResp.getData().getFilePath();
            if (StringUtils.isEmpty(url)) {
                throw new BusinessException("文件地址为空！");
            }
            fileName = attachmentResp.getData().getFileName();
            if (StringUtils.isEmpty(fileName)) {
                throw new BusinessException("文件名称为空！");
            }
            billDocumentType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        } else {
            throw new BusinessException("获取文件信息异常！");
        }

        Long documentId = signMgrService.createDocument(url, initSignatureVO.getBillDocumentName(), billDocumentType);
        Long contractId = signMgrService.createContract(documentId, initSignatureVO);

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_bill_id", contractId);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        String billType = signMgrEntity.getBillType();
        Long billId = signMgrEntity.getBillId();
        String billRefCode = signMgrEntity.getBillRefCode();

        // Long contractId = 2903200045497917462L;
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;

        // 找到下一个签章人
        List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);

        int status;
        if (operators.isEmpty()) {
            throw new BusinessException("找不到下一个签章人！");
        } else {
            // 发送消息通知
            signMgrService.sendMessage(contractId, operators);
            if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                status = 3;
                // 待甲方签章
                signMgrService.sendStatus(billType, billId, billRefCode, status);
            } else {
                status = 2;
                // 待乙方签章
                signMgrService.sendStatus(billType, billId, billRefCode, status);
            }
        }
        return CommonResponse.success("发起签章，操作成功！", contractId);
    }


    /**
     * 契约锁，全局状态回调
     *
     * @param map
     * @return
     */
    @PostMapping(value = "/qysCallBack/global")
    public CommonResponse<Long> global(@RequestParam Map<String, String> map/*, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse*/) {

        logger.info("回调入参map为：{}", map);

        switch (map.get("type")) {
            case "CONTRACT_COMPLETE":
                // 文件全部签署完成

                break;
            case "CONTRACT_TERMINATE":
                // 文件作废

                break;
            case "CONTRACT_EXPIRED":
                // 文件过期

                break;
            default:
                break;
        }

        return CommonResponse.success("全局，回调成功！");
    }


    // private String getParamFromAuthority(String authority, String key) {
    //     authority.substring(authority.indexOf("key"))
    // }

    /**
     * 契约锁，发起方状态回调
     *
     * @param map
     * @return
     */
    @PostMapping(value = "/qysCallBack/organizer")
    public CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        logger.info("回调入参map为：{}", JSONObject.toJSONString(map));

        Long contractId = Long.valueOf(map.get("contractId"));
        int status;

        switch (map.get("type")) {
            case "CONTRACT_SIGN":
                // 文件签署-签署方签署

                break;
            case "INTERNAL_FLOW":
                // 每个节点签署完成
                logger.info("================================>单个节点回调-START<================================");
                QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("source_bill_id", contractId);
                SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

                // 获取上下文
                String authority = signMgrService.login(httpServletRequest, signMgrEntity.getTenantId());

                InvocationInfoProxy.setTenantid(signMgrEntity.getTenantId());
                String key = "userCode";
                int idx = authority.indexOf(";"+key+"=");
                if(idx >= 0) {
                    String tmp = authority.substring(idx+1);
                    InvocationInfoProxy.setUsercode(tmp.substring(0,tmp.indexOf(";")).replace(key+"=", ""));
                }

                logger.info("获取的上下文信息为：{}", authority);
                RequestContextHolder.getRequestAttributes().setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);

                String billType = signMgrEntity.getBillType();
                Long billId = signMgrEntity.getBillId();
                String billRefCode = signMgrEntity.getBillRefCode();

                QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("pid", signMgrEntity.getId());
                List<SignMgrSignatoryEntity> actionList = signMgrSignatoryService.list(queryWrapper1);


                Map<String, Object> minMax = signMgrService.internalFlow(map, signMgrEntity, actionList);
                Integer maxSignOrder = (Integer) minMax.get("maxSignOrder");
                Integer maxSealSignOrder = (Integer) minMax.get("maxSealSignOrder");

                List<SignMgrLogEntity> slog = (List<SignMgrLogEntity>) minMax.get("SignMgrLogEntity");
                List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);

                // 通知业务系统结果
                String res;
                if (operators.isEmpty()) {
                    // 全都签章完成
                    // 无待激活状态，判定全部完成,（不做操作的话等全局回调合同完成）这里可以把合同状态通知给业务系统
                    status = 4;
                    res = signMgrService.sendStatus(billType, billId, billRefCode, status);
                    // slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                    // signMgrLogService.updateBatchById(slog);
                } else {
                    // 发送消息通知
                    logger.info("================================>发送消息通知-START<================================");
                    signMgrService.sendMessage(contractId, operators);
                    logger.info("================================>发送消息通知-END<================================");
                    if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                        status = 3;
                        // 待甲方签章
                        logger.info("================================>业务系统更新状态-待甲方签章-START<================================");
                        res = signMgrService.sendStatus(billType, billId, billRefCode, status);
                        // slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                        // signMgrLogService.updateBatchById(slog);
                        logger.info("================================>业务系统更新状态-待甲方签章-END<================================");
                    } else {
                        status = 2;
                        // 待乙方签章
                        logger.info("================================>业务系统更新状态-待乙方签章-START<================================");
                        res = signMgrService.sendStatus(billType, billId, billRefCode, status);
                        // slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                        // signMgrLogService.updateBatchById(slog);
                        logger.info("================================>业务系统更新状态-待乙方签章-END<================================");
                    }
                }

                slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                signMgrLogService.updateBatchById(slog);

                // 异步任务-文件下载和上传
                signMgrService.fileTask(contractId, status, signMgrEntity, authority, billType, billId);

                logger.info("================================>单个节点回调-END<================================");
                break;
            case "CONTRACT_RECALL":
                // 文件撤回-发起方撤回

                break;
            default:
                break;
        }

        return CommonResponse.success("发起方状态，回调成功！");
    }


    /**
     * 契约锁，接收方状态回调
     *
     * @param map
     * @param httpServletRequest
     * @param httpServletResponse
     * @return
     */
    @PostMapping(value = "/qysCallBack/receiver")
    public CommonResponse<String> receiver(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {

        logger.info("回调入参map为：{}", map);

        switch (map.get("type")) {
            case "ALLRECEIVER_SIGNATORY_COMPLATE":
                // 所有接收方签署完成
                signMgrService.AllReceiverComplate(map);
                break;
            case "CONTRACT_SIGN":
                // 文件签署-签署方签署

                break;
            case "INTERNAL_FLOW":
                // 每个节点签署完成
                // signMgrService.internalFlow(map);
                break;
            case "CONTRACT_REJECTED":
                // 文件退回-签署方拒绝

                break;
            case "CONTRACT_TERMINATE_REJECTED":
                // 文件作废拒绝

                break;
            default:
                break;
        }

        return CommonResponse.success("接收方状态，回调成功！");
    }


    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO
     * @return privateSignUrl
     */
    @PostMapping(value = "/getPrivateSignUrl")
    public CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO) {
        String privateSignUrl = signMgrService.createPrivateSignUrl(privateSignUrlVO.getContractId(), privateSignUrlVO.getTenantType(), privateSignUrlVO.getTenantName(), privateSignUrlVO.getContact());
        return CommonResponse.success("获取私有云合同签署短链接，成功！", privateSignUrl);
    }


    @GetMapping(value = "/downloadHasSignedFile")
    public void downloadHasSignedFile(@RequestParam(value = "billId") Long billId, HttpServletResponse response) {

        if (billId == null) {
            throw new BusinessException("请检查业务id是否为空！");
        }

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_id", billId);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        if (signMgrEntity == null) {
            throw new BusinessException("查询不到对应数据，请检查重试！");
        }

        Long contractId = signMgrEntity.getSourceBillId();

        OutputStream out = null;
        String fileName = String.format("%s_%d", signMgrEntity.getBillDocumentName(), billId);
        File file = null;
        try {
            file = File.createTempFile(fileName, ".pdf");
            out = new FileOutputStream(file);
        } catch (Exception e) {
            logger.error("下载签章文件，失败！原因是：", e);
            throw new BusinessException("下载签章文件，失败！");
        }

        if (!file.isFile() || !file.exists()) {
            throw new BusinessException("初始化临时文件不存在！");
        }

        signMgrService.downloadHasSignedFile(contractId, out);
        logger.info("下载合同完成,业务ID为：{},契约锁合同ID为：{}", billId, contractId);

        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream)) {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(response.getOutputStream());
                int length = 0;
                byte[] temp = new byte[1024 * 10];
                while ((length = bufferedInputStream.read(temp)) != -1) {
                    bufferedOutputStream.write(temp, 0, length);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                logger.info("下载签章文件成功，文件名称：{}", file.getName());
            }
            inputStream.close();
        } catch (IOException e) {
            logger.error("下载签章文件，失败！原因是：", e);
            throw new BusinessException("下载签章文件，失败！");
        } finally {
            // 成功后才删除签章文件
            file.delete();
            logger.info("删除签章文件：{},成功！", file.getName());
        }
    }

    @GetMapping(value = "/previewContract")
    public CommonResponse<List<SignMgrPreviewVO>> previewContract(@RequestParam(value = "billId") Long billId, @RequestParam(value = "sourceTypes") List<String> sourceTypes) {
        if (billId == null || sourceTypes.isEmpty()) {
            throw new BusinessException("请检查参数重试！");
        }
        logger.info("合同ID为--{},状态--{}",billId,JSONObject.toJSONString(sourceTypes));
        List<SignMgrPreviewEntity> signMgrPreviewEntityList = signMgrService.previewContract(billId,sourceTypes);
        if (signMgrPreviewEntityList == null) {
            throw new BusinessException("查询不到相关记录，请检查参数后重试！");
        }
        List<SignMgrPreviewVO> signMgrPreviewVOS = BeanMapper.mapList(signMgrPreviewEntityList, SignMgrPreviewVO.class);
        return CommonResponse.success("请求成功",signMgrPreviewVOS);
    }
}
