package com.ejianc.business.signaturemanage.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.utils.TaskPoolConfig;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.framework.core.response.CommonResponse;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealPermissionGroupBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 印章管理API控制器
 *
 * @author baipengyan
 * @Description: 印章管理API控制器
 */
@RestController
@RequestMapping(value = "/api/sealManager")
public class SealManageApi {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    ISealManageService sealManageService;

    @Autowired
    TaskPoolConfig taskPoolConfig;

    /**
     * 查询公司下的印章列表
     *
     * @param
     * @return
     */
    @PostMapping(value = "/querySealsByCompanyName")
    public CommonResponse<List<ManagementVO>> querySealsByCompanyName(@RequestParam(value = "companyName") String companyName) {

        /* String authority = request.getHeader("request");

        logger.info("查询公司下的印章列表,请求的上下文为：{}", authority); */

        List<ManagementVO> list = new ArrayList<>();
        List<Seal> sealList = sealManageService.sealList(null, companyName, null);

        logger.info("请求的印章列表:{}", JSONObject.toJSONString(sealList));

        /* List<CompletableFuture<String>> futures = new ArrayList<>(); */

        if (sealList != null) {
            for (Seal seal : sealList) {
                Seal s = sealManageService.detail(seal.getId());

                ManagementVO managementVO = new ManagementVO();
                // 印章ID（第三方返回）@
                managementVO.setSourceSealId(s.getId());
                // 印章名称（第三方返回）@
                managementVO.setSourceSealName(s.getName());
                // 印章分类，PHYSICS(物理章),ELECTRONIC(电子章)@
                managementVO.setSealCategory(String.valueOf(seal.getCategory()));
                // 印章图片KEY@
                managementVO.setSourceKey(s.getSealKey());
                // 图片地址@
                /* CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> sealManageService.getImgUrl(s.getId(), authority)).thenApplyAsync(img -> {
                    managementVO.setImgUrl(img);
                    return null;
                });
                futures.add(future); */

                // 第三方返回的印章状态名称@
                JSONObject jsonObject = JSONObject.parseObject(s.getStatus());

                switch (jsonObject.getString("key")) {
                    case "NORMAL":
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    case "FREEZE":
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    case "DELETE":
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    case "INVALID":
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        break;
                    default:
                        throw new IllegalStateException("Unexpected value: " + jsonObject.getString("key"));
                }
                // 第三方返回的印章状态，NORMAL("正 常"),FREEZE("冻结"),DELETE("删 除"),INVALID("失效")@
                managementVO.setSourceStatus(jsonObject.getString("key"));
                // 签章类型，COMPANY("企业公章"),LP("法定代表人章")@
                managementVO.setSealType(String.valueOf(s.getType()));
                // 公司ID,第三方@
                managementVO.setSourceCompanyId(seal.getOwner());
                // 所属公司名称 第三方@
                managementVO.setSourceCompanyName(seal.getOwnerName());
                // 印章类型（类别）子类别@
                // managementVO.setSealSubType("");
                // 印章类型名称子类别@
                managementVO.setSealSubTypeName(s.getSealCategoryName());


                // 用户id（第三方系统返回的）@
                // 用户名称 （第三方系统返回的）@
                // 手机号
                // 邮箱
                // 用户类型 user- 使用者 manger-管理员
                List<SealPermissionGroupBean> sealAdminGroup = s.getSealAdminGroup();
                List<SealPermissionGroupBean> sealUseGroup = s.getSealUseGroup();
                List<ManagementUserVO> managementUsers = new ArrayList<>();
                List<ManagementUserVO> sa = sealManageService.getUsers(sealAdminGroup, true);
                if (sa != null) {
                    managementUsers.addAll(sa);
                }
                List<ManagementUserVO> su = sealManageService.getUsers(sealUseGroup, false);
                if (su != null) {
                    managementUsers.addAll(su);
                }
                managementVO.setUserEntityList(managementUsers);
                list.add(managementVO);
            }


            /* CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));

            try {
                allOf.get();
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (ExecutionException e) {
                e.printStackTrace();
            } */
        }
        logger.info("返回的印章数据：{}", JSONObject.toJSONString(list));
        return CommonResponse.success("获取印章列表，操作成功！", list);
    }


    /**
     * 查询所有内部企业的印章列表
     *
     * @return
     */
    @PostMapping(value = "/queryAllSeal")
    public CommonResponse<List<ManagementVO>> queryAllSeal() {
        /* String authority = request.getHeader("authority");

        logger.info("查询公司下的印章列表,请求的上下文为：{}", authority); */

        List<ManagementVO> data = new ArrayList<>();
        List<Company> companyList = sealManageService.companySealList();

        /* List<Future<String>> futures = new ArrayList<>(); */

        if (companyList != null) {
            for (Company company : companyList) {
                for (Seal seal : company.getSeals()) {
                    Seal s = sealManageService.detail(seal.getId());

                    ManagementVO managementVO = new ManagementVO();
                    // 印章ID（第三方返回）@
                    managementVO.setSourceSealId(s.getId());
                    // 印章名称（第三方返回）@
                    managementVO.setSourceSealName(s.getName());
                    // 签章类型，COMPANY("企业公章"),LP("法定代表人章")@
                    managementVO.setSealType(String.valueOf(s.getType()));
                    // 印章图片KEY@
                    managementVO.setSourceKey(s.getSealKey());
                    // 图片地址@
                    /* CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> sealManageService.getImgUrl(s.getId(), authority)).thenApplyAsync(img -> {
                        managementVO.setImgUrl(img);
                        return null;
                    });
                    futures.add(future); */

                    // 第三方返回的印章状态名称@
                    JSONObject jsonObject = JSONObject.parseObject(s.getStatus());

                    switch (jsonObject.getString("key")) {
                        case "NORMAL":
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        case "FREEZE":
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        case "DELETE":
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        case "INVALID":
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                            break;
                        default:
                            throw new IllegalStateException("Unexpected value: " + jsonObject.getString("key"));
                    }
                    // 第三方返回的印章状态，NORMAL("正 常"),FREEZE("冻结"),DELETE("删 除"),INVALID("失效")@
                    managementVO.setSourceStatus(jsonObject.getString("key"));
                    // 印章分类，PHYSICS(物理章),ELECTRONIC(电子章)@
                    managementVO.setSealCategory(String.valueOf(seal.getCategory()));
                    // 公司ID,第三方@
                    managementVO.setSourceCompanyId(seal.getOwner());
                    // 所属公司名称 第三方@
                    managementVO.setSourceCompanyName(seal.getOwnerName());
                    // 印章类型（类别）子类别@
                    // managementVO.setSealSubType("");
                    // 印章类型名称子类别@
                    managementVO.setSealSubTypeName(s.getSealCategoryName());


                    // 用户id（第三方系统返回的）@
                    // 用户名称 （第三方系统返回的）@
                    // 手机号
                    // 邮箱
                    // 用户类型 user- 使用者 manger-管理员
                    List<SealPermissionGroupBean> sealAdminGroup = s.getSealAdminGroup();
                    List<SealPermissionGroupBean> sealUseGroup = s.getSealUseGroup();
                    List<ManagementUserVO> managementUsers = new ArrayList<>();
                    List<ManagementUserVO> sa = sealManageService.getUsers(sealAdminGroup, true);
                    if (sa != null) {
                        managementUsers.addAll(sa);
                    }
                    List<ManagementUserVO> su = sealManageService.getUsers(sealUseGroup, false);
                    if (su != null) {
                        managementUsers.addAll(su);
                    }
                    managementVO.setUserEntityList(managementUsers);
                    data.add(managementVO);
                }

            }

            /* CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));

            try {
                allOf.get();
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (ExecutionException e) {
                e.printStackTrace();
            } */
        }

        return CommonResponse.success("获取所有内部企业的印章列表，操作成功！", data);
    }

}
