/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.enums.UserTypeEnum;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.utils.uploadFileCenter;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealCategory;
import net.qiyuesuo.sdk.bean.seal.SealCondition;
import net.qiyuesuo.sdk.bean.seal.SealPermissionGroupBean;
import net.qiyuesuo.sdk.bean.user.User;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.SealServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sealManageService")
public class SealManageServiceImpl
implements ISealManageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private uploadFileCenter uploadFileCenter;

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    @Override
    public List<Seal> sealList(Long companyId, String companyName, String category) {
        if (StringUtils.isBlank((CharSequence)companyName)) {
            throw new BusinessException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        List list = null;
        this.logger.info("\u6839\u636e\u516c\u53f8\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u5165\u53c2\uff1a{}", (Object)companyName);
        try {
            list = sealService.sealList(companyId, companyName, category);
        }
        catch (PrivateAppException e) {
            this.logger.error("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        return list;
    }

    @Override
    public Seal detail(Long sealId) {
        if (sealId == null) {
            throw new BusinessException("\u5370\u7ae0ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        Seal seal = null;
        try {
            seal = sealService.detail(sealId);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        return seal;
    }

    @Override
    public String getImgUrl(Long sealId, String authority) {
        File file;
        if (sealId == null) {
            throw new BusinessException("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\uff0c\u8bf7\u6c42\u7684\u5370\u7ae0id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\uff0c\u8bf7\u6c42\u7684\u5370\u7ae0ID-{}", (Object)sealId);
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        try {
            file = File.createTempFile(String.valueOf(sealId), ".png");
            FileOutputStream outputStream = new FileOutputStream(file);
            Seal request = new Seal();
            request.setId(sealId);
            try {
                sealService.image(request, (OutputStream)outputStream);
            }
            catch (PrivateAppException e) {
                this.logger.error("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\u5931\u8d25\uff01", (Throwable)e);
                throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\u5931\u8d25\uff01");
        }
        CommonResponse<List<AttachmentVO>> uploadResp = this.uploadFileCenter.uploadFile(file, authority, "seal", sealId, "BT211123000000005", "true", this.BASE_HOST);
        AttachmentVO attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)uploadResp.getData()).get(0)), AttachmentVO.class);
        String imgUrl = attachmentVO.getOnlinePath();
        file.delete();
        return imgUrl;
    }

    @Override
    public List<ManagementUserVO> getUsers(List<SealPermissionGroupBean> sealGroup, Boolean isAdmin) {
        ArrayList<ManagementUserVO> userList = new ArrayList<ManagementUserVO>();
        if (sealGroup != null) {
            for (SealPermissionGroupBean s : sealGroup) {
                ManagementUserVO m = new ManagementUserVO();
                m.setSourceUserId(s.getId());
                m.setSourceUserName(s.getName());
                List users = s.getUsers();
                for (User user : users) {
                    m.setSourcePhone(user.getMobile());
                    m.setSourceEmail(user.getEmail());
                }
                if (isAdmin.booleanValue()) {
                    m.setUserType(UserTypeEnum.MANGER.getTypeName());
                } else {
                    m.setUserType(UserTypeEnum.USER.getTypeName());
                }
                userList.add(m);
            }
        }
        return userList;
    }

    @Override
    public List<Company> companySealList() {
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        List companyList = null;
        SealCondition sealCondition = new SealCondition();
        sealCondition.setCategory(SealCategory.ELECTRONIC);
        sealCondition.setSealQueryStatus("NORMAL");
        try {
            companyList = sealService.innercompanySealList(sealCondition);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        return companyList;
    }
}

