/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.SignMgrMapper;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrPreviewService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.InitSignatoryVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.SealInfoVO;
import com.ejianc.business.signaturemanage.vo.SignMgrSignatoryVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.business.signaturemanage.vo.SignatoryVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.Action;
import net.qiyuesuo.sdk.bean.contract.ActionType;
import net.qiyuesuo.sdk.bean.contract.ContractDownloadRequest;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Operator;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.employee.UserSearchRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.bean.user.UserDetail;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import net.qiyuesuo.sdk.impl.EmployeeServiceImpl;
import net.qiyuesuo.sdk.impl.SignServiceImpl;
import net.qiyuesuo.v2sdk.utils.JSONUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="signMgrService")
public class SignMgrServiceImpl
extends BaseServiceImpl<SignMgrMapper, SignMgrEntity>
implements ISignMgrService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISignMgrPreviewService signMgrPreviewService;
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private ISignMgrLogService signMgrLogService;
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SignMgrMapper signMgrMapper;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${qiyuesuo.callback.url}")
    private String CALL_BACK_URL;

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    @Override
    public Map<String, Object> internalFlow(Map<String, String> map, SignMgrEntity signMgrEntity, List<SignMgrSignatoryEntity> actionList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String action = map.get("action");
        JSONObject jsonObject = JSONObject.parseObject((String)action);
        String actionNo = jsonObject.getString("actionNo");
        List signMgrSignatoryEntity = actionList.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());
        ArrayList<SignMgrLogEntity> slog = new ArrayList<SignMgrLogEntity>();
        for (SignMgrSignatoryEntity mgrSignatoryEntity : signMgrSignatoryEntity) {
            mgrSignatoryEntity.setJobStatus(SignMgrSignatoryEnum.COMPLETED.getValue());
            switch (jsonObject.getString("status")) {
                case "SIGNED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.SIGNED.getValue());
                    break;
                }
                case "REJECTED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.RETURNED.getValue());
                    break;
                }
                case "DISCARDED": {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.WITHDRAWN.getValue());
                }
                default: {
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.OTHER.getValue());
                }
            }
            mgrSignatoryEntity.setActualSignatoryName(map.get("operatorName"));
            mgrSignatoryEntity.setActualSignatoryContact(map.get("operatorMobile"));
            if (mgrSignatoryEntity.getSignatureId() != null) {
                CommonResponse user = this.userApi.queryListByIds(new String[]{String.valueOf(mgrSignatoryEntity.getSignatureId())});
                if (user.isSuccess()) {
                    mgrSignatoryEntity.setActualSignatoryId(((UserVO)((List)user.getData()).get(0)).getId());
                } else {
                    mgrSignatoryEntity.setActualSignatoryId(null);
                }
            } else {
                mgrSignatoryEntity.setActualSignatoryId(null);
            }
            try {
                mgrSignatoryEntity.setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("createTime")));
                mgrSignatoryEntity.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("completeTime")));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            slog.add(this.getSignMgrLogEntity(map, signMgrEntity, mgrSignatoryEntity));
        }
        this.signMgrSignatoryService.updateBatchById(signMgrSignatoryEntity);
        this.signMgrLogService.saveOrUpdateBatch(slog);
        Integer maxSignOrder = ((SignMgrSignatoryEntity)((Object)signMgrSignatoryEntity.get(0))).getSignOrder();
        Integer maxSealSignOrder = ((SignMgrSignatoryEntity)((Object)signMgrSignatoryEntity.get(0))).getSealSignOrder();
        result.put("maxSignOrder", maxSignOrder);
        result.put("maxSealSignOrder", maxSealSignOrder);
        result.put("SignMgrLogEntity", slog);
        return result;
    }

    private SignMgrLogEntity getSignMgrLogEntity(Map<String, String> map, SignMgrEntity signMgrEntity, SignMgrSignatoryEntity mgrSignatoryEntity) {
        SignMgrLogEntity sml = (SignMgrLogEntity)((Object)BeanMapper.map((Object)((Object)mgrSignatoryEntity), SignMgrLogEntity.class));
        sml.setBillId(signMgrEntity.getBillId());
        sml.setBillType(signMgrEntity.getBillType());
        sml.setBillCode(signMgrEntity.getBillCode());
        sml.setContractName(signMgrEntity.getContractName());
        sml.setBillDocId(signMgrEntity.getBillDocId());
        sml.setBillDocumentName(signMgrEntity.getBillDocumentName());
        sml.setBillDocumentType(signMgrEntity.getBillDocumentType());
        sml.setSignRequirements(signMgrEntity.getSignRequirements());
        sml.setCreatorName(signMgrEntity.getCreatorName());
        sml.setContact(signMgrEntity.getCreatorContact());
        sml.setThirdSysCallbackContractId(Long.valueOf(map.get("contractId")));
        sml.setThirdSysCallbackTenantId(map.get("tenantId"));
        sml.setThirdSysCallbackSignatorySerialNo(map.get("signatorySerialNo"));
        sml.setThirdSysCallbackTenantName(map.get("tenantName"));
        sml.setThirdSysCallbackSn(map.get("sn"));
        sml.setThirdSysCallbackStatus(map.get("status"));
        sml.setThirdSysCallbackType(map.get("type"));
        sml.setThirdSysCallbackContact(map.get("contact"));
        sml.setThirdSysCallbackOperatorName(map.get("operatorName"));
        sml.setThirdSysCallbackOperatorMobile(map.get("operatorMobile"));
        sml.setThirdSysCallbackOperatorNumber(map.get("operatorNumber"));
        sml.setThirdSysCallbackReceiverNumber(map.get("receiverNumber"));
        sml.setThirdSysCallbackSerialNo(map.get("serialNo"));
        sml.setThirdSysCallbackActionName(map.get("actionName"));
        sml.setThirdSysCallbackActionNo(map.get("actionNo"));
        return sml;
    }

    @Override
    public List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder) {
        ArrayList<SignMgrSignatoryEntity> operators;
        block4: {
            List actionList;
            block3: {
                operators = new ArrayList<SignMgrSignatoryEntity>();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
                SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.getOne((Wrapper)queryWrapper));
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
                actionList = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
                if (actionList.size() == 0) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7b7e\u7f72\u52a8\u4f5c\u4efb\u52a1\u6570\u636e\uff01");
                }
                if (maxSignOrder > 0 || maxSealSignOrder > 0) break block3;
                actionList.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)actionList.get(0));
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();
                List opts = actionList.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                operators.addAll(opts);
                for (SignMgrSignatoryEntity s : opts) {
                    s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                    this.signMgrSignatoryService.updateById((Object)s);
                }
                break block4;
            }
            List opts = actionList.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (opts.isEmpty()) break block4;
            opts.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = (SignMgrSignatoryEntity)((Object)opts.get(0));
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();
            List acts = opts.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            operators.addAll(acts);
            for (SignMgrSignatoryEntity act : acts) {
                act.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                this.signMgrSignatoryService.updateById((Object)act);
            }
        }
        return operators;
    }

    @Override
    public String sendStatus(String billType, Long billId, String refcode, int status, String authority) {
        CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            this.logger.error("\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u5931\u8d25,\u6839\u636ebillType-{}\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a{}\uff01", (Object)billType, (Object)mdRefResp.getMsg());
        }
        MdReferVO mdRef = (MdReferVO)mdRefResp.getData();
        String entityName = mdRef.getEntityName().replace("Entity", "") + "Signature";
        String apiUrl = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        String sendUrl = this.BASE_HOST + mdRef.getProjectName() + "/" + apiUrl + "/changeStatus";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billId", billId);
        param.put("refCode", refcode);
        param.put("status", status);
        try {
            JSONObject resultJson;
            String code;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("authority", authority);
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson((String)Objects.requireNonNull(sendUrl), (String)JSONObject.toJSONString(param), headerMap, (Integer)10000, (Integer)10000);
            this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{},\u7b7e\u7ae0\u72b6\u6001\u7ed3\u679c\uff1a{}", new Object[]{sendUrl, JSONObject.toJSONString(param), httpRespStr});
            if (!StringUtils.isEmpty((CharSequence)httpRespStr) && Integer.parseInt(code = (resultJson = JSONObject.parseObject((String)httpRespStr)).getString("code")) != 0) {
                this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u5931\u8d25");
                String string = "FAILED";
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u7b7e\u7ae0\u72b6\u6001\u5f02\u5e38\uff1a", new Object[]{sendUrl, JSONObject.toJSONString(param), e});
        }
        String response = "SUCCESS";
        return response;
    }

    @Override
    public void sendMessage(Long contractId, List<SignMgrSignatoryEntity> operators, String billCode, String contractName) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u901a\u77e5\u5165\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(operators));
        PushMsgParameter parameter = new PushMsgParameter();
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            ArrayList<String> lst = new ArrayList<String>();
            lst.add("sys");
            String[] channel = lst.toArray(new String[lst.size()]);
            String[] receivers = (String[])operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            String content = "PERSONAL".equals(operators.get(0).getSignActionType()) ? "\u60a8\u6709\u4e00\u4e2a\u79c1\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c:<a href=\"" + this.BASE_HOST + "ejc-contractbase-frontend/#/privateSign?contractId=" + contractId + "&tenantType=" + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=" + operators.get(0).getSignatureContact() + "\">\u70b9\u6211\u7b7e\u7f72</a>" : "\u60a8\u6709\u4e00\u4e2a\u79c1\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c:<a href=\"" + this.BASE_HOST + "ejc-contractbase-frontend/#/privateSign?contractId=" + contractId + "&tenantType=" + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=\">\u70b9\u6211\u7b7e\u7f72</a>";
            String msgType = "task";
            String subject = "\u4f60\u6709\u4e00\u4efd\u65b0\u7684\u6587\u4ef6\u3010" + billCode + "_" + contractName + "\u3011\u9700\u8981\u7b7e\u7f72!";
            CommonResponse user = this.userApi.queryListByIds(new String[]{receivers[0]});
            if (!user.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            this.logger.info("\u67e5\u8be2\u5230\u7684\u79df\u6237\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)user.getData()));
            String tenantId = String.valueOf(((UserVO)((List)user.getData()).get(0)).getTenantId());
            parameter.setChannel(channel);
            parameter.setReceivers(receivers);
            parameter.setMsgType(msgType);
            parameter.setSubject(subject);
            parameter.setContent(content);
            parameter.setTenantId(tenantId);
            this.logger.info("\u53d1\u9001\u901a\u77e5\u5165\u53c2\uff1a\u6d88\u606f\u53d1\u9001\u6e20\u9053\u7c7b\u578b\uff1a{}\uff0c\u63a5\u6536\u4eba\uff1a{}\uff0c\u6d88\u606f\u7c7b\u578b\uff1a{}\uff0c\u6d88\u606f\u4e3b\u9898\uff1a{}\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}\uff0c\u79df\u6237ID\uff1a{}", new Object[]{channel, receivers, msgType, subject, content, tenantId});
            try {
                CommonResponse response = this.pushMessageApi.pushMessage(parameter);
                if (!response.isSuccess()) {
                    this.logger.info("\u53d1\u9001\u6d88\u606f\u901a\u77e5\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
                }
            }
            catch (Exception e2) {
                this.logger.info("\u8c03\u7528\u7cfb\u7edf\u901a\u77e5\u5f02\u5e38---\u53d1\u9001\u901a\u77e5\u5165\u53c2\uff1a\u6d88\u606f\u53d1\u9001\u6e20\u9053\u7c7b\u578b\uff1a{}\uff0c\u63a5\u6536\u4eba\uff1a{}\uff0c\u6d88\u606f\u7c7b\u578b\uff1a{}\uff0c\u6d88\u606f\u4e3b\u9898\uff1a{}\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}\uff0c\u79df\u6237ID\uff1a{}", new Object[]{channel, receivers, msgType, subject, content, tenantId});
            }
        }
    }

    @Override
    public Long createDocument(String url, String billDocumentName, String billDocumentType) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new BusinessException("\u4e0d\u80fd\u901a\u8fc7\u4e1a\u52a1\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5730\u5740\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)billDocumentName)) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)billDocumentType)) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateDocumentRequest request = new CreateDocumentRequest();
        Long documentId = null;
        try {
            documentId = contractService.createDocumentByUrl(new DocumentCreateByUrl(url, billDocumentName, billDocumentType, null));
        }
        catch (PrivateAppException e) {
            this.logger.error("\u521b\u5efa\u5408\u540c\u6587\u6863\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("\u521b\u5efa\u5408\u540c\u6587\u6863\u5f02\u5e38\uff01");
        }
        this.logger.info("\u521b\u5efa\u5408\u540c\u6587\u4ef6\u6210\u529f,documentId:{}", (Object)documentId);
        return documentId;
    }

    @Override
    public void validation(InitSignatureVO param) {
        if (param.getBillId() == null) {
            throw new BusinessException("\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillType())) {
            throw new BusinessException("\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillCode())) {
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getContractName())) {
            throw new BusinessException("\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillRefCode())) {
            throw new BusinessException("refcode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getBillDocId() == null) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getBillDocumentName())) {
            throw new BusinessException("\u4e1a\u52a1\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getTenantName())) {
            throw new BusinessException("\u53d1\u8d77\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getSignMgrSignatoryEntities().isEmpty()) {
            throw new BusinessException("\u7b7e\u7f72\u65b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = param.getSignMgrSignatoryEntities();
        for (InitSignatoryVO s : list) {
            if (StringUtils.isEmpty((CharSequence)s.getTenantName())) {
                throw new BusinessException("\u7b7e\u7ea6\u4e3b\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)s.getTenantType())) {
                throw new BusinessException("\u7b7e\u7ea6\u4e3b\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (s.getSignatureType() == null) {
                throw new BusinessException("\u7b7e\u7f72\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (s.getSignOrder() == null) {
                throw new BusinessException("\u7b7e\u7f72\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (s.getSignatureList().isEmpty()) {
                throw new BusinessException("\u7b7e\u7ae0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List sealList = s.getSignatureList();
            for (SealInfoVO ss : sealList) {
                if (StringUtils.isEmpty((CharSequence)ss.getSignActionType())) {
                    throw new BusinessException("\u7b7e\u7f72\u52a8\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)ss.getName())) {
                    throw new BusinessException("\u7b7e\u7f72\u52a8\u4f5c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (ss.getSealSignOrder() == null) {
                    throw new BusinessException("\u7b7e\u7ae0\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (s.getSignatureType() != 0) continue;
                if (ss.getSignatoryVOList().isEmpty()) {
                    throw new BusinessException("\u7ecf\u529e\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                List signatoryList = ss.getSignatoryVOList();
                for (SignatoryVO sss : signatoryList) {
                    if (StringUtils.isEmpty((CharSequence)sss.getSignatureName())) {
                        throw new BusinessException("\u7ecf\u529e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    if (!StringUtils.isEmpty((CharSequence)sss.getSignatureContact())) continue;
                    throw new BusinessException("\u7ecf\u529e\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
                }
            }
        }
    }

    @Override
    public Long createContract(Long documentId, InitSignatureVO initSignatureVO) {
        Long contractId;
        SignMgrVO signMgrVO = new SignMgrVO();
        List signMgrSignatoryEntities = signMgrVO.getSignMgrSignatoryEntities();
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setCategoryId(this.categoryId);
        createContractRequest.setSubject(initSignatureVO.getBillDocumentName());
        createContractRequest.setSend(Boolean.valueOf(true));
        ArrayList<Long> documents = new ArrayList<Long>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        createContractRequest.setDescription(initSignatureVO.getSignRequirements());
        createContractRequest.setCreatorName(initSignatureVO.getCreatorName());
        createContractRequest.setCreatorContact(initSignatureVO.getCreatorContact());
        createContractRequest.setTenantName(initSignatureVO.getTenantName());
        signMgrVO.setBillId(initSignatureVO.getBillId());
        signMgrVO.setBillType(initSignatureVO.getBillType());
        signMgrVO.setBillRefCode(initSignatureVO.getBillRefCode());
        signMgrVO.setSourceDocId(documentId);
        signMgrVO.setBillDocId(initSignatureVO.getBillDocId());
        signMgrVO.setBillDocumentName(initSignatureVO.getBillDocumentName());
        signMgrVO.setBillDocumentType(initSignatureVO.getBillDocumentType());
        signMgrVO.setSignRequirements(initSignatureVO.getSignRequirements());
        signMgrVO.setCreatorName(initSignatureVO.getCreatorName());
        signMgrVO.setCreatorContact(initSignatureVO.getCreatorContact());
        signMgrVO.setTenantName(initSignatureVO.getTenantName());
        List initSignatoryVOList = initSignatureVO.getSignMgrSignatoryEntities();
        initSignatoryVOList.sort(Comparator.comparing(InitSignatoryVO::getSignOrder));
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        for (InitSignatoryVO initSignatoryVO : initSignatoryVOList) {
            Signatory signatory = new Signatory();
            signatory.setTenantType(TenantType.valueOf((String)initSignatoryVO.getTenantType()));
            signatory.setTenantName(initSignatoryVO.getTenantName());
            String tenantId = String.valueOf(InvocationInfoProxy.getTenantid());
            String signatoryHead = Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) ? "T_" : "S_";
            String signatoryNo = signatoryHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId() + "_" + initSignatureVO.getBillType() + "_" + String.valueOf(IdWorker.getId());
            signatory.setSignatoryNo(signatoryNo);
            signatory.setReceiverName(initSignatoryVO.getReceiverName());
            signatory.setContact(initSignatoryVO.getContact());
            signatory.setSerialNo(initSignatoryVO.getSignOrder());
            ArrayList<Action> actions = new ArrayList<Action>();
            List signatureList = initSignatoryVO.getSignatureList();
            for (SealInfoVO sealInfoVO : signatureList) {
                SignMgrSignatoryVO signMgrSignatoryVO = new SignMgrSignatoryVO();
                Action action = new Action();
                action.setType(ActionType.valueOf((String)sealInfoVO.getSignActionType()));
                String actionHead = null;
                actionHead = Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) ? "T_" : "S_";
                String actionNo = actionHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId() + "_" + initSignatureVO.getBillType() + "_" + ActionType.valueOf((String)sealInfoVO.getSignActionType()) + "_" + String.valueOf(sealInfoVO.getSealSignOrder()) + "_" + String.valueOf(IdWorker.getId());
                action.setActionNo(actionNo);
                action.setName(sealInfoVO.getName());
                action.setSerialNo(sealInfoVO.getSealSignOrder());
                ArrayList<Operator> operators = new ArrayList<Operator>();
                List signatoryVOList = sealInfoVO.getSignatoryVOList();
                if (!StringUtils.isEmpty((CharSequence)sealInfoVO.getSourceSealId()) && !StringUtils.isEmpty((CharSequence)sealInfoVO.getSourceSealName()) && Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    Set ids = Arrays.stream(sealInfoVO.getSourceSealId().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                    Set names = Arrays.stream(sealInfoVO.getSourceSealName().split(",")).collect(Collectors.toSet());
                    action.setSealIds(ids);
                    action.setSealNames(names);
                }
                for (SignatoryVO signatoryVO : signatoryVOList) {
                    CommonResponse user;
                    if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) && signatoryVO.getSignatureId() != null && !(user = this.userApi.queryListByIds(new String[]{String.valueOf(signatoryVO.getSignatureId())})).isSuccess()) {
                        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5185\u90e8\u5355\u4f4d\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7528\u6237id\u540e\u91cd\u8bd5\uff01");
                    }
                    Operator operator = new Operator();
                    operator.setOperatorName(signatoryVO.getSignatureName());
                    operator.setOperatorContact(signatoryVO.getSignatureContact());
                    operators.add(operator);
                    signMgrSignatoryVO.setSignatureId(signatoryVO.getSignatureId());
                    signMgrSignatoryVO.setSignatureName(signatoryVO.getSignatureName());
                    signMgrSignatoryVO.setSignatureContact(signatoryVO.getSignatureContact());
                    signMgrSignatoryVO.setSignActionType(sealInfoVO.getSignActionType());
                    signMgrSignatoryVO.setName(sealInfoVO.getName());
                    signMgrSignatoryVO.setSealSignOrder(sealInfoVO.getSealSignOrder());
                    signMgrSignatoryVO.setSourceSealId(sealInfoVO.getSourceSealId());
                    signMgrSignatoryVO.setSourceSealName(sealInfoVO.getSourceSealName());
                    signMgrSignatoryVO.setSealId(sealInfoVO.getSealId());
                    signMgrSignatoryVO.setSealName(sealInfoVO.getSealName());
                    signMgrSignatoryVO.setSignatureUserIds(sealInfoVO.getSignatureUserIds());
                    signMgrSignatoryVO.setActionNo(actionNo);
                    signMgrSignatoryVO.setTenantName(initSignatoryVO.getTenantName());
                    signMgrSignatoryVO.setTenantType(initSignatoryVO.getTenantType());
                    signMgrSignatoryVO.setReceiverName(initSignatoryVO.getReceiverName());
                    signMgrSignatoryVO.setContact(initSignatoryVO.getContact());
                    signMgrSignatoryVO.setSignOrder(initSignatoryVO.getSignOrder());
                    signMgrSignatoryVO.setSignatureType(initSignatoryVO.getSignatureType());
                    signMgrSignatoryVO.setSignatoryNo(signatoryNo);
                    signMgrSignatoryVO.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
                    signMgrSignatoryEntities.add(signMgrSignatoryVO);
                }
                action.setActionOperators(operators);
                actions.add(action);
            }
            signatory.setActions(actions);
            signatories.add(signatory);
        }
        createContractRequest.setSignatories(signatories);
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e2) {
            e2.printStackTrace();
            throw new BusinessException("\u521b\u5efa\u5408\u540c\u5931\u8d25!");
        }
        signMgrVO.setSourceBillId(contractId);
        signMgrVO.setSignMgrSignatoryEntities(signMgrSignatoryEntities);
        this.logger.info("================================>\u8bf7\u6c42\u5951\u7ea6\u9501\u53d1\u8d77\u5408\u540c\u6210\u529f\uff0c\u5f00\u59cb\u5199\u5165\u7b7e\u7ae0\u7ba1\u7406\u6570\u636e-START<================================");
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)BeanMapper.map((Object)signMgrVO, SignMgrEntity.class));
        this.logger.info("\u5373\u5c06\u5199\u5165\u7684\u7b7e\u7ae0\u6570\u636e\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)signMgrEntity)));
        this.saveOrUpdate((Object)signMgrEntity, false);
        this.logger.info("================================>\u8bf7\u6c42\u5951\u7ea6\u9501\u53d1\u8d77\u5408\u540c\u6210\u529f\uff0c\u5199\u5165\u7b7e\u7ae0\u7ba1\u7406\u6570\u636e\u6210\u529f-END<================================");
        this.logger.info("\u521b\u5efa\u5408\u540c\u6210\u529f,contractId:{}\uff0c\u5408\u540c\u6587\u6863id\uff1a{}\uff0c\u4e1a\u52a1id:{}\uff0c\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{contractId, documentId, signMgrEntity.getBillId(), signMgrEntity.getBillType()});
        return contractId;
    }

    @Override
    public String createCloudSignUrl(Long contractId, String contact) {
        String cloudSignUrl;
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        try {
            cloudSignUrl = contractService.cloudSignUrl(contractId, contact);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u516c\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u5931\u8d25\uff01");
        }
        this.logger.info("\u6587\u4ef6\u7b7e\u7f72\u94fe\u63a5:{}", (Object)cloudSignUrl);
        return cloudSignUrl;
    }

    @Override
    public String createPrivateSignUrl(Long contractId, String tenantType, String tenantName, String contact) {
        String privateSignUrl;
        SDKClient client = this.getSdkClient();
        SignServiceImpl signService = new SignServiceImpl(client);
        SignUrlRequest request = new SignUrlRequest();
        request.setContractId(contractId);
        request.setTenantType(TenantType.COMPANY);
        request.setTenantName(tenantName);
        if (!StringUtils.isEmpty((CharSequence)contact)) {
            request.setContact(contact);
        }
        request.setExpireTime(Integer.valueOf(259200));
        request.setCallbackPage("");
        request.setCallbackPage(this.CALL_BACK_URL);
        try {
            privateSignUrl = signService.signUrl(request);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u79c1\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u5931\u8d25\uff01");
        }
        return privateSignUrl;
    }

    @Override
    public String login(HttpServletRequest request, Long tenantId) {
        String authority = "";
        try {
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("tenantId", tenantId);
            this.logger.info("baseHost " + this.BASE_HOST);
            String back = HttpTookit.get((String)(this.BASE_HOST + "ejc-idm-web/user/context/getBytenantid"), params, (HttpServletRequest)request);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if (jsonBack.get((Object)"data") != null) {
                JSONObject data = (JSONObject)jsonBack.get((Object)"data");
                this.logger.info("data  " + data.toJSONString());
                if (data.get((Object)"userContext") != null) {
                    JSONObject userContext = (JSONObject)data.get((Object)"userContext");
                    authority = "userType=" + userContext.getString("userType") + ";userCode=" + userContext.getString("userCode") + ";orgId=" + userContext.getString("orgId") + ";tenantid=" + userContext.getString("tenantid") + ";token=" + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints") + ";u_usercode=" + userContext.getString("u_usercode") + ";userId=" + userContext.getString("userId");
                }
            }
        }
        catch (ClientProtocolException e) {
            this.logger.info(e.getMessage());
        }
        catch (GeneralSecurityException e) {
            this.logger.info(e.getMessage());
        }
        catch (IOException e) {
            this.logger.info(e.getMessage());
        }
        return authority;
    }

    @Override
    public void downloadHasSignedFile(Long contractId, OutputStream out) {
        SDKClient client = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(client);
        ContractDownloadRequest request = new ContractDownloadRequest();
        String[] downloadItems = new String[]{"NORMAL"};
        request.setDownloadItems(downloadItems);
        request.setContractId(contractId);
        request.setNeedCompressForOneFile(Boolean.valueOf(false));
        request.setOutputStream(out);
        this.logger.info("\u4e0b\u8f7d\u5408\u540c\u8bf7\u6c42request\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        try {
            contractService.download(request);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            this.logger.error("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01\u539f\u56e0\u662f\uff1a", (Throwable)e);
            throw new BusinessException("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01");
        }
        net.qiyuesuo.sdk.common.utils.IOUtils.safeClose((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, File file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(StandardCharsets.UTF_8).addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getName());
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(connTimeout.intValue());
            customReqConf.setSocketTimeout(readTimeout.intValue());
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator<String> iterator = headers.keySet().iterator();
                while (iterator.hasNext()) {
                    String s;
                    key = s = iterator.next();
                    post.addHeader(key, headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
            }
            CloseableHttpResponse res = client.execute((HttpUriRequest)post);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null) {
                client.close();
            }
        }
        return result;
    }

    @Override
    public void pushToFileCenter(File file, String authority, String sourceType, Long sourceId, String billType, String replace) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", sourceType);
        params.put("sourceId", String.valueOf(sourceId));
        params.put("billType", billType);
        params.put("originalFileNameStr", file.getName());
        params.put("replace", replace);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", authority);
        AttachmentVO attachmentVO = null;
        try {
            String fileUploadRespStr = SignMgrServiceImpl.postFile(this.BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file);
            CommonResponse attachmentResp = (CommonResponse)JSONObject.parseObject((String)fileUploadRespStr, CommonResponse.class);
            if (!attachmentResp.isSuccess()) {
                this.logger.error("\u7b7e\u7ae0\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1asourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, file.getName(), replace, attachmentResp.getMsg()});
            }
            attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)attachmentResp.getData()).get(0)), AttachmentVO.class);
            SignMgrPreviewEntity signMgrPreviewEntity = new SignMgrPreviewEntity();
            signMgrPreviewEntity.setBillId(attachmentVO.getSourceId());
            signMgrPreviewEntity.setBillType(attachmentVO.getBillType());
            signMgrPreviewEntity.setSourceType(attachmentVO.getSourceType());
            signMgrPreviewEntity.setFileId(attachmentVO.getId());
            signMgrPreviewEntity.setFileName(attachmentVO.getFileName());
            signMgrPreviewEntity.setFilePath(attachmentVO.getFilePath());
            signMgrPreviewEntity.setFileSize(attachmentVO.getFileSize());
            signMgrPreviewEntity.setOnlinePath(attachmentVO.getOnlinePath());
            signMgrPreviewEntity.setTruePath(attachmentVO.getTruePath());
            this.signMgrPreviewService.saveOrUpdate((Object)signMgrPreviewEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5f02\u5e38sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c", new Object[]{sourceId, sourceType, billType, file.getName(), replace, e});
        }
        this.logger.info("\u7b7e\u7ae0\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
    }

    @Override
    public List<SignMgrPreviewEntity> previewContract(Long sourceId, List<String> sourceTypes) {
        QueryParam param = new QueryParam();
        param.getParams().put("bill_id", new Parameter("eq", (Object)sourceId));
        param.getParams().put("source_type", new Parameter("in", sourceTypes));
        return this.signMgrPreviewService.queryList(param);
    }

    @Override
    @Async(value="downloadFileTask")
    public void fileTask(Long contractId, int status, SignMgrEntity signMgrEntity, String authority, String billType, Long billId) {
        File file;
        InvocationInfoProxy.setTenantid((Long)signMgrEntity.getTenantId());
        String key = "userCode";
        int idx = authority.indexOf(";" + key + "=");
        if (idx >= 0) {
            String tmp = authority.substring(idx + 1);
            InvocationInfoProxy.setUsercode((String)tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
        }
        String sourceType = "signature_" + status;
        String fileName = String.format("%s_%d", signMgrEntity.getBillDocumentName(), billId);
        FileOutputStream out = null;
        try {
            file = File.createTempFile(fileName, ".pdf");
            out = new FileOutputStream(file);
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01\u539f\u56e0\u662f\uff1a", (Throwable)e);
            throw new BusinessException("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01");
        }
        if (!file.isFile() || !file.exists()) {
            throw new BusinessException("\u521d\u59cb\u5316\u4e34\u65f6\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        this.downloadHasSignedFile(contractId, out);
        this.logger.info("\u4e0b\u8f7d\u5408\u540c\u5b8c\u6210,\u4e1a\u52a1ID\u4e3a\uff1a{},\u5951\u7ea6\u9501\u5408\u540cID\u4e3a\uff1a{}", (Object)billId, (Object)contractId);
        this.pushToFileCenter(file, authority, sourceType, billId, billType, "true");
        file.delete();
        this.logger.info("\u5220\u9664\u7b7e\u7ae0\u6587\u4ef6\uff1a{},\u6210\u529f\uff01", (Object)file.getName());
    }

    @Override
    public UserDetail userDetail(String contact) {
        SDKClient client = this.getSdkClient();
        EmployeeServiceImpl employeeService = new EmployeeServiceImpl(client);
        UserSearchRequest request = new UserSearchRequest();
        request.setMobile(contact);
        UserDetail result = null;
        try {
            result = employeeService.userDetail(request);
        }
        catch (PrivateAppException e) {
            this.logger.info("\u8bf7\u6c42\u53c2\u6570-contact\uff1a{}", (Object)contact);
            this.logger.error("\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u548c\u5176\u6240\u5728\u516c\u53f8\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u548c\u5176\u6240\u5728\u516c\u53f8\u4fe1\u606f\u5f02\u5e38!");
        }
        this.logger.info("\u89d2\u8272\u5217\u8868\uff1a{}", (Object)JSONUtils.toJson((Object)result));
        return result;
    }
}

