package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import net.qiyuesuo.sdk.bean.user.UserDetail;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/**
 * 签章管理
 *
 * @author generator
 */
public interface ISignMgrService extends IBaseService<SignMgrEntity> {

    /**
     * 每个节点签署完成
     *
     * @param map
     * @return
     */
    Map<String, Object> internalFlow(Map<String, String> map, SignMgrEntity signMgrEntity, List<SignMgrSignatoryEntity> actionList);

    /**
     * 下一个待签章的人员列表
     *
     * @param contractId
     * @param maxSignOrder
     * @param maxSealSignOrder
     * @return List<SignMgrSignatoryEntity>
     */
    List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder);


    /**
     * 同步签章状态
     *
     * @param billType
     * @param billId
     * @param refcode
     * @param status
     */
    String sendStatus(String billType, Long billId, String refcode, int status,String authority);

    /**
     * 发送消息
     *
     * @param operators
     * @param billType
     * @param billId
     * @param billDocumentName
     * @return
     */
    void sendMessage(Long contractId, List<SignMgrSignatoryEntity> operators, String billCode, String contractName);


    /**
     * 用文件创建合同文档
     *
     * @param
     * @return
     */
    Long createDocument(String url, String billDocumentName, String billDocumentType);

    /**
     * 手动校验
     *
     * @param param
     */
    void validation(InitSignatureVO param);

    /**
     * 创建合同
     *
     * @param documentId      合同文档id
     * @param initSignatureVO 发起签章VO
     * @return
     */
    Long createContract(Long documentId, InitSignatureVO initSignatureVO);

    /**
     * 获取公有云合同签署短链接
     *
     * @param contractId 合同id
     * @param contact    联系方式
     * @return cloudSignUrl
     */
    String createCloudSignUrl(Long contractId, String contact);


    /**
     * 获取私有云合同签署短链接
     *
     * @param contractId
     * @param tenantType
     * @param tenantName
     * @return
     */
    String createPrivateSignUrl(Long contractId, String tenantType, String tenantName, String contact);

    /**
     * 获取上下文
     *
     * @param request
     * @param tenantId
     * @return
     */
    String login(HttpServletRequest request, Long tenantId);

    void downloadHasSignedFile(Long contractId, OutputStream out);

    void pushToFileCenter(File file, String authority, String sourceType, Long sourceId, String billType, String replace);

    List<SignMgrPreviewEntity> previewContract(Long sourceId, List<String> sourceTypes);

    void fileTask(Long contractId, int status, SignMgrEntity signMgrEntity, String authority, String billType, Long billId);

    /**
     * 根据手机号查询用户信息和其所在公司信息
     *
     * @param contact
     * @return UserDetail
     */
    UserDetail userDetail(String contact);
}
