/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.ActionDetailVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignDetailVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.SignatoryDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.qiyuesuo.sdk.bean.user.UserDetail;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/api/signaturemanage"})
public class SignatureManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignMgrService signMgrService;
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private ISignMgrLogService signMgrLogService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${ejc.fileServerUrl}")
    private String FILE_HOST;

    @PostMapping(value={"/sendSignature"})
    public CommonResponse<Long> initiateSignature(@RequestBody InitSignatureVO initSignatureVO, HttpServletRequest httpServletRequest) {
        String fileName;
        String url;
        this.signMgrService.validation(initSignatureVO);
        String authority = httpServletRequest.getHeader("authority");
        Long userId = InvocationInfoProxy.getUserid();
        CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
        this.logger.info("\u53d1\u8d77\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeResponse));
        if (employeeResponse.isSuccess()) {
            String userName = ((EmployeeVO)employeeResponse.getData()).getUserName();
            if (StringUtils.isEmpty((CharSequence)userName)) {
                throw new BusinessException("\u8bf7\u7ef4\u62a4\u53d1\u8d77\u4eba\u540d\u79f0\uff01");
            }
            String mobilePhone = ((EmployeeVO)employeeResponse.getData()).getMobilePhone();
            if (StringUtils.isEmpty((CharSequence)mobilePhone)) {
                throw new BusinessException("\u8bf7\u7ef4\u62a4\u53d1\u8d77\u4eba\u624b\u673a\u53f7\uff01");
            }
        } else {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u53d1\u8d77\u4eba\u4fe1\u606f\uff01");
        }
        initSignatureVO.setCreatorName(((EmployeeVO)employeeResponse.getData()).getUserName());
        initSignatureVO.setCreatorContact(((EmployeeVO)employeeResponse.getData()).getMobilePhone());
        String billDocumentType = null;
        CommonResponse attachmentResp = this.attachmentApi.queryDetail(String.valueOf(initSignatureVO.getBillDocId()));
        this.logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u7684\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentResp));
        if (attachmentResp.isSuccess()) {
            url = this.FILE_HOST + ((AttachmentVO)attachmentResp.getData()).getFilePath();
            if (StringUtils.isEmpty((CharSequence)url)) {
                throw new BusinessException("\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            fileName = ((AttachmentVO)attachmentResp.getData()).getFileName();
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                throw new BusinessException("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a\uff01");
            }
        } else {
            throw new BusinessException("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        billDocumentType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        Long documentId = this.signMgrService.createDocument(url, initSignatureVO.getBillDocumentName(), billDocumentType);
        Long contractId = this.signMgrService.createContract(documentId, initSignatureVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        String billType = signMgrEntity.getBillType();
        Long billId = signMgrEntity.getBillId();
        String billRefCode = signMgrEntity.getBillRefCode();
        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;
        List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
        if (operators.isEmpty()) {
            throw new BusinessException("\u627e\u4e0d\u5230\u4e0b\u4e00\u4e2a\u7b7e\u7ae0\u4eba\uff01");
        }
        this.signMgrService.sendMessage(contractId, operators, initSignatureVO.getBillCode(), initSignatureVO.getContractName());
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            int status = 3;
            this.signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
        } else {
            int status = 2;
            this.signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
        }
        return CommonResponse.success((String)"\u53d1\u8d77\u7b7e\u7ae0\uff0c\u64cd\u4f5c\u6210\u529f\uff01", (Object)contractId);
    }

    @PostMapping(value={"/qysCallBack/global"})
    public CommonResponse<Long> global(@RequestParam Map<String, String> map) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "CONTRACT_COMPLETE": {
                break;
            }
            case "CONTRACT_TERMINATE": {
                break;
            }
            case "CONTRACT_EXPIRED": {
                break;
            }
        }
        return CommonResponse.success((String)"\u5168\u5c40\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/qysCallBack/organizer"})
    public CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(map));
        Long contractId = Long.valueOf(map.get("contractId"));
        switch (map.get("type")) {
            case "CONTRACT_SIGN": {
                break;
            }
            case "INTERNAL_FLOW": {
                String res;
                int status;
                this.logger.info("================================>\u5355\u4e2a\u8282\u70b9\u56de\u8c03-START<================================");
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"source_bill_id", (Object)contractId);
                SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
                String authority = this.signMgrService.login(httpServletRequest, signMgrEntity.getTenantId());
                InvocationInfoProxy.setTenantid((Long)signMgrEntity.getTenantId());
                String key = "userCode";
                int idx = authority.indexOf(";" + key + "=");
                if (idx >= 0) {
                    String tmp = authority.substring(idx + 1);
                    InvocationInfoProxy.setUsercode((String)tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
                }
                this.logger.info("\u83b7\u53d6\u7684\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e3a\uff1a{}", (Object)authority);
                RequestContextHolder.getRequestAttributes().setAttribute("authority", (Object)authority, 0);
                String billType = signMgrEntity.getBillType();
                Long billId = signMgrEntity.getBillId();
                String billRefCode = signMgrEntity.getBillRefCode();
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
                List actionList = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
                Map<String, Object> minMax = this.signMgrService.internalFlow(map, signMgrEntity, actionList);
                Integer maxSignOrder = (Integer)minMax.get("maxSignOrder");
                Integer maxSealSignOrder = (Integer)minMax.get("maxSealSignOrder");
                List slog = (List)minMax.get("SignMgrLogEntity");
                List<SignMgrSignatoryEntity> operators = this.signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);
                if (operators.isEmpty()) {
                    status = 4;
                    res = this.signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
                } else {
                    this.logger.info("================================>\u53d1\u9001\u6d88\u606f\u901a\u77e5-START<================================");
                    this.signMgrService.sendMessage(contractId, operators, signMgrEntity.getBillCode(), signMgrEntity.getContractName());
                    this.logger.info("================================>\u53d1\u9001\u6d88\u606f\u901a\u77e5-END<================================");
                    if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                        status = 3;
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u7532\u65b9\u7b7e\u7ae0-START<================================");
                        res = this.signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u7532\u65b9\u7b7e\u7ae0-END<================================");
                    } else {
                        status = 2;
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u4e59\u65b9\u7b7e\u7ae0-START<================================");
                        res = this.signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
                        this.logger.info("================================>\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u72b6\u6001-\u5f85\u4e59\u65b9\u7b7e\u7ae0-END<================================");
                    }
                }
                slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                this.signMgrLogService.updateBatchById(slog);
                this.signMgrService.fileTask(contractId, status, signMgrEntity, authority, billType, billId);
                this.logger.info("================================>\u5355\u4e2a\u8282\u70b9\u56de\u8c03-END<================================");
                break;
            }
            case "CONTRACT_RECALL": {
                break;
            }
        }
        return CommonResponse.success((String)"\u53d1\u8d77\u65b9\u72b6\u6001\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/qysCallBack/receiver"})
    public CommonResponse<String> receiver(@RequestParam Map<String, String> map) {
        this.logger.info("\u56de\u8c03\u5165\u53c2map\u4e3a\uff1a{}", map);
        switch (map.get("type")) {
            case "ALLRECEIVER_SIGNATORY_COMPLATE": {
                break;
            }
            case "CONTRACT_SIGN": {
                break;
            }
            case "INTERNAL_FLOW": {
                break;
            }
            case "CONTRACT_REJECTED": {
                break;
            }
            case "CONTRACT_TERMINATE_REJECTED": {
                break;
            }
        }
        return CommonResponse.success((String)"\u63a5\u6536\u65b9\u72b6\u6001\uff0c\u56de\u8c03\u6210\u529f\uff01");
    }

    @PostMapping(value={"/getPrivateSignUrl"})
    public CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO) {
        String privateSignUrl = this.signMgrService.createPrivateSignUrl(privateSignUrlVO.getContractId(), privateSignUrlVO.getTenantType(), privateSignUrlVO.getTenantName(), privateSignUrlVO.getContact());
        return CommonResponse.success((String)"\u83b7\u53d6\u79c1\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u6210\u529f\uff01", (Object)privateSignUrl);
    }

    @GetMapping(value={"/downloadHasSignedFile"})
    public void downloadHasSignedFile(@RequestParam(value="billId") Long billId, HttpServletResponse response) {
        if (billId == null) {
            throw new BusinessException("\u8bf7\u68c0\u67e5\u4e1a\u52a1id\u662f\u5426\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_id", (Object)billId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        if (signMgrEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u91cd\u8bd5\uff01");
        }
        Long contractId = signMgrEntity.getSourceBillId();
        FileOutputStream out = null;
        String fileName = String.format("%s_%d", signMgrEntity.getBillDocumentName(), billId);
        File file = null;
        try {
            file = File.createTempFile(fileName, ".pdf");
            out = new FileOutputStream(file);
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01\u539f\u56e0\u662f\uff1a", (Throwable)e);
            throw new BusinessException("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01");
        }
        if (!file.isFile() || !file.exists()) {
            throw new BusinessException("\u521d\u59cb\u5316\u4e34\u65f6\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        this.signMgrService.downloadHasSignedFile(contractId, out);
        this.logger.info("\u4e0b\u8f7d\u5408\u540c\u5b8c\u6210,\u4e1a\u52a1ID\u4e3a\uff1a{},\u5951\u7ea6\u9501\u5408\u540cID\u4e3a\uff1a{}", (Object)billId, (Object)contractId);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                int length = 0;
                byte[] temp = new byte[10240];
                while ((length = bufferedInputStream.read(temp)) != -1) {
                    bufferedOutputStream.write(temp, 0, length);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                this.logger.info("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)file.getName());
            }
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01\u539f\u56e0\u662f\uff1a", (Throwable)e);
            throw new BusinessException("\u4e0b\u8f7d\u7b7e\u7ae0\u6587\u4ef6\uff0c\u5931\u8d25\uff01");
        }
        finally {
            file.delete();
            this.logger.info("\u5220\u9664\u7b7e\u7ae0\u6587\u4ef6\uff1a{},\u6210\u529f\uff01", (Object)file.getName());
        }
    }

    @GetMapping(value={"/previewContract"})
    public CommonResponse<List<SignMgrPreviewVO>> previewContract(@RequestParam(value="billId") Long billId, @RequestParam(value="status") List<String> status) {
        if (billId == null || status.isEmpty()) {
            throw new BusinessException("\u8bf7\u68c0\u67e5\u53c2\u6570\u91cd\u8bd5\uff01");
        }
        this.logger.info("\u5408\u540cID\u4e3a--{},\u72b6\u6001--{}", (Object)billId, (Object)JSONObject.toJSONString(status));
        ArrayList<String> sourceTypes = new ArrayList<String>();
        for (String s : status) {
            sourceTypes.add("signature_" + s);
        }
        List<SignMgrPreviewEntity> signMgrPreviewEntityList = this.signMgrService.previewContract(billId, sourceTypes);
        if (signMgrPreviewEntityList == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u540e\u91cd\u8bd5\uff01");
        }
        List signMgrPreviewVOS = BeanMapper.mapList(signMgrPreviewEntityList, SignMgrPreviewVO.class);
        return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)signMgrPreviewVOS);
    }

    @GetMapping(value={"/signDetail"})
    public CommonResponse<SignDetailVO> signDetail(@RequestParam(value="billId") Long billId) {
        ArrayList<SignatoryDetailVO> sds;
        SignDetailVO signDetailVO = new SignDetailVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_id", (Object)billId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        if (signMgrEntity != null) {
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
            List list = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
            if (list.isEmpty()) {
                throw new BusinessException("\u67e5\u8be2\u7b7e\u7f72\u8be6\u60c5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\uff01");
            }
            signDetailVO.setTenantName(signMgrEntity.getTenantName());
            signDetailVO.setCreatorName(signMgrEntity.getCreatorName());
            signDetailVO.setCreateTime(signMgrEntity.getCreateTime());
            sds = new ArrayList<SignatoryDetailVO>();
            list.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder));
            Map<Integer, List<SignMgrSignatoryEntity>> listMap = list.stream().collect(Collectors.groupingBy(SignMgrSignatoryEntity::getSignOrder));
            int number = 1;
            for (Integer key : listMap.keySet()) {
                List<SignMgrSignatoryEntity> values = listMap.get(key);
                SignatoryDetailVO signatoryDetailVO = new SignatoryDetailVO();
                ArrayList<ActionDetailVO> actionDetails = new ArrayList<ActionDetailVO>();
                for (SignMgrSignatoryEntity value : values) {
                    ActionDetailVO actionDetailVO = new ActionDetailVO();
                    actionDetailVO.setActionName(value.getName());
                    actionDetailVO.setSignatoryName(value.getSignatureName());
                    actionDetailVO.setActualSignatoryName(value.getActualSignatoryName());
                    actionDetailVO.setSigningDate(value.getEndTime());
                    actionDetailVO.setSignatureStatus(value.getJobStatus());
                    actionDetails.add(actionDetailVO);
                }
                Set s = actionDetails.stream().map(ActionDetailVO::getSignatureStatus).collect(Collectors.toSet());
                if (!s.isEmpty()) {
                    if (s.contains(1)) {
                        signatoryDetailVO.setStatus(Integer.valueOf(1));
                    } else if (s.size() == 1 && ((Integer)s.iterator().next()).equals(2)) {
                        signatoryDetailVO.setStatus(Integer.valueOf(2));
                    } else {
                        signatoryDetailVO.setStatus(Integer.valueOf(0));
                    }
                }
                if (signMgrEntity.getTenantName().equals(values.get(0).getTenantName())) {
                    signatoryDetailVO.setSignatoryName("\u53d1\u8d77\u4e3b\u4f53");
                } else {
                    signatoryDetailVO.setSignatoryName("\u7b7e\u7ea6\u65b9" + number);
                    ++number;
                }
                signatoryDetailVO.setTenantName(values.get(0).getTenantName());
                if (!Objects.equals(values.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    signatoryDetailVO.setOperatorName(values.get(0).getReceiverName());
                    signatoryDetailVO.setContact(values.get(0).getContact());
                } else if (!StringUtils.isEmpty((CharSequence)values.get(0).getContact())) {
                    if (StringUtils.isEmpty((CharSequence)values.get(0).getReceiverName())) {
                        signatoryDetailVO.setOperatorName(null);
                    } else {
                        UserDetail userDetail = this.signMgrService.userDetail(values.get(0).getContact());
                        this.logger.info("\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\u548c\u516c\u53f8\u4fe1\u606f----{}", (Object)JSONObject.toJSONString((Object)userDetail));
                        if ("AUTH_FAILURE".equals(userDetail.getStatus())) {
                            signatoryDetailVO.setOperatorName(values.get(0).getReceiverName());
                        } else {
                            signatoryDetailVO.setOperatorName(userDetail.getName());
                        }
                    }
                    signatoryDetailVO.setContact(values.get(0).getContact());
                } else if (StringUtils.isEmpty((CharSequence)values.get(0).getReceiverName())) {
                    signatoryDetailVO.setOperatorName(signMgrEntity.getCreatorName());
                    signatoryDetailVO.setContact(signMgrEntity.getCreatorContact());
                } else {
                    signatoryDetailVO.setOperatorName(values.get(0).getReceiverName());
                    signatoryDetailVO.setContact(signMgrEntity.getCreatorContact());
                }
                signatoryDetailVO.setAcceptTime(values.get(0).getAcceptTime());
                signatoryDetailVO.setFinishTime(values.get(values.size() - 1).getEndTime());
                signatoryDetailVO.setActionDetails(actionDetails);
                sds.add(signatoryDetailVO);
            }
        } else {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7b7e\u7ae0\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01");
        }
        signDetailVO.setSignatorys(sds);
        return CommonResponse.success((String)"\u83b7\u53d6\u7b7e\u7f72\u8be6\u60c5\u6210\u529f\uff01", (Object)signDetailVO);
    }
}

