/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="uploadFileCenter")
public class uploadFileCenter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, File file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(StandardCharsets.UTF_8).addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getName());
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(connTimeout.intValue());
            customReqConf.setSocketTimeout(readTimeout.intValue());
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator<String> iterator = headers.keySet().iterator();
                while (iterator.hasNext()) {
                    String s;
                    key = s = iterator.next();
                    post.addHeader(key, headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
            }
            CloseableHttpResponse res = client.execute((HttpUriRequest)post);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null) {
                client.close();
            }
        }
        return result;
    }

    public CommonResponse<List<AttachmentVO>> uploadFile(File file, String authority, String sourceType, Long sourceId, String billType, String replace, String BASE_HOST) {
        CommonResponse attachmentResp = new CommonResponse();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", sourceType);
        params.put("sourceId", String.valueOf(sourceId));
        params.put("billType", billType);
        params.put("originalFileNameStr", file.getName());
        params.put("replace", replace);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", authority);
        AttachmentVO attachmentVO = null;
        try {
            String fileUploadRespStr = uploadFileCenter.postFile(BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file);
            attachmentResp = (CommonResponse)JSONObject.parseObject((String)fileUploadRespStr, CommonResponse.class);
            if (!attachmentResp.isSuccess()) {
                this.logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1asourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, file.getName(), replace, attachmentResp.getMsg()});
            }
            attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)attachmentResp.getData()).get(0)), AttachmentVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5f02\u5e38sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c", new Object[]{sourceId, sourceType, billType, file.getName(), replace, e});
        }
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
        return attachmentResp;
    }
}

