package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignatureCenterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.util.List;

/**
 * 签章中心
 */
@RestController
@RequestMapping("/signatureCenter")
public class SignMgrController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi; //获取用户
    @Autowired
    private ISignMgrService service;

    @Autowired
    private ISignMgrSignatoryService signatoryService;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 查询签章列表，内部单位
     *
     * @param param 请求参数
     * @return CommonResponse<IPage < SignMgrVO>>
     */
    @PostMapping(value = "/queryList")
    public CommonResponse<IPage<SignatureCenterVO>> queryList(@RequestBody QueryParam param) {
        // 请求参数
        logger.info("查询签章列表，请求参数：{}", JSONObject.toJSONString(param, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // 校验参数-签章状态（平台内）
        if (param.getParams() == null || param.getParams().get("jobStatus") == null) {
            return CommonResponse.error("请求参数签章状态jobStatus不能为空！");
        }
        // 获取当前登陆用户手机号
        // FIXME: 2022/2/23 同一用户在不同组织下手机号可能不一样，还需要根据组织查询
        CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{String.valueOf(InvocationInfoProxy.getUserid())});
        logger.info("当前登陆用户userId：{}，签章中心获取到的当前登陆用户信息：{}", InvocationInfoProxy.getUserid(), JSONObject.toJSONString(user, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        if (!user.isSuccess()) {
            return CommonResponse.error(user.getMsg());
        }
        if (user.getData().isEmpty()) {
            return CommonResponse.error("当前登陆用户信息不存在!");
        }
        String userMobile = user.getData().get(0).getUserMobile();
        if (StringUtils.isEmpty(userMobile)) {
            return CommonResponse.error("当前登陆用户手机号为空，请联系管理员！");
        }

        // 模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useSealType");
        fuzzyFields.add("waitTime"); // FIXME: 2022/2/23 等待时间模糊查询有问题，需要调整

        // 自定义分页查询子表数据
        Page<SignatureCenterVO> pg = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<SignatureCenterVO> pageData = signatoryService.querySignCenterPage(pg, InvocationInfoProxy.getTenantid(), userMobile, (Integer) param.getParams().get("jobStatus").getValue());

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO VO
     * @return privateSignUrl
     */
    @PostMapping(value = "/getPrivateSignUrl")
    public CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO) {
        String privateSignUrl = service.createPrivateSignUrl(privateSignUrlVO.getContractId(), privateSignUrlVO.getTenantType(), privateSignUrlVO.getTenantName(), privateSignUrlVO.getContact());
        return CommonResponse.success("获取私有云合同签署短链接，成功！", privateSignUrl);
    }

}