package com.ejianc.business.signaturemanage.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.vo.SignatureCenterVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 签章管理-签署方子表
 *
 * @author generator
 */
@Mapper
public interface SignMgrSignatoryMapper extends BaseCrudMapper<SignMgrSignatoryEntity> {

    /**
     * 签章中心分页查询
     *
     * @param tenantId         租户ID
     * @param signatureContact 签署人手机号
     * @param jobStatus        签章状态
     * @return 签章中心分页
     */
    IPage<SignatureCenterVO> querySignCenterPage(Page<SignatureCenterVO> page,
                                                 @Param("tenantId") Long tenantId,
                                                 @Param("signatureContact") String signatureContact,
                                                 @Param("jobStatus") Integer jobStatus);

}
