/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignatureCenterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import net.qiyuesuo.sdk.bean.contract.ContractDetail;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/signatureCenter"})
public class SignMgrController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ISignMgrService service;
    @Autowired
    private ISignMgrSignatoryService signatoryService;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<SignatureCenterVO>> queryList(@RequestBody QueryParam param) {
        this.logger.info("\u67e5\u8be2\u7b7e\u7ae0\u5217\u8868\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (param.getParams() == null || param.getParams().get("jobStatus") == null) {
            return CommonResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u7b7e\u7ae0\u72b6\u6001jobStatus\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse user = this.userApi.queryListByIds(new String[]{String.valueOf(InvocationInfoProxy.getUserid())});
        this.logger.info("\u5f53\u524d\u767b\u9646\u7528\u6237userId\uff1a{}\uff0c\u7b7e\u7ae0\u4e2d\u5fc3\u83b7\u53d6\u5230\u7684\u5f53\u524d\u767b\u9646\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)InvocationInfoProxy.getUserid(), (Object)JSONObject.toJSONString((Object)user, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!user.isSuccess()) {
            return CommonResponse.error((String)user.getMsg());
        }
        if (((List)user.getData()).isEmpty()) {
            return CommonResponse.error((String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        String userMobile = ((UserVO)((List)user.getData()).get(0)).getUserMobile();
        if (StringUtils.isEmpty((CharSequence)userMobile)) {
            return CommonResponse.error((String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useSealType");
        fuzzyFields.add("waitTime");
        Page pg = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage<SignatureCenterVO> pageData = this.signatoryService.querySignCenterPage((Page<SignatureCenterVO>)pg, InvocationInfoProxy.getTenantid(), userMobile, (Integer)((Parameter)param.getParams().get("jobStatus")).getValue());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @PostMapping(value={"/getPrivateSignUrl"})
    public CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO) {
        ContractDetail detail = this.service.detail(privateSignUrlVO.getContractId(), false);
        this.logger.info("\u7b7e\u7ae0\u4e2d\u5fc3-\u67e5\u8be2\u7684\u5408\u540c\u8be6\u60c5\uff1a{}", (Object)JSONObject.toJSONString((Object)detail, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (detail == null) {
            CommonResponse.error((String)"\u67e5\u4e0d\u5230\u5f53\u524d\u5408\u540c\u8be6\u60c5\uff01\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        switch (detail.getStatus()) {
            case SIGNING: {
                break;
            }
            case COMPLETE: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u5b8c\u6210");
            }
            case EXPIRED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u8fc7\u671f");
            }
            case DRAFT: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u8349\u7a3f");
            }
            case REJECTED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u9000\u56de");
            }
            case RECALLED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u64a4\u56de");
            }
            case FILLING: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u62df\u5b9a\u4e2d");
            }
            case TERMINATING: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u4f5c\u5e9f\u786e\u8ba4\u4e2d");
            }
            case TERMINATED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u4f5c\u5e9f");
            }
            case DELETE: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u5220\u9664");
            }
            case FINISHED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u5b8c\u6210 ");
            }
            case REQUIRED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5f85\u6211\u5904\u7406");
            }
            case WAITING: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5f85\u4ed6\u4eba\u5904\u7406");
            }
            case CANCELLED: {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c-\u5df2\u4f5c\u5e9f ");
            }
        }
        String privateSignUrl = this.service.createPrivateSignUrl(privateSignUrlVO.getContractId(), privateSignUrlVO.getTenantType(), privateSignUrlVO.getTenantName(), privateSignUrlVO.getContact());
        return CommonResponse.success((String)"\u83b7\u53d6\u79c1\u6709\u4e91\u5408\u540c\u7b7e\u7f72\u77ed\u94fe\u63a5\uff0c\u6210\u529f\uff01", (Object)privateSignUrl);
    }
}

