package com.ejianc.business.signaturemanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.ManagementUserEntity;
import com.ejianc.business.signaturemanage.mapper.ManagementMapper;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author:刘家乐
 * @version:
 * @document:
 */
@Service("managementService")
public class ManagementServiceImpl extends BaseServiceImpl<ManagementMapper, ManagementEntity>
        implements IManagementService {
    /**
     * 此处需要根据实际修改
     */
    private static final String BILL_CODE = "LJL_MANAGEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IOrgApi orgApi;

    @Value("${seal.defaultSealPng.personal}")
    private String personalImgUrl;

    public String getPersonalImgUrl() {
        return personalImgUrl;
    }

    public void setPersonalImgUrl(String personalImgUrl) {
        this.personalImgUrl = personalImgUrl;
    }

    @Override
    public CommonResponse<ManagementVO> updateManagement(ManagementVO vo) {
        ManagementEntity managementEntity = this.selectById(vo.getId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", managementEntity.getId()));
        queryParam.getParams().put("user_type", new Parameter("eq", "user"));
        List<ManagementUserEntity> managementUserEntities = userService.queryList(queryParam);
        if (!managementUserEntities.isEmpty()) {
            userService.deleteUserByIdList(managementUserEntities.stream().map(ManagementUserEntity::getId).collect(Collectors.toList()));
        }
        //修改组织 根据组织设置 tenantId
        if (null != vo.getOrgId()) {
            managementEntity.setOrgId(vo.getOrgId());
            CommonResponse<OrgVO> oneById = orgApi.getOneById(vo.getOrgId());
            managementEntity.setOrgName(vo.getOrgName());
            managementEntity.setTenantId(oneById.getData().getTenantId());
            managementEntity.setIsMatch(1);
        }
        List<ManagementUserEntity> userEntities = BeanMapper.mapList(vo.getUserEntityList(), ManagementUserEntity.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (ManagementUserEntity u : userEntities) {
            stringBuilder.append(u.getUserName());
            stringBuilder.append(",");
            u.setUserType("user");
            if (1 == u.getIsDefault()) {
                managementEntity.setSealDefaultId(u.getId());
                managementEntity.setSealDefaultName(u.getUserName());
            }
        }
        // 合同专用章 1：是，0：否
        managementEntity.setContractSealFlag(vo.getContractSealFlag());
        managementEntity.setSealUseName(stringBuilder.toString());
        managementEntity.setUserEntityList(userEntities);
        this.saveOrUpdate(managementEntity, false);
        List<ManagementUserVO> managementUserVoS = BeanMapper.mapList(userEntities, ManagementUserVO.class);
        ManagementVO map = BeanMapper.map(managementEntity, ManagementVO.class);
        map.setUserEntityList(managementUserVoS);
        return CommonResponse.success(map);
    }


    /**
     * 通过 SourceSealId 查询本地是否存在改印章
     *
     * @param managementEntity 1
     * @return 1
     */
    private ManagementEntity bySourceSealId(ManagementEntity managementEntity) {
        QueryWrapper<ManagementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_seal_id", managementEntity.getSourceSealId());
        return this.getOne(queryWrapper);
    }

    /**
     * 本地不存在
     *
     * @param managementEntity 执行新增
     */
    private void newManagement(ManagementEntity managementEntity) {
        //新增
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            managementEntity.setBillCode(billCode.getData());
            //需要判断是否匹配
            OrgVO orgVO = new OrgVO();
            orgVO.setTenantId(InvocationInfoProxy.getTenantid());
            orgVO.setName(managementEntity.getSourceCompanyName());
            CommonResponse<OrgVO> oneByOrgVO = orgApi.findOneByOrgVO(orgVO);
            if (oneByOrgVO.isSuccess()) {
                if (null != oneByOrgVO.getData()) {
                    this.checkPerson(oneByOrgVO.getData());
                    managementEntity.setTenantId(oneByOrgVO.getData().getTenantId());
                    managementEntity.setOrgName(oneByOrgVO.getData().getName());
                    managementEntity.setOrgId(oneByOrgVO.getData().getId());
                    managementEntity.setEnableStatus(1);
                    managementEntity.setIsMatch(1);
                } else {
                    managementEntity.setEnableStatus(0);
                    managementEntity.setIsMatch(0);
                }
            }
            // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
            if ("合同专用章".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }
            if ("NORMAL".equals(managementEntity.getSourceStatus())) {
                managementEntity.setEnableStatus(1);
            } else {
                managementEntity.setEnableStatus(0);
            }
            this.saveOrUpdate(managementEntity);
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    /**
     * 同步开始
     *
     * @param managementEntity 同步开始
     */
    @Override
    public void syncUpdate(ManagementEntity managementEntity, String authority) {
        ManagementEntity entity = this.bySourceSealId(managementEntity);
        if (null == entity) {
            //当前 印章本地不存在 执行新增策略
            this.newManagement(managementEntity);
        } else {
            //当前 印章本地存在 执行修改策略
            entity.setSourceCompanyId(managementEntity.getSourceCompanyId());
            entity.setSourceCompanyName(managementEntity.getSourceCompanyName());
            entity.setSourceStatus(managementEntity.getSourceStatus());
            entity.setSealSubTypeName(managementEntity.getSealSubTypeName());
            entity.setEnableStatus(managementEntity.getEnableStatus());
            entity.setSourceSealName(managementEntity.getSourceSealName());
            entity.setSourceSealId(managementEntity.getSourceSealId());
            if (StringUtils.isNotEmpty(managementEntity.getSourceStatusDescription())) {
                entity.setSourceStatusDescription(managementEntity.getSourceStatusDescription());
            }
            if (StringUtils.isNotEmpty(managementEntity.getSealType())) {
                entity.setSealType(managementEntity.getSealType());
            }
            // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
            if ("合同专用章".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }

            this.saveOrUpdate(entity, false);
        }

    }

    //查询当前组织下是否有 是否有类型是 person的印章（校验个人印章）
    public void checkPerson(OrgVO orgVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgVO.getId()));
        queryParam.getParams().put("sealType", new Parameter(QueryParam.EQ, "PERSONAL"));
        List<ManagementEntity> managementEntities = this.queryList(queryParam, false);
        if (managementEntities.isEmpty()) {
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                ManagementEntity entity = new ManagementEntity();
                entity.setOrgId(orgVO.getId());
                entity.setOrgName(orgVO.getName());
                entity.setIsMatch(1);
                entity.setSourceStatus("NORMAL");
                entity.setTenantId(InvocationInfoProxy.getTenantid());
                entity.setBillCode(billCode.getData());
                entity.setSealSubTypeName("个人");
                entity.setImgUrl(personalImgUrl);
                entity.setSealCategory("ELECTRONIC");
                entity.setSealType("PERSONAL");
                entity.setSourceSealId(IdWorker.getId());
                entity.setSourceSealName("个人签章");
                entity.setSourceCompanyName(orgVO.getName());
                this.saveOrUpdate(entity, false);
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        }
    }


}


