/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.ManagementUserEntity;
import com.ejianc.business.signaturemanage.mapper.ManagementMapper;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="managementService")
public class ManagementServiceImpl
extends BaseServiceImpl<ManagementMapper, ManagementEntity>
implements IManagementService {
    private static final String BILL_CODE = "LJL_MANAGEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${seal.defaultSealPng.personal}")
    private String personalImgUrl;

    public String getPersonalImgUrl() {
        return this.personalImgUrl;
    }

    public void setPersonalImgUrl(String personalImgUrl) {
        this.personalImgUrl = personalImgUrl;
    }

    @Override
    public CommonResponse<ManagementVO> updateManagement(ManagementVO vo) {
        ManagementEntity managementEntity = (ManagementEntity)((Object)this.selectById(vo.getId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)managementEntity.getId()));
        queryParam.getParams().put("user_type", new Parameter("eq", (Object)"user"));
        List managementUserEntities = this.userService.queryList(queryParam);
        if (!managementUserEntities.isEmpty()) {
            this.userService.deleteUserByIdList(managementUserEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (null != vo.getOrgId()) {
            managementEntity.setOrgId(vo.getOrgId());
            CommonResponse oneById = this.orgApi.getOneById(vo.getOrgId());
            managementEntity.setOrgName(vo.getOrgName());
            managementEntity.setTenantId(((OrgVO)oneById.getData()).getTenantId());
            managementEntity.setIsMatch(1);
        }
        List userEntities = BeanMapper.mapList((Iterable)vo.getUserEntityList(), ManagementUserEntity.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (ManagementUserEntity u : userEntities) {
            stringBuilder.append(u.getUserName());
            stringBuilder.append(",");
            u.setUserType("user");
            if (1 != u.getIsDefault()) continue;
            managementEntity.setSealDefaultId(u.getId());
            managementEntity.setSealDefaultName(u.getUserName());
        }
        managementEntity.setContractSealFlag(vo.getContractSealFlag());
        managementEntity.setSealUseName(stringBuilder.toString());
        managementEntity.setUserEntityList(userEntities);
        this.saveOrUpdate((Object)managementEntity, false);
        List managementUserVoS = BeanMapper.mapList((Iterable)userEntities, ManagementUserVO.class);
        ManagementVO map = (ManagementVO)BeanMapper.map((Object)((Object)managementEntity), ManagementVO.class);
        map.setUserEntityList(managementUserVoS);
        return CommonResponse.success((Object)map);
    }

    private ManagementEntity bySourceSealId(ManagementEntity managementEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_seal_id", (Object)managementEntity.getSourceSealId());
        return (ManagementEntity)((Object)this.getOne((Wrapper)queryWrapper));
    }

    private void newManagement(ManagementEntity managementEntity) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            managementEntity.setBillCode((String)billCode.getData());
            OrgVO orgVO = new OrgVO();
            orgVO.setTenantId(InvocationInfoProxy.getTenantid());
            orgVO.setName(managementEntity.getSourceCompanyName());
            CommonResponse oneByOrgVO = this.orgApi.findOneByOrgVO(orgVO);
            if (oneByOrgVO.isSuccess()) {
                if (null != oneByOrgVO.getData()) {
                    this.checkPerson((OrgVO)oneByOrgVO.getData());
                    managementEntity.setTenantId(((OrgVO)oneByOrgVO.getData()).getTenantId());
                    managementEntity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                    managementEntity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                    managementEntity.setEnableStatus(1);
                    managementEntity.setIsMatch(1);
                } else {
                    managementEntity.setEnableStatus(0);
                    managementEntity.setIsMatch(0);
                }
            }
            if ("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }
            if ("NORMAL".equals(managementEntity.getSourceStatus())) {
                managementEntity.setEnableStatus(1);
            } else {
                managementEntity.setEnableStatus(0);
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.saveOrUpdate((Object)managementEntity);
    }

    @Override
    public void syncUpdate(ManagementEntity managementEntity, String authority) {
        ManagementEntity entity = this.bySourceSealId(managementEntity);
        if (null == entity) {
            this.newManagement(managementEntity);
        } else {
            entity.setSourceCompanyId(managementEntity.getSourceCompanyId());
            entity.setSourceCompanyName(managementEntity.getSourceCompanyName());
            entity.setSourceStatus(managementEntity.getSourceStatus());
            entity.setSealSubTypeName(managementEntity.getSealSubTypeName());
            entity.setEnableStatus(managementEntity.getEnableStatus());
            entity.setSourceSealName(managementEntity.getSourceSealName());
            entity.setSourceSealId(managementEntity.getSourceSealId());
            if (StringUtils.isNotEmpty((CharSequence)managementEntity.getSourceStatusDescription())) {
                entity.setSourceStatusDescription(managementEntity.getSourceStatusDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)managementEntity.getSealType())) {
                entity.setSealType(managementEntity.getSealType());
            }
            if ("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }
            this.saveOrUpdate((Object)entity, false);
        }
    }

    public void checkPerson(OrgVO orgVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgVO.getId()));
        queryParam.getParams().put("sealType", new Parameter("eq", (Object)"PERSONAL"));
        List managementEntities = this.queryList(queryParam, false);
        if (managementEntities.isEmpty()) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                ManagementEntity entity = new ManagementEntity();
                entity.setOrgId(orgVO.getId());
                entity.setOrgName(orgVO.getName());
                entity.setIsMatch(1);
                entity.setSourceStatus("NORMAL");
                entity.setTenantId(InvocationInfoProxy.getTenantid());
                entity.setBillCode((String)billCode.getData());
                entity.setSealSubTypeName("\u4e2a\u4eba");
                entity.setImgUrl(this.personalImgUrl);
                entity.setSealCategory("ELECTRONIC");
                entity.setSealType("PERSONAL");
                entity.setSourceSealId(IdWorker.getId());
                entity.setSourceSealName("\u4e2a\u4eba\u7b7e\u7ae0");
                entity.setSourceCompanyName(orgVO.getName());
                this.saveOrUpdate((Object)entity, false);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
    }
}

