/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.SignatureSettingEntity;
import com.ejianc.business.signaturemanage.bean.SignatureSettingSubEntity;
import com.ejianc.business.signaturemanage.mapper.SignatureSettingMapper;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.service.ISignatureSettingService;
import com.ejianc.business.signaturemanage.service.ISignatureSettingSubService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.SignatureSettingSubVO;
import com.ejianc.business.signaturemanage.vo.SignatureSettingVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="signatureSettingService")
public class SignatureSettingServiceImpl
extends BaseServiceImpl<SignatureSettingMapper, SignatureSettingEntity>
implements ISignatureSettingService {
    private static final String BILL_CODE = "LJL_SIGNATURE_SET";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISignatureSettingSubService subService;
    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IManagementService managementService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<SignatureSettingVO> addNewSignature(SignatureSettingVO settingVO) {
        StringBuilder s;
        SignatureSettingEntity entity = (SignatureSettingEntity)((Object)BeanMapper.map((Object)settingVO, SignatureSettingEntity.class));
        CommonResponse byRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (byRuleCode.isSuccess()) {
            entity.setCode((String)byRuleCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            if (StringUtils.isEmpty((CharSequence)entity.getCreateName())) {
                entity.setCreateName(UserContext.getUserContext().getUserName());
                entity.setCreateId(UserContext.getUserContext().getUserId());
            }
            List<SignatureSettingSubEntity> subEntityList = entity.getSettingSubVoS();
            s = new StringBuilder();
            for (SignatureSettingSubEntity subEntity : subEntityList) {
                s.append(subEntity.getSourceSealName());
                s.append(",");
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setDefaultSealName(s.toString());
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u65b0\u589e\u6216\u4fee\u6539\u5355\u636e\u6210\u529f", (Object)BeanMapper.map((Object)((Object)entity), SignatureSettingVO.class));
    }

    @Override
    public CommonResponse<SignatureSettingVO> queryDetail(Long id) {
        SignatureSettingEntity entity = (SignatureSettingEntity)((Object)this.selectById(id));
        SignatureSettingVO map = (SignatureSettingVO)BeanMapper.map((Object)((Object)entity), SignatureSettingVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
        List signatureSettingSubEntities = this.subService.queryList(queryParam);
        List settingSubVoS = BeanMapper.mapList((Iterable)signatureSettingSubEntities, SignatureSettingSubVO.class);
        map.setSettingSubVoS(settingSubVoS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<SignatureSettingVO> saveOrUpdateSignature(SignatureSettingVO settingVO) {
        SignatureSettingEntity entity = (SignatureSettingEntity)((Object)BeanMapper.map((Object)settingVO, SignatureSettingEntity.class));
        if (!this.check(entity)) return CommonResponse.error((String)"\u6bcf\u4e2a\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a\u7b7e\u7ae0\u8bbe\u7f6e");
        if (null == entity.getId()) {
            CommonResponse byRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!byRuleCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)byRuleCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            List signatureSettingSubEntities = this.subService.queryList(queryParam);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (SignatureSettingSubEntity subEntity : signatureSettingSubEntities) {
                idList.add(subEntity.getId());
            }
            if (!idList.isEmpty()) {
                this.subService.deleteUserByIdList(idList);
            }
        }
        if (StringUtils.isEmpty((CharSequence)entity.getCreateName())) {
            entity.setCreateName(UserContext.getUserContext().getUserName());
            entity.setCreateId(UserContext.getUserContext().getUserId());
        }
        List<SignatureSettingSubEntity> subEntityList = entity.getSettingSubVoS();
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u65b0\u589e\u6216\u4fee\u6539\u5355\u636e\u6210\u529f", (Object)BeanMapper.map((Object)((Object)entity), SignatureSettingVO.class));
    }

    public boolean check(SignatureSettingEntity entity) {
        SignatureSettingEntity settingEntity = (SignatureSettingEntity)((Object)this.getOne((Wrapper)new QueryWrapper().eq((Object)"unit_id", (Object)entity.getUnitId())));
        boolean check = false;
        if (null == settingEntity) {
            check = true;
        } else if (null != entity.getId() && entity.getId().equals(settingEntity.getId())) {
            check = true;
        }
        return check;
    }

    @Override
    public CommonResponse<JSONObject> queryDefaultSeal(String unitId) {
        SignatureSettingEntity entity = (SignatureSettingEntity)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"unit_id", (Object)unitId)).eq((Object)"enable_status", (Object)1)));
        QueryParam queryParam = new QueryParam();
        if (null == entity) {
            return CommonResponse.success((String)"\u5f53\u524d\u5355\u4f4d\u672a\u8bbe\u7f6e\u7b7e\u7ae0", null);
        }
        queryParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
        queryParam.getParams().put("sourceStatus", new Parameter("eq", (Object)"NORMAL"));
        List signatureSettingSubEntities = this.subService.queryList(queryParam);
        List map = BeanMapper.mapList((Iterable)signatureSettingSubEntities, SignatureSettingSubVO.class);
        this.logger.error("map:" + JSONObject.toJSONString((Object)map));
        if (null == map) {
            return CommonResponse.success((String)"\u6570\u636e\u4e3a\u7a7a", null);
        }
        for (SignatureSettingSubVO subVO : map) {
            ManagementEntity managementEntity = (ManagementEntity)((Object)this.managementService.getOne((Wrapper)new QueryWrapper().eq((Object)"source_seal_id", (Object)subVO.getSourceSealId())));
            QueryParam query = new QueryParam();
            query.getParams().put("pid", new Parameter("eq", (Object)managementEntity.getId()));
            List managementUserEntities = this.userService.queryList(query, false);
            List managementUserVOS = BeanMapper.mapList((Iterable)managementUserEntities, ManagementUserVO.class);
            subVO.setUserVOS(managementUserVOS);
        }
        Map<String, List<SignatureSettingSubVO>> collect = map.stream().collect(Collectors.groupingBy(SignatureSettingSubVO::getSealType));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orgId", (Object)entity.getUnitId());
        jsonObject.put("orgName", (Object)entity.getUnitName());
        jsonObject.put("record", (Object)map);
        return CommonResponse.success((Object)jsonObject);
    }
}

