package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;


/**
 * @author:刘家乐
 * @version:
 * @document:
 */
public interface IManagementService extends IBaseService<ManagementEntity> {

    /**
     * 修改接口
     *
     * @param vo 当前需要修改的 签章
     * @return 返回修改后的签章
     */
    CommonResponse<ManagementVO> updateManagement(ManagementVO vo);


    /**
     * 同步 印章
     *
     * @param managementEntity 获取到的印章信息
     * @param authority        token
     */
    void syncUpdate(ManagementEntity managementEntity, String authority);


    /**
     * 批量处理保存和更新
     *
     * @param entityList 印章管理实体列表
     */
    void batchSaveOrUpdate(List<ManagementEntity> entityList);


    /**
     * 批量处理保存
     *
     * @param entityList 印章管理实体列表
     */
    void batchSave(List<ManagementEntity> entityList);


    /**
     * 批量处理更新
     *
     * @param updateEntities 要更新的印章管理实体列表
     * @param entityListMap  同步数据的map
     */
    void batchUpdate(List<ManagementEntity> updateEntities, Map<Long, ManagementEntity> entityListMap);


    /**
     * 异步更新印章图片地址
     *
     * @param sealIds   印章id
     * @param authority 上下文
     */
    void syncUpdateImgUrl(List<Long> sealIds, String authority);

}


