package com.ejianc.business.signaturemanage.service.impl;

import com.ejianc.business.signaturemanage.service.IGlobalCallBackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

// todo ：修改实现类名称，所有回调都在这里处理
@Service("globalCallBackServiceImpl")
public class GlobalCallBackServiceImpl implements IGlobalCallBackService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    GlobalCallBackService service;
    private Map<String, Function<Map<String, String>, Map<String, String>>> callBackMap = new HashMap<>();

    @PostConstruct
    public void dispatcher() {
        // 全局回调-文件作废
        callBackMap.put("CONTRACT_TERMINATE", map -> service.contractTerminate(map));
        // 全局回调-文件过期
        callBackMap.put("CONTRACT_EXPIRED", map -> service.contractExpired(map));
        // 全局回调-文件全部签署完成
        callBackMap.put("CONTRACT_COMPLETE", map -> service.contractComplete(map));


        // 发起方回调-文件撤回
        callBackMap.put("CONTRACT_RECALL", map -> service.contractRecall(map));


        // 接收方回调-文件退回
        callBackMap.put("CONTRACT_REJECTED", map -> service.contractRejected(map));
        // 接收方回调-所有接收方签署完成
        callBackMap.put("ALLRECEIVER_SIGNATORY_COMPLETE", map -> service.contractAllReceiverSignatoryComplete(map));

    }


    @Override
    public Map<String, String> callBackHandler(Map<String, String> map) {
        Function<Map<String, String>, Map<String, String>> result = callBackMap.get(map.get("type"));
        if (result == null) {
            logger.info("未找到对应的回调类型");
            return map;
        }
        return result.apply(map);
    }

}
