package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.SignMgrMapper;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrPreviewService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.utils.FileConvert;
import com.ejianc.business.signaturemanage.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.api.EmployeeService;
import net.qiyuesuo.sdk.api.SignService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.*;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.employee.UserSearchRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.bean.sign.SignatoryRect;
import net.qiyuesuo.sdk.bean.user.UserDetail;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.utils.IOUtils;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import net.qiyuesuo.sdk.impl.EmployeeServiceImpl;
import net.qiyuesuo.sdk.impl.SignServiceImpl;
import net.qiyuesuo.v2sdk.utils.JSONUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 签章管理
 *
 * @author generator
 */
@Service("signMgrService")
public class SignMgrServiceImpl extends BaseServiceImpl<SignMgrMapper, SignMgrEntity> implements ISignMgrService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEmployeeApi employeeApi;// 获取用户信息
    @Autowired
    private IBillTypeApi billTypeApi; // 根据billType找工程名
    @Autowired
    private IAttachmentApi attachmentApi; // 文件信息
    @Autowired
    private IUserApi userApi; //获取用户
    @Autowired
    private IPushMessageApi pushMessageApi; // 发送消息
    @Autowired
    private RabbitTemplate rabbitTemplate; // 消息队列
    @Autowired
    private ISignMgrPreviewService signMgrPreviewService;
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private ISignMgrLogService signMgrLogService;
    @Value("${qiyuesuo.client.url}")
    private String url;// 私有化开放平台请求地址
    @Value("${qiyuesuo.client.accessKey}")
    private String accessKey;// 私有化开放平台申请的token
    @Value("${qiyuesuo.client.accessSecret}")
    private String accessSecret;// 私有化开放平台申请的secret
    @Value("${qiyuesuo.contract.categoryId}")
    private Long categoryId;// 用印流程ID
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SignMgrMapper signMgrMapper;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Value("${qiyuesuo.callback.url}")
    private String CALL_BACK_URL;


    /**
     * 初始化sdk的client
     *
     * @return client
     */
    private SDKClient getSdkClient() {
        // 初始化client
        SDKClient client = new SDKClient(url, accessKey, accessSecret);
        // 开启防止重放攻击
        client.enableNonce();
        return client;
    }


    /**
     * 每个节点签署完成
     *
     * @param map
     * @return
     */
    @Override
    public Map<String, Object> internalFlow(Map<String, String> map, SignMgrEntity signMgrEntity, List<SignMgrSignatoryEntity> actionList) {
        Map<String, Object> result = new HashMap<String, Object>();

        // 获取回调成功的签署动作节点信息
        String action = map.get("action");

        JSONObject jsonObject = JSONObject.parseObject(action);
        String actionNo = jsonObject.getString("actionNo");

        // 通过actionNo过滤出当前的唯一签署动作
        List<SignMgrSignatoryEntity> signMgrSignatoryEntity = actionList.stream().filter(s -> actionNo.equals(s.getActionNo())).collect(Collectors.toList());


        List<SignMgrLogEntity> slog = new ArrayList<SignMgrLogEntity>();


        // 更新这一签署动作对应的所有签署人，并记录相关日志数据
        for (SignMgrSignatoryEntity mgrSignatoryEntity : signMgrSignatoryEntity) {
            // 更新任务状态
            mgrSignatoryEntity.setJobStatus(SignMgrSignatoryEnum.COMPLETED.getValue());

            // 更新签署状态
            switch (jsonObject.getString("status")) {
                case "SIGNED":// 完成
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.SIGNED.getValue());
                    break;
                case "REJECTED":// 拒绝
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.RETURNED.getValue());
                    break;
                case "DISCARDED":// 废弃
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.WITHDRAWN.getValue());
                default:// 其他
                    mgrSignatoryEntity.setSignResult(SignMgrSignatoryEnum.OTHER.getValue());
                    break;

            }


            // 更新实际签署人
            mgrSignatoryEntity.setActualSignatoryName(map.get("operatorName"));
            mgrSignatoryEntity.setActualSignatoryContact(map.get("operatorMobile"));

            // 实际签署人id:根据实际签署人姓名和实际签署人联系方式获取,调用IUserApi接口获取用户信息
            if (mgrSignatoryEntity.getSignatureId() != null) {
                CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{String.valueOf(mgrSignatoryEntity.getSignatureId())});
                if (user.isSuccess()) {
                    mgrSignatoryEntity.setActualSignatoryId(user.getData().get(0).getId());
                } else {
                    mgrSignatoryEntity.setActualSignatoryId(null);
                }
            } else {
                mgrSignatoryEntity.setActualSignatoryId(null);
            }


            try {
                mgrSignatoryEntity.setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("createTime")));
                mgrSignatoryEntity.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("completeTime")));
            } catch (ParseException e) {
                e.printStackTrace();
            }

            // 新增一条签章记录日志
            slog.add(getSignMgrLogEntity(map, signMgrEntity, mgrSignatoryEntity));
        }

        // 批量更新数据
        signMgrSignatoryService.updateBatchById(signMgrSignatoryEntity);
        signMgrLogService.saveOrUpdateBatch(slog);

        //第二种方法：可以记录当前回调成功的最大的签署顺序和签章顺序，寻找下一个人和通知消息可以改成异步方法，快速响应契约锁
        Integer maxSignOrder = signMgrSignatoryEntity.get(0).getSignOrder();
        Integer maxSealSignOrder = signMgrSignatoryEntity.get(0).getSealSignOrder();

        result.put("maxSignOrder", maxSignOrder);
        result.put("maxSealSignOrder", maxSealSignOrder);
        result.put("SignMgrLogEntity", slog);

        return result;
    }

    /**
     * 更新签章日志记录表
     *
     * @param map
     * @param signMgrEntity
     * @param mgrSignatoryEntity
     * @return
     */
    private SignMgrLogEntity getSignMgrLogEntity(Map<String, String> map, SignMgrEntity signMgrEntity, SignMgrSignatoryEntity mgrSignatoryEntity) {

        SignMgrLogEntity sml = BeanMapper.map(mgrSignatoryEntity, SignMgrLogEntity.class);
        // 未删除
        sml.setDelFlag(0);
        sml.setBillId(signMgrEntity.getBillId());
        sml.setBillType(signMgrEntity.getBillType());
        sml.setBillCode(signMgrEntity.getBillCode());
        sml.setContractName(signMgrEntity.getContractName());
        sml.setBillDocId(signMgrEntity.getBillDocId());
        sml.setBillDocumentName(signMgrEntity.getBillDocumentName());
        sml.setBillDocumentType(signMgrEntity.getBillDocumentType());
        sml.setSignRequirements(signMgrEntity.getSignRequirements());
        sml.setCreatorName(signMgrEntity.getCreatorName());
        sml.setContact(signMgrEntity.getCreatorContact());


        sml.setThirdSysCallbackContractId(Long.valueOf(map.get("contractId")));
        sml.setThirdSysCallbackTenantId(map.get("tenantId"));
        sml.setThirdSysCallbackSignatorySerialNo(map.get("signatorySerialNo"));
        sml.setThirdSysCallbackTenantName(map.get("tenantName"));
        sml.setThirdSysCallbackSn(map.get("sn"));
        sml.setThirdSysCallbackStatus(map.get("status"));
        sml.setThirdSysCallbackType(map.get("type"));
        sml.setThirdSysCallbackContact(map.get("contact"));
        sml.setThirdSysCallbackOperatorName(map.get("operatorName"));
        sml.setThirdSysCallbackOperatorMobile(map.get("operatorMobile"));
        sml.setThirdSysCallbackOperatorNumber(map.get("operatorNumber"));
        sml.setThirdSysCallbackReceiverNumber(map.get("receiverNumber"));
        sml.setThirdSysCallbackSerialNo(map.get("serialNo"));
        sml.setThirdSysCallbackActionName(map.get("actionName"));
        sml.setThirdSysCallbackActionNo(map.get("actionNo"));
        return sml;
    }


    /**
     * 下一个待签章的人员列表
     *
     * @param contractId
     * @param maxSignOrder
     * @param maxSealSignOrder
     * @return List<SignMgrSignatoryEntity>
     */
    public List<SignMgrSignatoryEntity> nextSignatory(Long contractId, Integer maxSignOrder, Integer maxSealSignOrder) {
        // todo : 所有查询条件增加del_flag=0

        List<SignMgrSignatoryEntity> operators = new ArrayList<>();
        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_bill_id", contractId);
        SignMgrEntity signMgrEntity = this.getOne(queryWrapper);

        QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("pid", signMgrEntity.getId());
        List<SignMgrSignatoryEntity> actionList = signMgrSignatoryService.list(queryWrapper1);

        if (actionList.size() == 0) {
            throw new BusinessException("未查询到签署动作任务数据！");
        }

        // 如果都是待激活,找到第一个签署方的第一批签署人
        if (maxSignOrder <= 0 && maxSealSignOrder <= 0) {
            actionList.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            SignMgrSignatoryEntity min = actionList.get(0);
            // 内部单位可以改状态，外部单位等所有接收方回调统一修改
            int minSignOrder = min.getSignOrder();
            int minSealSignOrder = min.getSealSignOrder();

            // 根据记录的最小签署顺序和签章顺序过滤出第一批签署人
            List<SignMgrSignatoryEntity> opts = actionList.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
            operators.addAll(opts);

            for (SignMgrSignatoryEntity s : opts) {
                s.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                // 修改任务状态为待签章
                signMgrSignatoryService.updateById(s);
            }
            // 通知业务系统当前签署状态
        } else {
            // 找到下一批待签署的人员列表
            List<SignMgrSignatoryEntity> opts = actionList.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (!opts.isEmpty()) {
                // 找到下一个待签章人员
                opts.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                SignMgrSignatoryEntity min = opts.get(0);
                int minSignOrder = min.getSignOrder();
                int minSealSignOrder = min.getSealSignOrder();

                // 根据记录的最小签署顺序和签章顺序过滤出第一批签署人
                List<SignMgrSignatoryEntity> acts = opts.stream().filter(e -> e.getSignOrder() == minSignOrder && e.getSealSignOrder() == minSealSignOrder).collect(Collectors.toList());
                operators.addAll(acts);
                for (SignMgrSignatoryEntity act : acts) {
                    act.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue());
                    signMgrSignatoryService.updateById(act);
                }
            }
        }

        return operators;
    }


    /**
     * 同步签章状态
     *
     * @param billType
     * @param billId
     * @param refcode
     * @param status
     */
    public String sendStatus(String billType, Long billId, String refcode, int status, String authority) {
        String response;
        //根据单据类型查询元数据信息
        CommonResponse<MdReferVO> mdRefResp = billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            logger.error("签章状态更新失败,根据billType-{}查询元数据信息失败,原因：{}！", billType, mdRefResp.getMsg());
        }
        MdReferVO mdRef = mdRefResp.getData();
        String entityName = mdRef.getEntityName().replace("Entity", "") + "Signature";
        String apiUrl = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        //获取到对应工程信息，调用指定工程
        String sendUrl = BASE_HOST + mdRef.getProjectName() + "/" + apiUrl + "/changeStatus";
        Map<String, Object> param = new HashMap<>();
        param.put("billId", billId);
        // 合同和变更合同区分字段
        param.put("refCode", refcode);
        param.put("status", status);

        try {
            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("authority", authority);
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson(Objects.requireNonNull(sendUrl), JSONObject.toJSONString(param), headerMap, 10000, 10000);
            logger.info("调用业务系统url-{},param-{},签章状态结果：{}", sendUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), httpRespStr);
            if (!StringUtils.isEmpty(httpRespStr)) {
                JSONObject resultJson = JSONObject.parseObject(httpRespStr);
                String code = resultJson.getString("code");
                if (Integer.parseInt(code) != 0) {
                    // 业务系统处理失败，补偿机制
                    logger.info("调用业务系统成功，返回结果失败");
                    response = "FAILED";
                }
            }

        } catch (Exception e) {
            logger.error("调用业务系统url-{},param-{},签章状态异常：", sendUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), e);
            // 调用业务系统请求失败，补偿机制

        }
        response = "SUCCESS";
        return response;
    }

    /**
     * 发送消息
     *
     * @param operators
     * @param contractId   合同id
     * @param operators    签署列表
     * @param billCode     单据编码
     * @param contractName 合同名称
     * @return CommonResponse<String>
     */
    public void sendMessage(Long contractId, List<SignMgrSignatoryEntity> operators, String billCode, String contractName) {

        logger.info("发送消息通知入参为：{}", JSONObject.toJSONString(operators, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        // 判断是不是接收方，是：（判断是不是在系统内，是：通知，否：不通知）否：
        // 如果系统内部有这些人，执行通知
        PushMsgParameter parameter = new PushMsgParameter();

        String[] channel;

        // 接收人
        String[] receivers;
        // 消息内容
        String content;
        if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            // 消息发送渠道类型
            ArrayList<String> lst = new ArrayList<>();
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);

            receivers = operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            if ("PERSONAL".equals(operators.get(0).getSignActionType())) {
                content = "您有一个私有云待签署合同:<a href=\"" + BASE_HOST + "ejc-signaturemanage-frontend/#/privateSign?" + "contractId=" + contractId + "&tenantType="
                        + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=" + operators.get(0).getSignatureContact() + "\">点我签署</a>";
            } else {
                content = "您有一个私有云待签署合同:<a href=\"" + BASE_HOST + "ejc-signaturemanage-frontend/#/privateSign?" + "contractId=" + contractId + "&tenantType="
                        + operators.get(0).getTenantType() + "&tenantName=" + operators.get(0).getTenantName() + "&contact=" + "" + "\">点我签署</a>";
            }

            // 消息类型(应该是枚举)
            String msgType = "task";

            // 消息主题
            String subject = "你有一份新的文件【" + billCode + "_" + contractName + "】需要签署!";

            // 租户ID
            CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{receivers[0]});
            if (!user.isSuccess()) {
                throw new BusinessException("获取用户信息异常！");
            }
            logger.info("查询到的租户列表：{}", JSONObject.toJSONString(user.getData(), SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            String tenantId = String.valueOf(user.getData().get(0).getTenantId());

            parameter.setChannel(channel);
            parameter.setReceivers(receivers);
            parameter.setMsgType(msgType);
            parameter.setSubject(subject);
            parameter.setContent(content);
            parameter.setTenantId(tenantId);

            logger.info("发送通知入参：消息发送渠道类型：{}，接收人：{}，消息类型：{}，消息主题：{}，消息内容：{}，租户ID：{}", channel, receivers, msgType, subject, content, tenantId);

            try {
                CommonResponse<String> response = pushMessageApi.pushMessage(parameter);
                if (!response.isSuccess()) {
                    logger.info("发送消息通知失败，原因：{}", JSONObject.toJSONString(response, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                    // 重发消息记录


                }
            } catch (Exception e) {
                logger.info("调用系统通知异常---发送通知入参：消息发送渠道类型：{}，接收人：{}，消息类型：{}，消息主题：{}，消息内容：{}，租户ID：{}", channel, receivers, msgType, subject, content, tenantId);

                // 重发消息记录


            }

        } else {
            /* // 消息发送渠道类型
            ArrayList<String> lst = new ArrayList<>();
            // 短信
            lst.add("sys");
            channel = lst.toArray(new String[lst.size()]);

            logger.info("生成公有云签署链接，通知乙方签署！");

            // 绑定杨世举的用户id
            // receivers = "505336137536651355".split(",");

            //根据经办人手机号查询系统内用户


            // receivers = operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            logger.info("接收通知的人：{}", JSONObject.toJSONString(receivers));
            content = "您有一个公有云待签署合同：<a href=\"" + BASE_HOST + "ejc-contractbase-frontend/#/publicSign?" + "contractId=" + contractId + "&contact="
                    + operators.get(0).getSignatureContact() + "\">点我签署</a>";
        }

        // 消息类型(应该是枚举)
        String msgType = "task";

        // 消息主题
        String subject = "签章提醒";

        // 租户ID
        CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{receivers[0]});
        if (!user.isSuccess()) {
            throw new BusinessException("获取用户信息异常！");
        }
        logger.info("查询到的租户列表：{}", JSONObject.toJSONString(user.getData()));
        String tenantId = String.valueOf(user.getData().get(0).getTenantId());

        parameter.setChannel(channel);
        parameter.setReceivers(receivers);
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);

        logger.info("发送通知入参：消息发送渠道类型：{}，接收人：{}，消息类型：{}，消息主题：{}，消息内容：{}，租户ID：{}", channel, receivers, msgType, subject, content, tenantId);

        try {
            CommonResponse<String> response = pushMessageApi.pushMessage(parameter);
            if (!response.isSuccess()) {
                logger.info("发送消息通知失败，原因：{}", JSONObject.toJSONString(response));
                // 重发消息记录


            }
        } catch (Exception e) {
            logger.info("调用系统通知异常---发送通知入参：消息发送渠道类型：{}，接收人：{}，消息类型：{}，消息主题：{}，消息内容：{}，租户ID：{}", channel, receivers, msgType, subject, content, tenantId);

            // 重发消息记录


        } */

        }

        // 设置接收时间
        operators.forEach(o -> o.setAcceptTime(new Date()));
        signMgrSignatoryService.saveOrUpdateBatch(operators, 5, false);
        logger.info("消息通知成功，已设置接收时间，当前通知人信息为：{}", JSONObject.toJSONString(operators, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
    }


    /**
     * 用文件创建合同文档
     * <p>
     * 1.初始化client
     * 2.初始化合同服务
     * 3.创建合同的请求
     * 4.设置文档文件流
     * 5.设置文件类型
     * 6.设置合同文档名称
     *
     * @param url
     * @param billDocumentName
     * @param billDocumentType
     * @return documentId
     */
    @Override
    public Long createDocument(String url, String billDocumentName, String billDocumentType) {
        if (StringUtils.isEmpty(url)) {
            throw new BusinessException("不能通过业务文件id获取文件地址！");
        }
        if (StringUtils.isEmpty(billDocumentName)) {
            throw new BusinessException("业务文件名称不能为空！");
        }
        if (StringUtils.isEmpty(billDocumentType)) {
            throw new BusinessException("业务文件类型不能为空！");
        }

        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        // 合同创建
        CreateDocumentRequest request = new CreateDocumentRequest();

        Long documentId = null;
        try {
            documentId = contractService.createDocumentByUrl(new DocumentCreateByUrl(url, billDocumentName, billDocumentType, null));
        } catch (PrivateAppException e) {
            logger.error("创建合同文档异常！", e);
            throw new BusinessException("创建合同文档异常！");
        }
        logger.info("创建合同文件成功,documentId:{}", documentId);

        return documentId;
    }

    /**
     * 手动校验
     *
     * @param param
     */
    public void validation(InitSignatureVO param) {
        if (param.getBillId() == null) {
            throw new BusinessException("业务id不能为空！");
        }
        if (StringUtils.isEmpty(param.getBillType())) {
            throw new BusinessException("来源业务单据类型不能为空！");
        }
        if (StringUtils.isEmpty(param.getBillCode())) {
            throw new BusinessException("单据编码不能为空！");
        }
        if (StringUtils.isEmpty(param.getContractName())) {
            throw new BusinessException("合同名称不能为空！");
        }
        if (StringUtils.isEmpty(param.getBillRefCode())) {
            throw new BusinessException("refcode不能为空！");
        }
        if (param.getBillDocId() == null) {
            throw new BusinessException("业务文件id不能为空！");
        }
        if (StringUtils.isEmpty(param.getBillDocumentName())) {
            throw new BusinessException("业务文件名称不能为空！");
        }
        if (StringUtils.isEmpty(param.getTenantName())) {
            throw new BusinessException("发起方名称不能为空！");
        }
        if (param.getSignMgrSignatoryEntities().isEmpty()) {
            throw new BusinessException("签署方信息不能为空！");
        }

        List<InitSignatoryVO> list = param.getSignMgrSignatoryEntities();

        for (InitSignatoryVO s : list) {
            if (StringUtils.isEmpty(s.getTenantName())) {
                throw new BusinessException("签约主体名称不能为空！");
            }
            if (StringUtils.isEmpty(s.getTenantType())) {
                throw new BusinessException("签约主体类型不能为空！");
            }
            if (s.getSignatureType() == null) {
                throw new BusinessException("签署方类型不能为空！");
            }
            if (s.getSignOrder() == null) {
                throw new BusinessException("签署顺序不能为空！");
            }
            if (s.getSignatureList().isEmpty()) {
                throw new BusinessException("签章信息不能为空！");
            }

            List<SealInfoVO> sealList = s.getSignatureList();

            for (SealInfoVO ss : sealList) {
                if (StringUtils.isEmpty(ss.getSignActionType())) {
                    throw new BusinessException("签署动作类型不能为空!");
                }
                if (StringUtils.isEmpty(ss.getName())) {
                    throw new BusinessException("签署动作名称不能为空!");
                }
                if (ss.getSealSignOrder() == null) {
                    throw new BusinessException("签章顺序不能为空!");
                }
                if (s.getSignatureType() == 0) {
                    if (ss.getSignatoryVOList().isEmpty()) {
                        throw new BusinessException("经办人不能为空!");
                    }
                    List<SignatoryVO> signatoryList = ss.getSignatoryVOList();

                    for (SignatoryVO sss : signatoryList) {
                        if (StringUtils.isEmpty(sss.getSignatureName())) {
                            throw new BusinessException("经办人名称不能为空!");
                        }
                        if (StringUtils.isEmpty(sss.getSignatureContact())) {
                            throw new BusinessException("经办人手机号不能为空!");
                        }
                    }
                }
            }
        }


    }

    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, File file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        // 设置传输超时时间
        Integer readTimeout = 600000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(StandardCharsets.UTF_8).addBinaryBody("file",
                    new FileInputStream(file), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getName());
            for (String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(connTimeout);

            customReqConf.setSocketTimeout(readTimeout);

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;

                for (String s : headers.keySet()) {
                    key = s;
                    post.addHeader(key, headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
            }
            res = client.execute(post);

            result = org.apache.commons.io.IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null) {
                client.close();
            }
        }

        return result;
    }

    /**
     * 获取公有云合同签署短链接
     * 1.初始化client
     * 2.初始化合同服务
     * 3.设置合同id
     *
     * @param contractId 合同id
     * @param contact    手机号
     * @return cloudSignUrl
     */
    @Override
    public String createCloudSignUrl(Long contractId, String contact) {
        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        String cloudSignUrl = null;
        try {
            cloudSignUrl = contractService.cloudSignUrl(contractId, contact);
        } catch (PrivateAppException e) {
            logger.error("获取公有云合同签署短链接，失败！原因是：", e);
            // 文件状态不是签署中，给提示
            ContractDetail detail = this.detail(contractId, false);
            logger.info("查询的合同详情：{}", JSONObject.toJSONString(detail, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            if (detail != null && !ContractStatus.SIGNING.equals(detail.getStatus())) {
                throw new BusinessException("当前合同文件状态不是签署中！");
            }
            throw new BusinessException("获取公有云合同签署短链接，失败！");
        }
        logger.info("文件签署链接:{}", cloudSignUrl);
        return cloudSignUrl;
    }

    /**
     * 获取私有云合同签署短链接
     *
     * @param contractId
     * @param tenantType
     * @param tenantName
     * @param contact
     * @return
     */
    @Override
    public String createPrivateSignUrl(Long contractId, String tenantType, String tenantName, String contact) {
        SDKClient client = getSdkClient();
        SignService signService = new SignServiceImpl(client);

        SignUrlRequest request = new SignUrlRequest();
        request.setContractId(contractId);
        request.setTenantType(TenantType.COMPANY);
        request.setTenantName(tenantName);
        if (!StringUtils.isEmpty(contact)) {
            request.setContact(contact);
        }
        request.setExpireTime(259200);
        // 签署完回跳地址
        request.setCallbackPage(CALL_BACK_URL);

        String privateSignUrl;
        try {
            privateSignUrl = signService.signUrl(request);
        } catch (PrivateAppException e) {
            logger.error("获取私有云合同签署短链接，失败！原因是：", e);
            // 文件状态不是签署中，给提示
            ContractDetail detail = this.detail(contractId, false);
            logger.info("查询的合同详情：{}", JSONObject.toJSONString(detail, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            if (detail != null && !ContractStatus.SIGNING.equals(detail.getStatus())) {
                throw new BusinessException("当前合同文件状态不是签署中！");
            }
            throw new BusinessException("获取私有云合同签署短链接，失败！");
        }

        return privateSignUrl;
    }


    /**
     * 通过发起方租户id获取该租户的管理员，获取该管理员的上下文
     *
     * @param tenantId
     * @return
     */
    // 模拟登陆并返回系统id
    @Override
    public String login(HttpServletRequest request, Long tenantId) {
        String authority = "";
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("tenantId", tenantId);
            logger.info("baseHost " + BASE_HOST);
            String back = HttpTookit.get(BASE_HOST + "ejc-idm-web/user/context/getBytenantid", params, request);
            JSONObject jsonBack = JSONObject.parseObject(back);
            if (jsonBack.get("data") != null) {
                JSONObject data = (JSONObject) jsonBack.get("data");
                logger.info("data  " + data.toJSONString());
                if (data.get("userContext") != null) {
                    JSONObject userContext = (JSONObject) data.get("userContext");
                    authority = "userType=" + userContext.getString("userType") + ";userCode="
                            + userContext.getString("userCode") +
                            // ";userName="+userContext.getString("userName")
                            // +
                            ";orgId=" + userContext.getString("orgId") +
                            // ";orgName="+userContext.getString("orgName")
                            // +
                            ";tenantid=" + userContext.getString("tenantid") + ";token="
                            + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
                            + ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
                            + userContext.getString("userId");
                    // request.setAttribute("authority",
                    // URLEncoder.encode(authority,"utf-8"));
                    // request.setAttribute("authority", authority);

                }
            }
        } catch (ClientProtocolException e) {
            logger.info(e.getMessage());
        } catch (GeneralSecurityException e) {
            logger.info(e.getMessage());
        } catch (IOException e) {
            logger.info(e.getMessage());
        }
        return authority;
    }


    /**
     * 下载签章文件
     */
    @Override
    public void downloadHasSignedFile(Long contractId, OutputStream out) {
        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        ContractDownloadRequest request = new ContractDownloadRequest();

        String[] downloadItems = {"NORMAL"};
        request.setDownloadItems(downloadItems);

        request.setContractId(contractId);
        request.setNeedCompressForOneFile(false);
        request.setOutputStream(out);
        logger.info("下载合同请求request：{}", JSONObject.toJSONString(request, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        try {
            contractService.download(request);
        } catch (PrivateAppException e) {
            logger.error("下载签章文件，失败！原因是：", e);
            throw new BusinessException("下载签章文件，失败！");
        }
        IOUtils.safeClose(out);
    }

    /**
     * 创建合同
     * <p>
     * 1.初始化client
     * 2.初始化合同服务
     * 3.设置私发公签用印流程ID
     * 4.默认立即发起合同
     * 5.设置合同的文档ID的集合
     * 6.添加合同描述
     * 7.添加合同创建人姓名
     * 8.添加合同创建人手机号
     * 9.添加发起方名称
     * 10.添加签署方信息-签署方类型
     * 11.添加签署方信息-签署方名称
     * 12.添加签署方信息-接收人姓名
     * 13.添加签署方信息-接收人手机号
     * 14.
     * 15.
     * 16.
     * 17.
     *
     * @param documentId      合同文档id
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @Override
    public Long createContract(Long documentId, InitSignatureVO initSignatureVO) {
        logger.info("发起签章创建合同初始数据：{}", JSONObject.toJSONString(initSignatureVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        SignMgrVO signMgrVO = new SignMgrVO();
        List<SignMgrSignatoryVO> signMgrSignatoryEntities = signMgrVO.getSignMgrSignatoryEntities();

        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);
        CreateContractRequest createContractRequest = new CreateContractRequest();
        // 设置用印流程ID（默认：私发公签）
        createContractRequest.setCategoryId(categoryId);
        // 设置合同名称
        createContractRequest.setSubject(initSignatureVO.getBillDocumentName());
        // 是否立即发起合同，默认true。（true：立即发起；false：保存为草稿）
        createContractRequest.setSend(true);
        // 文档ID的集合（一个文档只能属于一个合同）
        List<Long> documents = new ArrayList<>();
        documents.add(documentId);
        createContractRequest.setDocuments(documents);
        // 合同描述,合同详情页面中的备注
        createContractRequest.setDescription(initSignatureVO.getSignRequirements());
        // 合同创建人姓名，不传创建人的相关信息默认为发起方的名称
        createContractRequest.setCreatorName(initSignatureVO.getCreatorName());
        // 合同创建人联系方式，联系方式允许使用大陆、台湾和香港的手机号，台湾和香港的手机号格式为：区号+空格+手机号，例：852 9xxxxxxx
        createContractRequest.setCreatorContact(initSignatureVO.getCreatorContact());
        // 发起方名称
        createContractRequest.setTenantName(initSignatureVO.getTenantName());


        // 未删除
        signMgrVO.setDelFlag(0);
        signMgrVO.setBillId(initSignatureVO.getBillId());
        signMgrVO.setBillType(initSignatureVO.getBillType());
        signMgrVO.setBillCode(initSignatureVO.getBillCode());
        signMgrVO.setContractName(initSignatureVO.getContractName());
        signMgrVO.setContractTaxMny(initSignatureVO.getContractTaxMny());
        signMgrVO.setProjectId(initSignatureVO.getProjectId());
        signMgrVO.setProjectCode(initSignatureVO.getProjectCode());
        signMgrVO.setProjectName(initSignatureVO.getProjectName());
        signMgrVO.setBillRefCode(initSignatureVO.getBillRefCode());


        signMgrVO.setSourceDocId(documentId);
        signMgrVO.setBillDocId(initSignatureVO.getBillDocId());
        signMgrVO.setBillDocumentName(initSignatureVO.getBillDocumentName());
        signMgrVO.setBillDocumentType(initSignatureVO.getBillDocumentType());
        signMgrVO.setSignRequirements(initSignatureVO.getSignRequirements());
        signMgrVO.setCreatorName(initSignatureVO.getCreatorName());
        signMgrVO.setCreatorContact(initSignatureVO.getCreatorContact());
        signMgrVO.setTenantName(initSignatureVO.getTenantName());


        List<InitSignatoryVO> initSignatoryVOList = initSignatureVO.getSignMgrSignatoryEntities();
        // 按照签署顺序和签章顺序升序排列
        initSignatoryVOList.sort(Comparator.comparing(InitSignatoryVO::getSignOrder));


        // 签署方信息
        List<Signatory> signatories = new ArrayList<>();

        for (InitSignatoryVO initSignatoryVO : initSignatoryVOList) {
            Signatory signatory = new Signatory();
            // 签署方类型：COMPANY（企业），PERSONAL（个人）
            signatory.setTenantType(TenantType.valueOf(initSignatoryVO.getTenantType()));
            // 签署方名称
            signatory.setTenantName(initSignatoryVO.getTenantName());
            // 签署方编号:T_租户id_refCode_业务id_业务类型_唯一编码
            String tenantId = String.valueOf(InvocationInfoProxy.getTenantid());
            String signatoryHead;
            if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                signatoryHead = "T_";
            } else {
                signatoryHead = "S_";
            }
            String signatoryNo = signatoryHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId()
                    + "_" + initSignatureVO.getBillType() + "_" + String.valueOf(IdWorker.getId());
            signatory.setSignatoryNo(signatoryNo);
            // 接收人姓名联系方式甲方先不添加，外部单位添加
            signatory.setReceiverName(initSignatoryVO.getReceiverName());
            signatory.setContact(initSignatoryVO.getContact());
            // 设置签署顺序
            signatory.setSerialNo(initSignatoryVO.getSignOrder());

            // 签署顺序（从1开始)；如果想按顺序签署，则分别设置签署方的serialNo为1,2,3
            List<Action> actions = new ArrayList<>();
            List<SealInfoVO> signatureList = initSignatoryVO.getSignatureList();
            // 签署动作/签署节点
            for (SealInfoVO sealInfoVO : signatureList) {
                SignMgrSignatoryVO signMgrSignatoryVO = new SignMgrSignatoryVO();

                Action action = new Action();
                // 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
                action.setType(ActionType.valueOf(sealInfoVO.getSignActionType()));
                // 签署动作编号，唯一。前端生成
                // 签署方编号:T_租户id_refCode_业务id_业务类型_签署动作类型_签章顺序_唯一编码
                String actionHead = null;
                if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    actionHead = "T_";
                } else {
                    actionHead = "S_";
                }
                String actionNo = actionHead + tenantId + "_" + initSignatureVO.getBillRefCode() + "_" + initSignatureVO.getBillId()
                        + "_" + initSignatureVO.getBillType() + "_" + ActionType.valueOf(sealInfoVO.getSignActionType())
                        + "_" + String.valueOf(sealInfoVO.getSealSignOrder()) + "_" + String.valueOf(IdWorker.getId());
                action.setActionNo(actionNo);
                // 签署动作名称,根据签署动作类型填写
                action.setName(sealInfoVO.getName());
                // 签章顺序,前置设置1，后置逐渐增大，无序设置相同
                action.setSerialNo(sealInfoVO.getSealSignOrder());

                // 添加签署人(一个或多个)
                List<Operator> operators = new ArrayList<>();
                List<SignatoryVO> signatoryVOList = sealInfoVO.getSignatoryVOList();

                // 甲方指定一组默认的印章
                if (!StringUtils.isEmpty(sealInfoVO.getSourceSealId()) && !StringUtils.isEmpty(sealInfoVO.getSourceSealName())) {
                    if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                        Set<Long> ids = Arrays.stream(sealInfoVO.getSourceSealId().split(",")).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                        Set<String> names = Arrays.stream(sealInfoVO.getSourceSealName().split(",")).collect(Collectors.toSet());
                        action.setSealIds(ids);
                        action.setSealNames(names);
                    }
                }


                for (SignatoryVO signatoryVO : signatoryVOList) {
                    if (Objects.equals(initSignatoryVO.getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue()) && signatoryVO.getSignatureId() != null) {
                        CommonResponse<List<UserVO>> user = userApi.queryListByIds(new String[]{String.valueOf(signatoryVO.getSignatureId())});
                        if (!user.isSuccess()) {
                            throw new BusinessException("未查询到内部单位人员信息，请检查用户id后重试！");
                        }
                    }
                    Operator operator = new Operator();

                    // 签章人姓名
                    operator.setOperatorName(signatoryVO.getSignatureName());
                    // 签章人联系方式
                    operator.setOperatorContact(signatoryVO.getSignatureContact());
                    operators.add(operator);

                    // 契约锁：乙方为空的
                    signMgrSignatoryVO.setSignatureId(signatoryVO.getSignatureId());
                    signMgrSignatoryVO.setSignatureName(signatoryVO.getSignatureName());
                    signMgrSignatoryVO.setSignatureContact(signatoryVO.getSignatureContact());


                    // 契约锁
                    signMgrSignatoryVO.setSignActionType(sealInfoVO.getSignActionType());
                    signMgrSignatoryVO.setName(sealInfoVO.getName());
                    signMgrSignatoryVO.setSealSignOrder(sealInfoVO.getSealSignOrder());
                    signMgrSignatoryVO.setSourceSealId(sealInfoVO.getSourceSealId());
                    signMgrSignatoryVO.setSourceSealName(sealInfoVO.getSourceSealName());

                    // 本平台
                    signMgrSignatoryVO.setSealId(sealInfoVO.getSealId());
                    signMgrSignatoryVO.setSealName(sealInfoVO.getSealName());
                    signMgrSignatoryVO.setSignatureUserIds(sealInfoVO.getSignatureUserIds());
                    signMgrSignatoryVO.setActionNo(actionNo);

                    // 契约锁
                    signMgrSignatoryVO.setTenantName(initSignatoryVO.getTenantName());
                    signMgrSignatoryVO.setTenantType(initSignatoryVO.getTenantType());
                    signMgrSignatoryVO.setReceiverName(initSignatoryVO.getReceiverName());
                    signMgrSignatoryVO.setContact(initSignatoryVO.getContact());
                    signMgrSignatoryVO.setSignOrder(initSignatoryVO.getSignOrder());

                    // 本平台
                    signMgrSignatoryVO.setSignatureType(initSignatoryVO.getSignatureType());
                    signMgrSignatoryVO.setSignatoryNo(signatoryNo);
                    signMgrSignatoryVO.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
                    // 未删除
                    signMgrSignatoryVO.setDelFlag(0);

                    signMgrSignatoryEntities.add(signMgrSignatoryVO);
                }

                // 签署位置
                List<SignatoryRectVO> signatoryRectVOList = sealInfoVO.getSignatoryRectVOList();
                if (!signatoryRectVOList.isEmpty()) {
                    List<SignatoryRect> signatoryRects = new ArrayList<>();
                    for (SignatoryRectVO rect : signatoryRectVOList) {
                        SignatoryRect sr = new SignatoryRect();
                        sr.setDocumentId(rect.getDocumentId());
                        sr.setRectType(StamperType.valueOf(rect.getRectType()));
                        sr.setKeyword(rect.getKeyword());
                        signatoryRects.add(sr);
                    }
                    action.setLocations(signatoryRects);
                }

                action.setActionOperators(operators);
                // 添加签署动作
                actions.add(action);
            }
            signatory.setActions(actions);
            // 添加签署方
            signatories.add(signatory);
        }

        // 创建合同请求添加签署方
        createContractRequest.setSignatories(signatories);
        Long contractId;
        try {
            contractId = contractService.createContractByCategory(createContractRequest);
        } catch (PrivateAppException e) {
            logger.error("创建合同，失败！原因是：", e);
            throw new BusinessException("创建合同失败!");
        }
        signMgrVO.setSourceBillId(contractId);
        signMgrVO.setSignMgrSignatoryEntities(signMgrSignatoryEntities);

        // 创建合同成功，保存签章管理数据
        logger.info("================================>请求契约锁发起合同成功，开始写入签章管理数据-START<================================");
        SignMgrEntity signMgrEntity = BeanMapper.map(signMgrVO, SignMgrEntity.class);
        logger.info("即将写入的签章数据signMgrVO为：{}", JSONObject.toJSONString(signMgrVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        logger.info("即将写入的签章数据signMgrEntity为：{}", JSONObject.toJSONString(signMgrEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        this.saveOrUpdate(signMgrEntity, false);
        logger.info("================================>请求契约锁发起合同成功，写入签章管理数据成功-END<================================");
        logger.info("创建合同成功,contractId:{}，合同文档id：{}，业务id:{}，来源业务单据类型：{}", contractId, documentId, signMgrEntity.getBillId(), signMgrEntity.getBillType());
        return contractId;
    }

    /**
     * 文件中心文件vo
     *
     * @param file       文件
     * @param authority  上下文
     * @param sourceType 来源类型
     * @param sourceId   来源id
     * @param billType   单据类型
     * @param replace    是否替换
     * @return AttachmentVO
     */
    public AttachmentVO pushToFileCenter(File file, String authority, String sourceType, Long sourceId, String billType, String replace) {
        Map<String, String> params = new HashMap<>();
        params.put("sourceType", sourceType);
        params.put("sourceId", String.valueOf(sourceId));
        params.put("billType", billType);
        params.put("originalFileNameStr", file.getName());
        params.put("replace", replace);
        Map<String, String> headers = new HashMap<>();
        headers.put("authority", authority);
        AttachmentVO attachmentVO = null;

        try {
            // 签章文件上传文件中心
            String fileUploadRespStr = postFile(BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file);
            CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
            if (!attachmentResp.isSuccess()) {
                logger.error("签章文件上传失败：sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，原因：{}",
                        sourceId, sourceType, billType, file.getName(), replace, attachmentResp.getMsg());
                return null;
            }
            attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);
        } catch (Exception e) {
            logger.error("上传模板文件异常sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，",
                    sourceId, sourceType, billType, file.getName(), replace, e);
        }
        logger.info("签章文件上传成功：{}", JSONObject.toJSONString(attachmentVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return attachmentVO;
    }


    public List<SignMgrPreviewEntity> previewContract(Long sourceId, List<String> sourceTypes) {
        QueryParam param = new QueryParam();
        param.getParams().put("bill_id", new Parameter(QueryParam.EQ, sourceId));
        param.getParams().put("source_type", new Parameter(QueryParam.IN, sourceTypes));
        return signMgrPreviewService.queryList(param);
    }


    @Async("downloadFileTask")
    public void fileTask(Long contractId, int status, SignMgrEntity signMgrEntity, String authority, String billType, Long billId) {
        InvocationInfoProxy.setTenantid(signMgrEntity.getTenantId());
        String key = "userCode";
        int idx = authority.indexOf(";" + key + "=");
        if (idx >= 0) {
            String tmp = authority.substring(idx + 1);
            InvocationInfoProxy.setUsercode(tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
        }

        String sourceType = "signature_" + status;
        String fileName = String.format("%s_%d", signMgrEntity.getBillDocumentName(), billId);

        OutputStream out = null;
        File file;
        try {
            file = File.createTempFile(fileName, ".pdf");
            out = new FileOutputStream(file);
        } catch (Exception e) {
            logger.error("下载签章文件，失败！原因是：", e);
            throw new BusinessException("下载签章文件，失败！");
        }

        if (!file.isFile() || !file.exists()) {
            throw new BusinessException("初始化临时文件不存在！");
        }

        this.downloadHasSignedFile(contractId, out);
        logger.info("下载合同完成,业务ID为：{},契约锁合同ID为：{}", billId, contractId);

        // 文件转换成字符串
        String base64 = FileConvert.fileToBase64(file);

        // 保存文件预览表数据
        SignMgrPreviewEntity signMgrPreviewEntity = new SignMgrPreviewEntity();
        // 未删除
        signMgrPreviewEntity.setDelFlag(0);
        signMgrPreviewEntity.setBillId(billId);
        signMgrPreviewEntity.setBillType(billType);
        signMgrPreviewEntity.setSourceType(sourceType);
        signMgrPreviewEntity.setFileBase64(base64);
        signMgrPreviewEntity.setFileName(fileName);
        signMgrPreviewService.saveOrUpdate(signMgrPreviewEntity, false);

        // this.pushToFileCenter(file, authority, sourceType, billId, billType, "true");

        // 上传文件中心成功后删除
        file.delete();
        logger.info("删除签章文件：{},成功！", file.getName());
    }


    /**
     * 根据手机号查询用户信息和其所在公司信息
     *
     * @param contact
     * @return UserDetail
     */
    public UserDetail userDetail(String contact) {
        SDKClient client = getSdkClient();
        EmployeeService employeeService = new EmployeeServiceImpl(client);

        UserSearchRequest request = new UserSearchRequest();
        request.setMobile(contact);
        UserDetail result = null;
        try {
            result = employeeService.userDetail(request);
        } catch (PrivateAppException e) {
            logger.info("请求参数-contact：{}", contact);
            logger.error("根据手机号查询用户信息和其所在公司信息异常：", e);
            throw new BusinessException("根据手机号查询用户信息和其所在公司信息异常!");
        }
        logger.info("角色列表：{}", JSONUtils.toJson(result));
        return result;
    }

    /**
     * 根据合同id查询合同详情
     *
     * @param contractId 合同id
     * @param countSeal  是否统计印章
     * @return ContractDetail
     */
    @Override
    public ContractDetail detail(Long contractId, Boolean countSeal) {
        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        // 合同详情
        ContractDetail detail = null;
        try {
            detail = contractService.detail(contractId, true);
        } catch (PrivateAppException e) {
            logger.error("查看合同详情，失败！原因是：", e);
            throw new BusinessException("查看合同详情，失败！");
        }
        return detail;
    }

    /**
     * 合同预览链接
     *
     * @param contractId 契约锁合同id
     * @return 合同预览链接
     */
    @Override
    public String viewUrl(Long contractId) {
        SDKClient client = getSdkClient();
        ContractService contractService = new ContractServiceImpl(client);

        ViewUrlRequest request = new ViewUrlRequest();
        // 合同ID
        request.setContractId(contractId);
        // 页面预览类型：DETAIL（详情页），CONTENT（合同正文），默认DETAIL
        request.setPageType(ViewUrlRequest.PageType.CONTENT);
        // 链接过期时间
        request.setExpireTime(1800);
        // 隐藏返回栏
        request.setPageMode(ViewUrlRequest.PageMode.NOBACK);
        // 链接失效后跳转地址
        request.setInvalidToPage(BASE_HOST);
        request.setCanViewDetail(true);
        request.setCanReturn(true);
        String viewUrl = null;
        try {
            viewUrl = contractService.viewUrl(request);
        } catch (PrivateAppException e) {
            logger.error("获取合同预览链接，失败！原因是：", e);
            throw new BusinessException("获取合同预览链接，失败！");
        }
        logger.info("合同查看链接：{}", viewUrl);
        return viewUrl;
    }


}
