/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.enums.UserTypeEnum;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.utils.uploadFileCenter;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealCategory;
import net.qiyuesuo.sdk.bean.seal.SealCondition;
import net.qiyuesuo.sdk.bean.seal.SealPermissionGroupBean;
import net.qiyuesuo.sdk.bean.user.User;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.SealServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="sealManageService")
public class SealManageServiceImpl
implements ISealManageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private uploadFileCenter uploadFileCenter;
    @Autowired
    private IManagementService service;

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    @Override
    public List<Seal> sealList(Long companyId, String companyName, String category) {
        if (StringUtils.isBlank((CharSequence)companyName)) {
            throw new BusinessException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        List list = null;
        this.logger.info("\u6839\u636e\u516c\u53f8\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u5165\u53c2\uff1a{}", (Object)companyName);
        try {
            list = sealService.sealList(companyId, companyName, category);
        }
        catch (PrivateAppException e) {
            this.logger.error("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        return list;
    }

    @Override
    public Seal detail(Long sealId) {
        if (sealId == null) {
            throw new BusinessException("\u5370\u7ae0ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        Seal seal = null;
        try {
            seal = sealService.detail(sealId);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        return seal;
    }

    @Override
    @Async(value="downloadFileTask")
    public void replaceImgUrl(Long sealId, String authority, ManagementEntity entity) {
        File file;
        if (sealId == null) {
            throw new BusinessException("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\uff0c\u8bf7\u6c42\u7684\u5370\u7ae0id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\uff0c\u8bf7\u6c42\u7684\u5370\u7ae0ID-{}", (Object)sealId);
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        try {
            file = File.createTempFile(String.valueOf(sealId), ".png");
            FileOutputStream outputStream = new FileOutputStream(file);
            Seal request = new Seal();
            request.setId(sealId);
            try {
                sealService.image(request, (OutputStream)outputStream);
            }
            catch (PrivateAppException e) {
                this.logger.error("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\u5931\u8d25\uff01", (Throwable)e);
                throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u5370\u7ae0\u56fe\u7247\u5931\u8d25\uff01");
        }
        CommonResponse<List<AttachmentVO>> uploadResp = this.uploadFileCenter.uploadFile(file, authority, "seal", sealId, "BT211123000000005", "true", this.BASE_HOST);
        if (!uploadResp.isSuccess()) {
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff01");
        }
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)uploadResp.getData()));
        AttachmentVO attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)uploadResp.getData()).get(0)), AttachmentVO.class);
        String imgUrl = attachmentVO.getOnlinePath();
        entity.setImgUrl(imgUrl);
        this.service.saveOrUpdate((Object)entity, false);
        file.delete();
    }

    @Override
    public List<ManagementUserVO> getUsers(List<SealPermissionGroupBean> sealGroup, Boolean isAdmin) {
        ArrayList<ManagementUserVO> userList = new ArrayList<ManagementUserVO>();
        if (sealGroup != null) {
            for (SealPermissionGroupBean s : sealGroup) {
                ManagementUserVO m = new ManagementUserVO();
                m.setSourceUserId(s.getId());
                m.setSourceUserName(s.getName());
                List users = s.getUsers();
                if (!users.isEmpty()) {
                    for (User user : users) {
                        if (user == null) {
                            m.setSourcePhone(null);
                            m.setSourceEmail(null);
                        }
                        m.setSourcePhone(user.getMobile());
                        m.setSourceEmail(user.getEmail());
                    }
                }
                if (isAdmin.booleanValue()) {
                    m.setUserType(UserTypeEnum.MANGER.getTypeName());
                } else {
                    m.setUserType(UserTypeEnum.USER.getTypeName());
                }
                userList.add(m);
            }
        }
        return userList;
    }

    @Override
    public List<Company> companySealList() {
        SDKClient client = this.getSdkClient();
        SealServiceImpl sealService = new SealServiceImpl(client);
        List companyList = null;
        SealCondition sealCondition = new SealCondition();
        sealCondition.setCategory(SealCategory.ELECTRONIC);
        sealCondition.setSealQueryStatus("NORMAL");
        try {
            companyList = sealService.innercompanySealList(sealCondition);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
            throw new BusinessException("\u8bf7\u6c42\u5951\u7ea6\u9501\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        return companyList;
    }

    @Override
    public List<ManagementVO> querySealsByCompanyName(String companyName) {
        ArrayList<ManagementVO> list = new ArrayList<ManagementVO>();
        List<Seal> sealList = this.sealList(null, companyName, null);
        this.logger.info("\u8bf7\u6c42\u7684\u5370\u7ae0\u5217\u8868:{}", (Object)JSONObject.toJSONString(sealList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!sealList.isEmpty()) {
            for (Seal seal : sealList) {
                List<ManagementUserVO> su;
                Seal s = this.detail(seal.getId());
                this.logger.info("\u5f53\u524d\u5370\u7ae0id-{},\u5370\u7ae0\u8be6\u60c5:{}", (Object)seal.getId(), (Object)JSONObject.toJSONString((Object)s, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                ManagementVO managementVO = new ManagementVO();
                managementVO.setSourceSealId(s.getId());
                managementVO.setSourceSealName(s.getName());
                managementVO.setSealCategory(String.valueOf(seal.getCategory()));
                managementVO.setSourceKey(s.getSealKey());
                JSONObject jsonObject = JSONObject.parseObject((String)s.getStatus());
                switch (jsonObject.getString("key")) {
                    case "NORMAL": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                    case "FREEZE": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                    case "DELETE": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                    }
                    case "INVALID": {
                        managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + jsonObject.getString("key"));
                    }
                }
                managementVO.setSourceStatus(jsonObject.getString("key"));
                managementVO.setSealType(String.valueOf(s.getType()));
                managementVO.setSourceCompanyId(seal.getOwner());
                managementVO.setSourceCompanyName(seal.getOwnerName());
                managementVO.setSealSubTypeName(s.getSealCategoryName());
                List sealAdminGroup = s.getSealAdminGroup();
                List sealUseGroup = s.getSealUseGroup();
                ArrayList<ManagementUserVO> managementUsers = new ArrayList<ManagementUserVO>();
                List<ManagementUserVO> sa = this.getUsers(sealAdminGroup, true);
                if (sa != null) {
                    managementUsers.addAll(sa);
                }
                if ((su = this.getUsers(sealUseGroup, false)) != null) {
                    managementUsers.addAll(su);
                }
                managementVO.setUserEntityList(managementUsers);
                list.add(managementVO);
            }
        }
        this.logger.info("\u8fd4\u56de\u7684\u5370\u7ae0\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(list));
        return list;
    }

    @Override
    public List<ManagementVO> queryAllSeal() {
        ArrayList<ManagementVO> data = new ArrayList<ManagementVO>();
        List<Company> companyList = this.companySealList();
        this.logger.info("\u8bf7\u6c42\u7684\u516c\u53f8\u5217\u8868:{}", (Object)JSONObject.toJSONString(companyList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!companyList.isEmpty()) {
            for (Company company : companyList) {
                for (Seal seal : company.getSeals()) {
                    List<ManagementUserVO> su;
                    Seal s = this.detail(seal.getId());
                    this.logger.info("\u5f53\u524d\u516c\u53f8-{},\u5f53\u524d\u5370\u7ae0id-{},\u5370\u7ae0\u8be6\u60c5:{}", new Object[]{company.getName(), seal.getId(), JSONObject.toJSONString((Object)s, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
                    ManagementVO managementVO = new ManagementVO();
                    managementVO.setSourceSealId(s.getId());
                    managementVO.setSourceSealName(s.getName());
                    managementVO.setSealType(String.valueOf(s.getType()));
                    managementVO.setSourceKey(s.getSealKey());
                    JSONObject jsonObject = JSONObject.parseObject((String)s.getStatus());
                    switch (jsonObject.getString("key")) {
                        case "NORMAL": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                        case "FREEZE": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                        case "DELETE": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                        }
                        case "INVALID": {
                            managementVO.setSourceStatusDescription(jsonObject.getString("description"));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + jsonObject.getString("key"));
                        }
                    }
                    managementVO.setSourceStatus(jsonObject.getString("key"));
                    managementVO.setSealCategory(String.valueOf(seal.getCategory()));
                    managementVO.setSourceCompanyId(seal.getOwner());
                    managementVO.setSourceCompanyName(seal.getOwnerName());
                    managementVO.setSealSubTypeName(s.getSealCategoryName());
                    List sealAdminGroup = s.getSealAdminGroup();
                    List sealUseGroup = s.getSealUseGroup();
                    ArrayList<ManagementUserVO> managementUsers = new ArrayList<ManagementUserVO>();
                    List<ManagementUserVO> sa = this.getUsers(sealAdminGroup, true);
                    if (sa != null) {
                        managementUsers.addAll(sa);
                    }
                    if ((su = this.getUsers(sealUseGroup, false)) != null) {
                        managementUsers.addAll(su);
                    }
                    managementVO.setUserEntityList(managementUsers);
                    data.add(managementVO);
                }
            }
        }
        return data;
    }
}

