package com.ejianc.business.signaturemanage.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/20
 * @document: 签章设置
 */
@TableName("ejc_signmgr_signature_setting")
public class SignatureSettingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 单位名称
     */
    @TableField(value = "unit_name")
    private String unitName;
    /**
     * 单位类别
     */
    @TableField(value = "unit_category")
    private String unitCategory;
    /**
     * 状态，1-启用，0-停用
     */
    @TableField(value = "enable_status")
    private Integer enableStatus;

    /**
     * 默认用章名
     */
    @TableField(value = "default_seal_name")
    private String defaultSealName;
    /**
     * 单据编码
     */
    @TableField(value = "code")
    private String code;
    /**
     * 创建人 自用
     */
    @TableField(value = "create_name")
    private String createName;
    /**
     * 创建人 id 自用
     */
    @TableField(value = "create_id")
    private Long createId;


    /**
     * 创建时间 自用
     */
    @TableField(value = "seal_create_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sealCreateTime;
    /**
     * sub 字表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "signatureSettingSubService")
    private List<SignatureSettingSubEntity> settingSubVoS = new ArrayList<>();
    /**
     * 单位 id
     */
    @TableField(value = "unit_id")
    private Long unitId;


    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Date getSealCreateTime() {
        return sealCreateTime;
    }

    public void setSealCreateTime(Date sealCreateTime) {
        this.sealCreateTime = sealCreateTime;
    }

    public Long getCreateId() {
        return createId;
    }

    public void setCreateId(Long createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }


    public String getDefaultSealName() {
        return defaultSealName;
    }

    public void setDefaultSealName(String defaultSealName) {
        this.defaultSealName = defaultSealName;
    }

    public List<SignatureSettingSubEntity> getSettingSubVoS() {
        return settingSubVoS;
    }

    public void setSettingSubVoS(List<SignatureSettingSubEntity> settingSubVoS) {
        this.settingSubVoS = settingSubVoS;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitCategory() {
        return unitCategory;
    }

    public void setUnitCategory(String unitCategory) {
        this.unitCategory = unitCategory;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }
}
