package com.ejianc.business.signaturemanage.controller.api;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.ejianc.business.signaturemanage.service.ISignatureCommonService;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description 签章通用接口实现控制器
 */
@RestController
@RequestMapping(value = "/common")
public class SignatureCommonApi {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISignatureCommonService service; // 签章通用服务


    /**
     * 合同文件添加水印
     *
     * @param watermarkVO 合同文件添加水印参数
     * @param response    响应
     */
    @PostMapping(value = "/addWatermark")
    public void addWatermark(@Validated @RequestBody WatermarkVO watermarkVO, HttpServletResponse response) throws IOException {
        File file = service.addWatermark(watermarkVO);
        Assert.notNull(file, "合同文件添加水印失败！");
        BufferedInputStream in = FileUtil.getInputStream(file);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + file.getName());
        response.setContentType(String.valueOf(MediaType.APPLICATION_PDF));
        OutputStream out = response.getOutputStream();
        IoUtil.copy(in, out);
        out.flush();
        in.close();
        service.cleanFile(file);
    }
}
