/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.ejianc.business.signaturemanage.service.ISignatureCommonService;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class SignatureCommonApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignatureCommonService service;

    @PostMapping(value={"/addWatermark"})
    public void addWatermark(@Validated @RequestBody WatermarkVO watermarkVO, HttpServletResponse response) throws IOException {
        File file = this.service.addWatermark(watermarkVO);
        Assert.notNull((Object)file, (String)"\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
        BufferedInputStream in = FileUtil.getInputStream((File)file);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + file.getName());
        response.setContentType(String.valueOf(MediaType.APPLICATION_PDF));
        ServletOutputStream out = response.getOutputStream();
        IoUtil.copy((InputStream)in, (OutputStream)out);
        out.flush();
        in.close();
        this.service.cleanFile(file);
    }
}

