/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.signaturemanage.enums.WatermarkSchemeEnum;
import com.ejianc.business.signaturemanage.service.ISignatureCommonService;
import com.ejianc.business.signaturemanage.vo.WatermarkConfigVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.contract.WaterMarkContent;
import net.qiyuesuo.sdk.bean.contract.WaterMarkLocation;
import net.qiyuesuo.sdk.bean.contract.WaterMarkType;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.document.DownloadDocRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="signatureCommonService")
public class SignatureCommonServiceImpl
implements ISignatureCommonService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Function<WatermarkVO, File>> watermarkMap = new HashMap<String, Function<WatermarkVO, File>>();
    @Value(value="${ejc.fileServerUrl}")
    private String FILE_HOST;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;

    @PostConstruct
    public void watermarkDispatcher() {
        this.watermarkMap.put(WatermarkSchemeEnum.QI_YUE_SUO.getCode(), watermarkVO -> {
            try {
                return this.addWatermarkIfQiyuesuo((WatermarkVO)watermarkVO);
            }
            catch (IOException iOException) {
                return null;
            }
        });
    }

    @Override
    public File addWatermark(WatermarkVO watermarkVO) {
        Function<WatermarkVO, File> res = this.watermarkMap.get(watermarkVO.getScheme());
        Assert.notNull(res, (String)"\u5408\u540c\u6dfb\u52a0\u6c34\u5370\u7684\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        return res.apply(watermarkVO);
    }

    @Override
    @Async(value="commonTask")
    public void cleanFile(File file) throws IOException {
        Files.delete(Paths.get(file.getPath(), new String[0]));
    }

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    private File addWatermarkIfQiyuesuo(WatermarkVO watermarkVO) throws IOException {
        this.logger.info("\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat}));
        CommonResponse res = this.attachmentApi.queryDetail(String.valueOf(watermarkVO.getBillId()));
        if (!res.isSuccess()) {
            this.logger.error(res.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
        }
        AttachmentVO attachmentVO = (AttachmentVO)res.getData();
        this.logger.info("\u5408\u540c\u6587\u4ef6\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)attachmentVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat}));
        String contractUrl = this.FILE_HOST + attachmentVO.getFilePath();
        Assert.hasText((String)contractUrl, (String)"\u5408\u540c\u6587\u4ef6\u7f51\u7edc\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String fullName = attachmentVO.getFileName();
        String contractTitle = fullName.substring(0, fullName.lastIndexOf("."));
        Assert.hasText((String)contractTitle, (String)"\u5408\u540c\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String contractFileType = fullName.substring(fullName.lastIndexOf(".") + 1);
        Assert.hasText((String)contractFileType, (String)"\u5408\u540c\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SDKClient sdkClient = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(sdkClient);
        ArrayList<WaterMarkContent> waterMarks = new ArrayList<WaterMarkContent>();
        for (WatermarkConfigVO vo : watermarkVO.getWatermarkConfigs()) {
            WaterMarkContent waterMarkContent = new WaterMarkContent();
            waterMarkContent.setType(WaterMarkType.valueOf((String)vo.getType()));
            waterMarkContent.setContent(vo.getContent());
            waterMarkContent.setImageBase64(vo.getImageBase64());
            waterMarkContent.setFontSize(vo.getFontSize());
            waterMarkContent.setColor(vo.getColor());
            waterMarkContent.setRotateAngle(vo.getRotateAngle());
            waterMarkContent.setTransparency(vo.getTransparency());
            waterMarkContent.setLocation(WaterMarkLocation.valueOf((String)vo.getLocation()));
            waterMarks.add(waterMarkContent);
        }
        DocumentCreateByUrl documentCreateByUrl = new DocumentCreateByUrl(contractUrl, contractTitle, contractFileType, waterMarks);
        Long documentId = null;
        try {
            documentId = contractService.createDocumentByUrl(documentCreateByUrl);
        }
        catch (PrivateAppException e) {
            throw new BusinessException(e.getMessage());
        }
        this.logger.info("\u5408\u540c\u6587\u6863id--{}", (Object)documentId);
        DownloadDocRequest request = new DownloadDocRequest();
        File file = File.createTempFile(contractTitle, ".pdf");
        BufferedOutputStream out = FileUtil.getOutputStream((File)file);
        request.setDocumentId(documentId);
        request.setContact(contractTitle);
        request.setOutputStream((OutputStream)out);
        try {
            contractService.downloadDoc(request);
        }
        catch (PrivateAppException e) {
            throw new BusinessException(e.getMessage());
        }
        return file;
    }
}

