package com.ejianc.business.signaturemanage.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value = "uploadFileCenter")
public class UploadFileCenter {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String postFile(String url, Map<String, String> params, Map<String, String> headers, File file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        // 限制一分钟
        Integer readTimeout = 600000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(StandardCharsets.UTF_8).addBinaryBody("file",
                    new FileInputStream(file), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getName());
            for (String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(connTimeout);

            customReqConf.setSocketTimeout(readTimeout);

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;

                for (String s : headers.keySet()) {
                    key = s;
                    post.addHeader(key, headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
            }
            res = client.execute(post);

            result = org.apache.commons.io.IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null) {
                client.close();
            }
        }

        return result;
    }

    public CommonResponse<List<AttachmentVO>> uploadFile(File file, String authority, String sourceType, Long sourceId, String billType, String replace, String BASE_HOST) {
        CommonResponse<List<AttachmentVO>> attachmentResp = new CommonResponse<>();
        Map<String, String> params = new HashMap<>();
        params.put("sourceType", sourceType);
        params.put("sourceId", String.valueOf(sourceId));
        params.put("billType", billType);
        params.put("originalFileNameStr", file.getName());
        params.put("replace", replace);
        Map<String, String> headers = new HashMap<>();
        headers.put("authority", authority);
        AttachmentVO attachmentVO = null;

        try {
            // 签章文件上传文件中心
            String fileUploadRespStr = postFile(BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file);
            attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
            if (!attachmentResp.isSuccess()) {
                logger.error("文件上传失败：sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，原因：{}",
                        sourceId, sourceType, billType, file.getName(), replace, attachmentResp.getMsg());
            }
            attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);

        } catch (Exception e) {
            logger.error("上传模板文件异常sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，",
                    sourceId, sourceType, billType, file.getName(), replace, e);
        }
        logger.info("文件上传成功：{}", JSONObject.toJSONString(attachmentVO));
        return attachmentResp;
    }

}
