/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.ejianc.business.signaturemanage.service.ISignatureCommonService;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.google.common.base.Stopwatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class SignatureCommonApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignatureCommonService service;

    @PostMapping(value={"/addWatermark"}, consumes={"application/json;charset=UTF-8"})
    public void addWatermark(@Validated @RequestBody WatermarkVO watermarkVO, HttpServletResponse response) throws IOException {
        File file = this.service.addWatermark(watermarkVO);
        Assert.notNull((Object)file, (String)"\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
        BufferedInputStream in = FileUtil.getInputStream((File)file);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + file.getName());
        response.setContentType("application/pdf");
        ServletOutputStream out = response.getOutputStream();
        IoUtil.copy((InputStream)in, (OutputStream)out);
        out.flush();
        in.close();
        out.close();
        this.service.cleanFile(file);
    }

    @PostMapping(value={"/fetchWatermarkAttachment"})
    public AttachmentVO fetchWatermarkAttachment(@RequestBody WatermarkVO watermarkVO, HttpServletRequest request) throws IOException {
        this.logger.info("\u83b7\u53d6\u52a0\u6c34\u5370\u7684\u5408\u540c\u9644\u4ef6\uff0c\u5f00\u59cb");
        Stopwatch start = Stopwatch.createStarted();
        String authority = request.getHeader("authority");
        Assert.hasText((String)authority, (String)"\u83b7\u53d6\u52a0\u6c34\u5370\u7684\u5408\u540c\u9644\u4ef6\uff0c\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        File file = this.service.addWatermark(watermarkVO);
        Assert.notNull((Object)file, (String)"\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
        Assert.notNull((Object)watermarkVO.getBillId(), (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)watermarkVO.getBillType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)watermarkVO.getSourceType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AttachmentVO attachmentVO = this.service.fetchAttachment(file, authority, watermarkVO);
        this.service.cleanFile(file);
        Stopwatch end = start.stop();
        this.logger.info("\u83b7\u53d6\u52a0\u6c34\u5370\u7684\u5408\u540c\u9644\u4ef6\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u6beb\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
        return attachmentVO;
    }
}

