package com.ejianc.business.signaturemanage.common;

import com.ejianc.framework.core.response.CommonResponse;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.validation.ConstraintViolationException;

/**
 * @author baipengyan
 * @date 2022/5/18
 * @description
 */
@RestControllerAdvice
public class CommonExceptionHandler {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value = {MethodArgumentNotValidException.class})
    public CommonResponse<String> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        StringBuilder sb = new StringBuilder("参数校验失败:");
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            sb.append(fieldError.getField()).append("：").append(fieldError.getDefaultMessage()).append(", ");
        }
        String msg = sb.toString();
        logger.error("MethodArgumentNotValidException--{}", msg);
        return CommonResponse.error(msg);
    }

    @ExceptionHandler(value = {ConstraintViolationException.class})
    public CommonResponse<String> constraintViolationExceptionHandler(ConstraintViolationException e) {
        logger.error("ConstraintViolationException--{}", e.getMessage());
        return CommonResponse.error(e.getMessage());
    }

    @ExceptionHandler(value = {IllegalArgumentException.class})
    public CommonResponse<String> illegalArgumentExceptionHandler(IllegalArgumentException e) {
        logger.error("IllegalArgumentException--{}", e.getMessage());
        return CommonResponse.error(e.getMessage());
    }

    /**
     * 契约锁异常
     *
     * @param e 契约锁异常
     * @return CommonResponse<String> 契约锁异常信息
     */
    @ExceptionHandler(value = {PrivateAppException.class})
    public CommonResponse<String> privateAppExceptionHandler(PrivateAppException e) {
        logger.error("PrivateAppException--{}", e.getMessage());
        return CommonResponse.error(e.getMessage());
    }

}
