package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;

import java.io.File;
import java.io.IOException;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description
 */
public interface ISignatureCommonService {

	/**
	 * 合同添加水印
	 *
	 * @param watermarkVO 合同文件添加水印参数
	 */
	File addWatermark(WatermarkVO watermarkVO);

	/**
	 * 删除临时文件
	 *
	 * @param file 要删除的文件
	 */
	void cleanFile(File file) throws IOException;

	/**
	 * 水印文件上传文件中心
	 *
	 * @param file        水印文件
	 * @param authority   上下文
	 * @param watermarkVO 合同文件添加水印参数
	 *
	 * @return AttachmentVO 水印附件
	 */
	AttachmentVO fetchAttachment(File file, String authority, WatermarkVO watermarkVO);

	/**
	 * @param fileId     要加水印的文件id
	 * @param billId     业务id
	 * @param billCode   合同编码
	 * @param billType   单据类型编码
	 * @param sourceType 业务类型编码
	 *
	 * @return WatermarkVO 水印配置
	 */
	WatermarkVO watermarkConfigConvert(Long fileId, Long billId, String billCode, String billType, String sourceType);
}
