package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.vo.SignatureVO;

/**
 * @author baipengyan
 * @date 2022/6/2
 * @description 签章定位业务接口
 */
public interface ISignatureRectService {

	void deleteSignatureRect();

	/**
	 * 获取预签署链接
	 *
	 * @param signatureVO 发起签章VO
	 *
	 * @return String 预签署链接
	 */
	String fetchPreSignUrl(SignatureVO signatureVO);

	/**
	 * 发起签章
	 *
	 * @param contractId PM系统合同id
	 */
	void sendSignature(Long contractId);

}
