package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.ManagementUserEntity;
import com.ejianc.business.signaturemanage.mapper.ManagementMapper;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author:刘家乐
 * @version:
 * @document:
 */
@Service("managementService")
public class ManagementServiceImpl extends BaseServiceImpl<ManagementMapper, ManagementEntity>
        implements IManagementService {
    /**
     * 此处需要根据实际修改
     */
    private static final String BILL_CODE = "LJL_MANAGEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IManagementService service;
    @Autowired
    private ISealManageService sealManageService;
    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IOrgApi orgApi;

    @Value("${seal.defaultSealPng.personal}")
    private String personalImgUrl;

    public String getPersonalImgUrl() {
        return personalImgUrl;
    }

    public void setPersonalImgUrl(String personalImgUrl) {
        this.personalImgUrl = personalImgUrl;
    }

    @Override
    public CommonResponse<ManagementVO> updateManagement(ManagementVO vo) {
        ManagementEntity managementEntity = this.selectById(vo.getId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", managementEntity.getId()));
        queryParam.getParams().put("user_type", new Parameter("eq", "user"));
        List<ManagementUserEntity> managementUserEntities = userService.queryList(queryParam);
        if (!managementUserEntities.isEmpty()) {
            userService.deleteUserByIdList(managementUserEntities.stream().map(ManagementUserEntity::getId).collect(Collectors.toList()));
        }
        //修改组织 根据组织设置 tenantId
        if (null != vo.getOrgId()) {
            managementEntity.setOrgId(vo.getOrgId());
            CommonResponse<OrgVO> oneById = orgApi.getOneById(vo.getOrgId());
            managementEntity.setOrgName(vo.getOrgName());
            managementEntity.setTenantId(oneById.getData().getTenantId());
            managementEntity.setIsMatch(1);
        }
        List<ManagementUserEntity> userEntities = BeanMapper.mapList(vo.getUserEntityList(), ManagementUserEntity.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (ManagementUserEntity u : userEntities) {
            stringBuilder.append(u.getUserName());
            stringBuilder.append(",");
            u.setUserType("user");
            if (1 == u.getIsDefault()) {
                managementEntity.setSealDefaultId(u.getId());
                managementEntity.setSealDefaultName(u.getUserName());
            }
        }
        // 合同专用章 1：是，0：否
        managementEntity.setContractSealFlag(vo.getContractSealFlag());
        managementEntity.setSealUseName(stringBuilder.toString());
        managementEntity.setUserEntityList(userEntities);
        this.saveOrUpdate(managementEntity, false);
        List<ManagementUserVO> managementUserVoS = BeanMapper.mapList(userEntities, ManagementUserVO.class);
        ManagementVO map = BeanMapper.map(managementEntity, ManagementVO.class);
        map.setUserEntityList(managementUserVoS);
        return CommonResponse.success(map);
    }


    /**
     * 通过 SourceSealId 查询本地是否存在改印章
     *
     * @param managementEntity 1
     * @return 1
     */
    private ManagementEntity bySourceSealId(ManagementEntity managementEntity) {
        QueryWrapper<ManagementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_seal_id", managementEntity.getSourceSealId());
        return this.getOne(queryWrapper);
    }

    /**
     * 本地不存在
     *
     * @param managementEntity 执行新增
     */
    private void newManagement(ManagementEntity managementEntity) {
        //新增
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            managementEntity.setBillCode(billCode.getData());
            //需要判断是否匹配
            OrgVO orgVO = new OrgVO();
            orgVO.setTenantId(InvocationInfoProxy.getTenantid());
            orgVO.setName(managementEntity.getSourceCompanyName());
            CommonResponse<OrgVO> oneByOrgVO = orgApi.findOneByOrgVO(orgVO);
            if (oneByOrgVO.isSuccess()) {
                if (null != oneByOrgVO.getData()) {
                    this.checkPerson(oneByOrgVO.getData());
                    managementEntity.setTenantId(oneByOrgVO.getData().getTenantId());
                    managementEntity.setOrgName(oneByOrgVO.getData().getName());
                    managementEntity.setOrgId(oneByOrgVO.getData().getId());
                    managementEntity.setEnableStatus(1);
                    managementEntity.setIsMatch(1);
                } else {
                    managementEntity.setEnableStatus(0);
                    managementEntity.setIsMatch(0);
                }
            }
            // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
            if ("合同专用章".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }
            if ("NORMAL".equals(managementEntity.getSourceStatus())) {
                managementEntity.setEnableStatus(1);
            } else {
                managementEntity.setEnableStatus(0);
            }
            this.saveOrUpdate(managementEntity);
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    /**
     * 同步开始
     *
     * @param managementEntity 同步开始
     */
    @Override
    public void syncUpdate(ManagementEntity managementEntity, String authority) {
        ManagementEntity entity = this.bySourceSealId(managementEntity);
        if (null == entity) {
            //当前 印章本地不存在 执行新增策略
            this.newManagement(managementEntity);
        } else {
            //当前 印章本地存在 执行修改策略
            entity.setSourceCompanyId(managementEntity.getSourceCompanyId());
            entity.setSourceCompanyName(managementEntity.getSourceCompanyName());
            entity.setSourceStatus(managementEntity.getSourceStatus());
            entity.setSealSubTypeName(managementEntity.getSealSubTypeName());
            entity.setEnableStatus(managementEntity.getEnableStatus());
            entity.setSourceSealName(managementEntity.getSourceSealName());
            entity.setSourceSealId(managementEntity.getSourceSealId());
            if (StringUtils.isNotEmpty(managementEntity.getSourceStatusDescription())) {
                entity.setSourceStatusDescription(managementEntity.getSourceStatusDescription());
            }
            if (StringUtils.isNotEmpty(managementEntity.getSealType())) {
                entity.setSealType(managementEntity.getSealType());
            }
            // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
            if ("合同专用章".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }

            this.saveOrUpdate(entity, false);
        }

    }

    //查询当前组织下是否有 是否有类型是 person的印章（校验个人印章）
    public void checkPerson(OrgVO orgVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgVO.getId()));
        queryParam.getParams().put("sealType", new Parameter(QueryParam.EQ, "PERSONAL"));
        List<ManagementEntity> managementEntities = this.queryList(queryParam, false);
        if (managementEntities.isEmpty()) {
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                ManagementEntity entity = new ManagementEntity();
                entity.setOrgId(orgVO.getId());
                entity.setOrgName(orgVO.getName());
                entity.setIsMatch(1);
                entity.setSourceStatus("NORMAL");
                entity.setTenantId(InvocationInfoProxy.getTenantid());
                entity.setBillCode(billCode.getData());
                entity.setSealSubTypeName("个人");
                entity.setImgUrl(personalImgUrl);
                entity.setSealCategory("ELECTRONIC");
                entity.setSealType("PERSONAL");
                entity.setSourceSealId(IdWorker.getId());
                entity.setSourceSealName("个人签章");
                entity.setSourceCompanyName(orgVO.getName());
                this.saveOrUpdate(entity, false);
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        }
    }


    /**
     * 批量处理保存和更新
     *
     * @param entityList 印章管理实体列表
     */
    @Override
    public void batchSaveOrUpdate(List<ManagementEntity> entityList) {
        List<Long> sealIds = entityList.parallelStream().map(ManagementEntity::getSourceSealId).collect(Collectors.toList());
        Map<Long, ManagementEntity> entityListMap = entityList.stream().collect(Collectors.toMap(ManagementEntity::getSourceSealId, Function.identity(), (k1, k2) -> k2));
        // 已存在的更新
        QueryWrapper<ManagementEntity> wrapper = new QueryWrapper<>();
        wrapper.in("source_seal_id", sealIds);
        List<ManagementEntity> updateEntities = service.list(wrapper);
        // 不存在的新增
        List<Long> updateSealIds = updateEntities.parallelStream().map(ManagementEntity::getSourceSealId).collect(Collectors.toList());
        List<ManagementEntity> insertEntities = entityList.parallelStream().filter(e -> !updateSealIds.contains(e.getSourceSealId())).collect(Collectors.toList());
        if (!insertEntities.isEmpty()) {
            this.batchSave(insertEntities);
        }
        if (!updateEntities.isEmpty()) {
            this.batchUpdate(updateEntities, entityListMap);
        }

    }

    /**
     * 批量处理保存
     *
     * @param entityList 印章管理实体列表
     */
    @Override
    public void batchSave(List<ManagementEntity> entityList) {

        // 查询所有个人章的信息
        QueryWrapper<ManagementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("seal_type", "PERSONAL");
        List<ManagementEntity> personal = service.list(queryWrapper);
        Map<String, ManagementEntity> personalMap = personal.stream().collect(Collectors.toMap(ManagementEntity::getSourceCompanyName, Function.identity(), (k1, k2) -> k2));


        OrgVO orgVO = new OrgVO();
        orgVO.setTenantId(InvocationInfoProxy.getTenantid());
        // 保存匹配的组织信息
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        for (ManagementEntity managementEntity : entityList) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            managementEntity.setBillCode(billCode.getData());

            // map有值说明匹配上了
            if (orgVOMap.containsKey(managementEntity.getSourceCompanyName())) {
                OrgVO orgVO1 = orgVOMap.get(managementEntity.getSourceCompanyName());
                // 匹配上没有个人章的新增个人章
                if (!personalMap.containsKey(managementEntity.getSourceCompanyName())) {
                    CommonResponse<String> billCode2 = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    ManagementEntity entity = new ManagementEntity();
                    entity.setOrgId(orgVO1.getId());
                    entity.setOrgName(orgVO1.getName());
                    entity.setIsMatch(1);
                    entity.setSourceStatus("NORMAL");
                    entity.setTenantId(InvocationInfoProxy.getTenantid());
                    entity.setBillCode(billCode2.getData());
                    entity.setSealSubTypeName("个人");
                    entity.setImgUrl(personalImgUrl);
                    entity.setSealCategory("ELECTRONIC");
                    entity.setSealType("PERSONAL");
                    entity.setSourceSealId(IdWorker.getId());
                    entity.setSourceSealName("个人签章");
                    entity.setSourceCompanyName(orgVO1.getName());

                    // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
                    managementEntity.setContractSealFlag("合同专用章".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                    managementEntity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);

                    this.saveOrUpdate(entity, false);
                    personalMap.put(entity.getSourceCompanyName(), entity);
                }
                managementEntity.setTenantId(orgVO1.getTenantId());
                managementEntity.setOrgName(orgVO1.getName());
                managementEntity.setOrgId(orgVO1.getId());
                managementEntity.setEnableStatus(1);
                managementEntity.setIsMatch(1);

                // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
                managementEntity.setContractSealFlag("合同专用章".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                managementEntity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);
            } else {
                orgVO.setName(managementEntity.getSourceCompanyName());
                CommonResponse<OrgVO> oneByOrgVO = orgApi.findOneByOrgVO(orgVO);
                if (oneByOrgVO.isSuccess()) {
                    if (oneByOrgVO.getData() != null) {
                        // // 匹配上没有个人章的新增个人章
                        if (!personalMap.containsKey(managementEntity.getSourceCompanyName())) {
                            CommonResponse<String> billCode1 = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                            if (!billCode.isSuccess()) {
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                            ManagementEntity entity = new ManagementEntity();
                            entity.setOrgId(oneByOrgVO.getData().getId());
                            entity.setOrgName(oneByOrgVO.getData().getName());
                            entity.setIsMatch(1);
                            entity.setSourceStatus("NORMAL");
                            entity.setTenantId(InvocationInfoProxy.getTenantid());
                            entity.setBillCode(billCode1.getData());
                            entity.setSealSubTypeName("个人");
                            entity.setImgUrl(personalImgUrl);
                            entity.setSealCategory("ELECTRONIC");
                            entity.setSealType("PERSONAL");
                            entity.setSourceSealId(IdWorker.getId());
                            entity.setSourceSealName("个人签章");
                            entity.setSourceCompanyName(oneByOrgVO.getData().getName());

                            // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
                            managementEntity.setContractSealFlag("合同专用章".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                            managementEntity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);

                            this.saveOrUpdate(entity, false);
                            personalMap.put(entity.getSourceCompanyName(), entity);
                        }
                        // 配上了保存到map中
                        orgVOMap.put(managementEntity.getSourceCompanyName(), oneByOrgVO.getData());
                        managementEntity.setTenantId(oneByOrgVO.getData().getTenantId());
                        managementEntity.setOrgName(oneByOrgVO.getData().getName());
                        managementEntity.setOrgId(oneByOrgVO.getData().getId());
                        managementEntity.setEnableStatus(1);
                        managementEntity.setIsMatch(1);
                    } else {
                        managementEntity.setEnableStatus(0);
                        managementEntity.setIsMatch(0);
                    }

                    // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
                    managementEntity.setContractSealFlag("合同专用章".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                    managementEntity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);
                }
            }
        }
        logger.info("entityList>>>>>>>>>{}", entityList.size());
        service.saveBatch(entityList);

    }

    /**
     * 批量处理更新
     *
     * @param updateEntities 要更新的印章管理实体列表
     * @param entityListMap  同步数据的map
     */
    @Override
    public void batchUpdate(List<ManagementEntity> updateEntities, Map<Long, ManagementEntity> entityListMap) {
        Boolean flag = false;
        for (ManagementEntity entity : updateEntities) {
            ManagementEntity e = entityListMap.get(entity.getSourceSealId());

            if (!Objects.equals(entity.getSourceCompanyId(), e.getSourceCompanyId()) || !e.getSourceCompanyName().equals(entity.getSourceCompanyName())
                    || !e.getSourceStatus().equals(entity.getSourceStatus()) || !e.getSealSubTypeName().equals(entity.getSealSubTypeName())
                    || !Objects.equals(e.getEnableStatus(), entity.getEnableStatus()) || !e.getSourceSealName().equals(entity.getSourceSealName())
                    || !Objects.equals(e.getSourceSealId(), entity.getSourceSealId())
                    || !e.getSourceStatusDescription().equals(entity.getSourceStatusDescription())
                    || !e.getSealType().equals(entity.getSealType())
            ) {
                logger.info("当前印章需要更新--{}", JSONObject.toJSONString(entity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                flag = true;
                entity.setSourceCompanyId(e.getSourceCompanyId());
                entity.setSourceCompanyName(e.getSourceCompanyName());
                entity.setSourceStatus(e.getSourceStatus());
                entity.setSealSubTypeName(e.getSealSubTypeName());
                entity.setEnableStatus(e.getEnableStatus());
                entity.setSourceSealName(e.getSourceSealName());
                entity.setSourceSealId(e.getSourceSealId());
                entity.setSourceStatusDescription(e.getSourceStatusDescription());
                entity.setSealType(e.getSealType());

                // 根据印章分类名称（小类）判断是否是合同专用章 1：是，0：否
                entity.setContractSealFlag("合同专用章".equals(e.getSealSubTypeName()) ? 1 : 0);
                entity.setEnableStatus("NORMAL".equals(e.getSourceStatus()) ? 1 : 0);
            }


        }
        logger.info("entityList>>>>>>>>>{}", updateEntities.size());
        if (Boolean.TRUE.equals(flag)) {
            service.saveOrUpdateBatch(updateEntities);
        }
    }


    /**
     * 异步更新印章图片地址
     *
     * @param sealIds   印章id
     * @param authority 上下文
     */
    @Override
    public void syncUpdateImgUrl(List<Long> sealIds, String authority) {
        if (!sealIds.isEmpty()) {
            QueryWrapper<ManagementEntity> wrapper = new QueryWrapper<>();
            wrapper.in("source_seal_id", sealIds);
            List<ManagementEntity> entityList = service.list(wrapper);
            for (ManagementEntity e : entityList) {
                if (StringUtils.isBlank(e.getImgUrl())) {
                    sealManageService.replaceImgUrl(e.getSourceSealId(), authority, e);
                }
            }
        }
    }


}


